/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.portal;

import cpw.mods.fml.common.FMLCommonHandler;
import enhancedportals.block.BlockPortal;
import enhancedportals.item.ItemPortalModule;
import enhancedportals.network.CommonProxy;
import enhancedportals.portal.PortalException;
import enhancedportals.tile.TileController;
import enhancedportals.tile.TilePortalManipulator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S06PacketUpdateHealth;
import net.minecraft.network.play.server.S07PacketRespawn;
import net.minecraft.network.play.server.S1DPacketEntityEffect;
import net.minecraft.network.play.server.S1FPacketSetExperience;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidBase;

public class EntityManager {
    static Random rand = new Random();
    static final int PLAYER_COOLDOWN_RATE = 10;

    static ChunkCoordinates getActualExitLocation(Entity entity, TileController controller) {
        World world = controller.func_145831_w();
        int entityHeight = Math.round(entity.field_70131_O);
        boolean horizontal = controller.portalType == 3;
        block0: for (ChunkCoordinates c : new ArrayList<ChunkCoordinates>(controller.getPortals())) {
            for (int i = 0; i < entityHeight; ++i) {
                if (world.func_147439_a(c.field_71574_a, c.field_71572_b + i, c.field_71573_c) != BlockPortal.instance && !world.func_147437_c(c.field_71574_a, c.field_71572_b + i, c.field_71573_c)) continue block0;
            }
            if (horizontal && !world.func_147437_c(c.field_71574_a, c.field_71572_b + 1, c.field_71573_c)) {
                return new ChunkCoordinates(c.field_71574_a, c.field_71572_b - 1, c.field_71573_c);
            }
            return new ChunkCoordinates(c.field_71574_a, c.field_71572_b, c.field_71573_c);
        }
        return null;
    }

    static float getRotation(Entity entity, TileController controller, ChunkCoordinates loc) {
        ItemStack s;
        World world = controller.func_145831_w();
        TilePortalManipulator module = controller.getModuleManipulator();
        if (module != null && (s = module.getModule("ep3." + ItemPortalModule.PortalModules.FACING.ordinal())) != null) {
            NBTTagCompound tag = s.func_77978_p();
            int facing = 0;
            if (tag != null) {
                facing = tag.func_74762_e("facing");
            }
            return (float)facing * 90.0f - 180.0f;
        }
        if (controller.portalType == 1) {
            if (world.isSideSolid(loc.field_71574_a, loc.field_71572_b, loc.field_71573_c + 1, ForgeDirection.NORTH)) {
                return 180.0f;
            }
            return 0.0f;
        }
        if (controller.portalType == 2) {
            if (world.isSideSolid(loc.field_71574_a - 1, loc.field_71572_b, loc.field_71573_c, ForgeDirection.EAST)) {
                return -90.0f;
            }
            return 90.0f;
        }
        if (controller.portalType == 4) {
            if (world.func_147445_c(loc.field_71574_a + 1, loc.field_71572_b, loc.field_71573_c + 1, true)) {
                return 135.0f;
            }
            return -45.0f;
        }
        if (controller.portalType == 5) {
            if (world.func_147445_c(loc.field_71574_a - 1, loc.field_71572_b, loc.field_71573_c + 1, true)) {
                return -135.0f;
            }
            return 45.0f;
        }
        return entity.field_70177_z;
    }

    static void handleMomentum(Entity entity, int touchedPortalType, int exitPortalType, float exitYaw, boolean keepMomentum) {
        if (!keepMomentum) {
            entity.field_70179_y = 0.0;
            entity.field_70181_x = 0.0;
            entity.field_70159_w = 0.0;
            return;
        }
        if (touchedPortalType == 1) {
            if (exitPortalType == 2) {
                double temp = entity.field_70179_y;
                entity.field_70179_y = entity.field_70159_w;
                entity.field_70159_w = exitYaw == -90.0f ? -temp : temp;
            } else if (exitPortalType == 3) {
                double temp = entity.field_70179_y;
                entity.field_70179_y = entity.field_70181_x;
                entity.field_70181_x = temp;
            } else if (exitPortalType == 4) {
                double temp = entity.field_70179_y;
                entity.field_70179_y = entity.field_70181_x;
                entity.field_70181_x = -temp;
            }
        } else if (touchedPortalType == 2) {
            if (exitPortalType == 1) {
                double temp = entity.field_70179_y;
                entity.field_70179_y = entity.field_70159_w;
                entity.field_70159_w = exitYaw == 0.0f ? -temp : temp;
            } else if (exitPortalType == 3) {
                double temp = entity.field_70159_w;
                entity.field_70159_w = entity.field_70181_x;
                entity.field_70181_x = temp;
            } else if (exitPortalType == 4) {
                double temp = entity.field_70159_w;
                entity.field_70159_w = entity.field_70181_x;
                entity.field_70181_x = -temp;
            }
        } else if (touchedPortalType == 3 || touchedPortalType == 4) {
            if (exitPortalType == 1) {
                double temp = entity.field_70181_x;
                entity.field_70181_x = entity.field_70179_y;
                entity.field_70179_y = exitYaw == 0.0f ? -temp : temp;
            } else if (exitPortalType == 2) {
                double temp = entity.field_70181_x;
                entity.field_70181_x = entity.field_70159_w;
                entity.field_70159_w = exitYaw == -90.0f ? -temp : temp;
            } else if (exitPortalType == 3) {
                entity.field_70181_x = touchedPortalType == 3 ? -entity.field_70181_x : entity.field_70181_x;
            }
        }
        entity.field_70133_I = true;
    }

    public static boolean isEntityFitForTravel(Entity entity) {
        return entity != null && entity.field_71088_bW == 0;
    }

    public static void setEntityPortalCooldown(Entity entity) {
        if (entity == null) {
            return;
        }
        entity.field_71088_bW = CommonProxy.CONFIG_FASTER_PORTAL_COOLDOWN || entity instanceof EntityPlayer || entity instanceof EntityMinecart || entity instanceof EntityBoat || entity instanceof EntityHorse ? (entity.field_71088_bW == -1 ? 0 : 10) : (entity.field_71088_bW == -1 ? 0 : 300);
    }

    public static void teleportEntityHighestInstability(Entity par1Entity) {
        ChunkCoordinates spawn = par1Entity.field_70170_p.func_72861_E();
        spawn.field_71572_b = par1Entity.field_70170_p.func_72825_h(spawn.field_71574_a, spawn.field_71572_b);
        if (par1Entity.field_70170_p.func_147437_c(spawn.field_71574_a, spawn.field_71572_b, spawn.field_71573_c) || par1Entity.field_70170_p.func_147439_a(spawn.field_71574_a, spawn.field_71572_b, spawn.field_71573_c) instanceof BlockFluidBase) {
            par1Entity.field_70170_p.func_147449_b(spawn.field_71574_a, spawn.field_71572_b, spawn.field_71573_c, Blocks.field_150348_b);
        }
    }

    static Entity transferEntity(Entity entity, double x, double y, double z, float yaw, WorldServer world, int touchedPortalType, int exitPortalType, boolean keepMomentum, int instability) {
        if (entity.field_70170_p.field_73011_w.field_76574_g == world.field_73011_w.field_76574_g) {
            return EntityManager.transferEntityWithinDimension(entity, x, y, z, yaw, touchedPortalType, exitPortalType, keepMomentum, instability);
        }
        return EntityManager.transferEntityToDimension(entity, x, y, z, yaw, (WorldServer)entity.field_70170_p, world, touchedPortalType, exitPortalType, keepMomentum, instability);
    }

    public static void transferEntity(Entity entity, TileController entry, TileController exit) throws PortalException {
        ChunkCoordinates exitLoc = EntityManager.getActualExitLocation(entity, exit);
        if (exitLoc == null) {
            throw new PortalException("failedToTransfer");
        }
        boolean keepMomentum = false;
        TilePortalManipulator manip = exit.getModuleManipulator();
        if (manip != null) {
            keepMomentum = manip.shouldKeepMomentumOnTeleport();
        }
        while (entity.field_70154_o != null) {
            entity = entity.field_70154_o;
        }
        int instability = exit.getDimensionalBridgeStabilizer().instability;
        EntityManager.transferEntityWithRider(entity, (double)exitLoc.field_71574_a + 0.5, exitLoc.field_71572_b, (double)exitLoc.field_71573_c + 0.5, EntityManager.getRotation(entity, exit, exitLoc), (WorldServer)exit.func_145831_w(), entry.portalType, exit.portalType, keepMomentum, instability);
    }

    static Entity transferEntityToDimension(Entity entity, double x, double y, double z, float yaw, WorldServer exitingWorld, WorldServer enteringWorld, int touchedPortalType, int exitPortalType, boolean keepMomentum, int instability) {
        if (touchedPortalType == -1 && exitPortalType == -1) {
            while (!(enteringWorld.func_147437_c((int)x, (int)y, (int)z) && enteringWorld.func_147437_c((int)x, (int)y + 1, (int)z) || (y += 1.0) > 250.0)) {
            }
            y += 1.0;
        }
        if (entity == null) {
            return null;
        }
        if (!EntityManager.isEntityFitForTravel(entity)) {
            return entity;
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            player.field_70170_p.field_72984_F.func_76320_a("portal");
            if (!player.field_70170_p.field_72995_K) {
                player.field_70170_p.field_72984_F.func_76320_a("changeDimension");
                ServerConfigurationManager config = player.field_71133_b.func_71203_ab();
                player.func_71053_j();
                player.field_71093_bK = enteringWorld.field_73011_w.field_76574_g;
                player.field_71135_a.func_147359_a((Packet)new S07PacketRespawn(player.field_71093_bK, player.field_70170_p.field_73013_u, enteringWorld.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
                exitingWorld.func_72900_e((Entity)player);
                player.field_70128_L = false;
                player.func_70012_b(x, y, z, yaw, player.field_70125_A);
                EntityManager.handleMomentum((Entity)player, touchedPortalType, exitPortalType, yaw, keepMomentum);
                enteringWorld.func_72838_d((Entity)player);
                player.func_70029_a((World)enteringWorld);
                config.func_72375_a(player, exitingWorld);
                player.field_71135_a.func_147364_a(x, y, z, yaw, entity.field_70125_A);
                player.field_71134_c.func_73080_a(enteringWorld);
                config.func_72354_b(player, enteringWorld);
                config.func_72385_f(player);
                player.field_70170_p.field_72984_F.func_76319_b();
                exitingWorld.func_82742_i();
                enteringWorld.func_82742_i();
                player.field_70170_p.field_72984_F.func_76319_b();
                Iterator potion = player.func_70651_bq().iterator();
                while (potion.hasNext()) {
                    player.field_71135_a.func_147359_a((Packet)new S1DPacketEntityEffect(player.func_145782_y(), (PotionEffect)potion.next()));
                }
                EntityManager.checkInstabilityEffects(entity, instability);
                player.field_71135_a.func_147359_a((Packet)new S1FPacketSetExperience(player.field_71106_cc, player.field_71067_cb, player.field_71068_ca));
                FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, exitingWorld.field_73011_w.field_76574_g, player.field_71093_bK);
                EntityManager.setEntityPortalCooldown((Entity)player);
            }
            player.field_70170_p.field_72984_F.func_76319_b();
            return player;
        }
        NBTTagCompound tag = new NBTTagCompound();
        entity.func_70039_c(tag);
        if (entity instanceof IInventory) {
            IInventory entityInventory = (IInventory)entity;
            for (int i = 0; i < entityInventory.func_70302_i_(); ++i) {
                entityInventory.func_70299_a(i, null);
            }
        }
        entity.func_70106_y();
        Entity newEntity = EntityList.func_75615_a((NBTTagCompound)tag, (World)enteringWorld);
        if (newEntity != null) {
            EntityManager.handleMomentum(newEntity, touchedPortalType, exitPortalType, yaw, keepMomentum);
            newEntity.func_70012_b(x, y, z, yaw, entity.field_70125_A);
            newEntity.field_98038_p = true;
            enteringWorld.func_72838_d(newEntity);
            newEntity.func_70029_a((World)enteringWorld);
            EntityManager.setEntityPortalCooldown(newEntity);
        }
        exitingWorld.func_82742_i();
        enteringWorld.func_82742_i();
        return newEntity;
    }

    static Entity transferEntityWithinDimension(Entity entity, double x, double y, double z, float yaw, int touchedPortalType, int exitPortalType, boolean keepMomentum, int instability) {
        if (entity == null) {
            return null;
        }
        if (!EntityManager.isEntityFitForTravel(entity)) {
            return entity;
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            player.field_70177_z = yaw;
            player.func_70634_a(x, y, z);
            EntityManager.handleMomentum((Entity)player, touchedPortalType, exitPortalType, yaw, keepMomentum);
            player.field_70170_p.func_72866_a((Entity)player, false);
            player.field_71135_a.func_147359_a((Packet)new S06PacketUpdateHealth(player.func_110143_aJ(), player.func_71024_bL().func_75116_a(), player.func_71024_bL().func_75115_e()));
            EntityManager.setEntityPortalCooldown((Entity)player);
            EntityManager.checkInstabilityEffects(entity, instability);
            return player;
        }
        WorldServer world = (WorldServer)entity.field_70170_p;
        NBTTagCompound tag = new NBTTagCompound();
        entity.func_70039_c(tag);
        if (entity instanceof IInventory) {
            IInventory entityInventory = (IInventory)entity;
            for (int i = 0; i < entityInventory.func_70302_i_(); ++i) {
                entityInventory.func_70299_a(i, null);
            }
        }
        entity.func_70106_y();
        Entity newEntity = EntityList.func_75615_a((NBTTagCompound)tag, (World)world);
        if (newEntity != null) {
            EntityManager.handleMomentum(newEntity, touchedPortalType, exitPortalType, yaw, keepMomentum);
            newEntity.func_70012_b(x, y, z, yaw, entity.field_70125_A);
            newEntity.field_98038_p = true;
            world.func_72838_d(newEntity);
            newEntity.func_70029_a((World)world);
            EntityManager.setEntityPortalCooldown(newEntity);
        }
        world.func_82742_i();
        return newEntity;
    }

    static Entity transferEntityWithRider(Entity entity, double x, double y, double z, float yaw, WorldServer world, int touchedPortalType, int exitPortalType, boolean keepMomentum, int instability) {
        Entity rider = entity.field_70153_n;
        if (rider != null) {
            rider.func_70078_a(null);
            rider = EntityManager.transferEntityWithRider(rider, x, y, z, yaw, world, touchedPortalType, exitPortalType, keepMomentum, instability);
        }
        entity = EntityManager.transferEntity(entity, x, y, z, yaw, world, touchedPortalType, exitPortalType, keepMomentum, instability);
        if (rider != null) {
            rider.func_70078_a(entity);
        }
        return entity;
    }

    protected static void checkInstabilityEffects(Entity entity, int instability) {
        int chance_of_effect = rand.nextInt(100);
        if (chance_of_effect < instability) {
            if (instability >= 70) {
                EntityManager.addHighInstabilityEffects(entity);
            } else if (instability >= 50) {
                EntityManager.addMediumInstabilityEffects(entity);
            } else if (instability >= 20) {
                EntityManager.addLowInstabilityEffects(entity);
            }
        }
    }

    static void addHighInstabilityEffects(Entity entity) {
        if (entity instanceof EntityLivingBase) {
            PotionEffect blindness = new PotionEffect(Potion.field_76440_q.field_76415_H, 600, 1);
            PotionEffect hunger = new PotionEffect(Potion.field_76438_s.field_76415_H, 600, 1);
            PotionEffect poison = new PotionEffect(Potion.field_76436_u.field_76415_H, 600, 1);
            blindness.setCurativeItems(new ArrayList());
            hunger.setCurativeItems(new ArrayList());
            poison.setCurativeItems(new ArrayList());
            ((EntityLivingBase)entity).func_70690_d(blindness);
            ((EntityLivingBase)entity).func_70690_d(hunger);
            ((EntityLivingBase)entity).func_70690_d(poison);
        }
    }

    static void addLowInstabilityEffects(Entity entity) {
        if (entity instanceof EntityLivingBase) {
            PotionEffect blindness = new PotionEffect(Potion.field_76440_q.field_76415_H, 200, 1);
            PotionEffect hunger = new PotionEffect(Potion.field_76438_s.field_76415_H, 200, 1);
            PotionEffect poison = new PotionEffect(Potion.field_76436_u.field_76415_H, 200, 1);
            blindness.setCurativeItems(new ArrayList());
            hunger.setCurativeItems(new ArrayList());
            poison.setCurativeItems(new ArrayList());
            int effect = rand.nextInt(3);
            ((EntityLivingBase)entity).func_70690_d(effect == 0 ? blindness : (effect == 1 ? hunger : poison));
        }
    }

    static void addMediumInstabilityEffects(Entity entity) {
        if (entity instanceof EntityLivingBase) {
            PotionEffect blindness = new PotionEffect(Potion.field_76440_q.field_76415_H, 400, 1);
            PotionEffect hunger = new PotionEffect(Potion.field_76438_s.field_76415_H, 400, 1);
            PotionEffect poison = new PotionEffect(Potion.field_76436_u.field_76415_H, 400, 1);
            blindness.setCurativeItems(new ArrayList());
            hunger.setCurativeItems(new ArrayList());
            poison.setCurativeItems(new ArrayList());
            int effect = rand.nextInt(3);
            if (effect == 0) {
                ((EntityLivingBase)entity).func_70690_d(blindness);
                ((EntityLivingBase)entity).func_70690_d(hunger);
            } else if (effect == 1) {
                ((EntityLivingBase)entity).func_70690_d(blindness);
                ((EntityLivingBase)entity).func_70690_d(poison);
            } else {
                ((EntityLivingBase)entity).func_70690_d(poison);
                ((EntityLivingBase)entity).func_70690_d(hunger);
            }
        }
    }
}

