/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.network.packet;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.ByteBufUtils;
import enhancedportals.client.gui.GuiDialingEdit;
import enhancedportals.network.ClientProxy;
import enhancedportals.network.packet.PacketEP;
import enhancedportals.portal.GlyphIdentifier;
import enhancedportals.portal.PortalTextureManager;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class PacketTextureData
extends PacketEP {
    PortalTextureManager ptm;
    String name;
    String glyphs;

    public PacketTextureData() {
    }

    public PacketTextureData(String n, String g, PortalTextureManager t) {
        this.ptm = t;
        this.name = n;
        this.glyphs = g;
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        NBTTagCompound data = ByteBufUtils.readTag((ByteBuf)buffer);
        this.ptm = new PortalTextureManager();
        if (data.func_74764_b("Texture")) {
            this.ptm.readFromNBT(data, "Texture");
        }
        this.name = data.func_74779_i("name");
        this.glyphs = data.func_74779_i("glyphs");
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        NBTTagCompound data = new NBTTagCompound();
        if (this.ptm != null) {
            this.ptm.writeToNBT(data, "Texture");
        }
        data.func_74778_a("name", this.name);
        data.func_74778_a("glyphs", this.glyphs);
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)data);
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        ClientProxy.saveName = this.name;
        ClientProxy.saveGlyph = new GlyphIdentifier(this.glyphs);
        ClientProxy.saveTexture = this.ptm;
        ((GuiDialingEdit)FMLClientHandler.instance().getClient().field_71462_r).receivedData();
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }
}

