/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import enhancedportals.EnhancedPortals;
import enhancedportals.block.BlockDecorBorderedQuartz;
import enhancedportals.block.BlockDecorEnderInfusedMetal;
import enhancedportals.block.BlockFrame;
import enhancedportals.block.BlockPortal;
import enhancedportals.block.BlockStabilizer;
import enhancedportals.block.BlockStabilizerEmpty;
import enhancedportals.crafting.ThermalExpansion;
import enhancedportals.crafting.Vanilla;
import enhancedportals.item.ItemBlankPortalModule;
import enhancedportals.item.ItemBlankUpgrade;
import enhancedportals.item.ItemFrame;
import enhancedportals.item.ItemGlasses;
import enhancedportals.item.ItemLocationCard;
import enhancedportals.item.ItemManual;
import enhancedportals.item.ItemNanobrush;
import enhancedportals.item.ItemPortalModule;
import enhancedportals.item.ItemStabilizer;
import enhancedportals.item.ItemUpgrade;
import enhancedportals.item.ItemWrench;
import enhancedportals.item.PotionFeatherfall;
import enhancedportals.network.packet.PacketGui;
import enhancedportals.network.packet.PacketGuiData;
import enhancedportals.network.packet.PacketRequestGui;
import enhancedportals.network.packet.PacketRerender;
import enhancedportals.network.packet.PacketTextureData;
import enhancedportals.portal.NetworkManager;
import enhancedportals.tile.TileController;
import enhancedportals.tile.TileDialingDevice;
import enhancedportals.tile.TileFrameBasic;
import enhancedportals.tile.TileNetworkInterface;
import enhancedportals.tile.TilePortal;
import enhancedportals.tile.TilePortalManipulator;
import enhancedportals.tile.TileRedstoneInterface;
import enhancedportals.tile.TileStabilizer;
import enhancedportals.tile.TileStabilizerMain;
import enhancedportals.tile.TileTransferEnergy;
import enhancedportals.tile.TileTransferFluid;
import enhancedportals.tile.TileTransferItem;
import enhancedportals.utility.CreativeTabEP3;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommonProxy {
    public static int CONFIG_REDSTONE_FLUX_COST = 10000;
    public static int CONFIG_REDSTONE_FLUX_TIMER = 20;
    public static boolean CONFIG_FORCE_FRAME_OVERLAY;
    public static boolean CONFIG_DISABLE_SOUNDS;
    public static boolean CONFIG_DISABLE_PARTICLES;
    public static boolean CONFIG_PORTAL_DESTROYS_BLOCKS;
    public static boolean CONFIG_FASTER_PORTAL_COOLDOWN;
    public static boolean CONFIG_REQUIRE_POWER;
    public static boolean CONFIG_UPDATE_NOTIFIER;
    public static boolean CONFIG_RECIPES_VANILLA;
    public static boolean CONFIG_RECIPES_TE;
    public static double CONFIG_POWER_MULTIPLIER;
    public static double CONFIG_POWER_STORAGE_MULTIPLIER;
    public static int CONFIG_PORTAL_CONNECTIONS_PER_ROW;
    public int gogglesRenderIndex = 0;
    public NetworkManager networkManager;
    static Configuration config;
    public static String UPDATE_LATEST_VER;
    public static final Logger logger;
    public static final CreativeTabs creativeTab;
    public static Potion featherfallPotion;

    public void waitForController(ChunkCoordinates controller, ChunkCoordinates frame) {
    }

    public ArrayList<ChunkCoordinates> getControllerList(ChunkCoordinates controller) {
        return null;
    }

    public void clearControllerList(ChunkCoordinates controller) {
    }

    public File getBaseDir() {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_71209_f(".");
    }

    public File getResourcePacksDir() {
        return new File(this.getBaseDir(), "resourcepacks");
    }

    public File getWorldDir() {
        return new File(this.getBaseDir(), DimensionManager.getWorld((int)0).func_72860_G().func_75760_g());
    }

    public void miscSetup() {
        ChestGenHooks.addItem((String)"dungeonChest", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack((Item)ItemPortalModule.instance, 1, 4), 1, 1, 2));
    }

    public void registerBlocks() {
        GameRegistry.registerBlock((Block)new BlockFrame("frame"), ItemFrame.class, (String)"frame");
        GameRegistry.registerBlock((Block)new BlockPortal("portal"), (String)"portal");
        GameRegistry.registerBlock((Block)new BlockStabilizer("dbs"), ItemStabilizer.class, (String)"dbs");
        GameRegistry.registerBlock((Block)new BlockDecorBorderedQuartz("decor_frame"), (String)"decor_frame");
        GameRegistry.registerBlock((Block)new BlockDecorEnderInfusedMetal("decor_dbs"), (String)"decor_dbs");
        GameRegistry.registerBlock((Block)new BlockStabilizerEmpty("dbs_empty"), (String)"dbs_empty");
    }

    public void registerItems() {
        GameRegistry.registerItem((Item)new ItemWrench("wrench"), (String)"wrench");
        GameRegistry.registerItem((Item)new ItemNanobrush("nanobrush"), (String)"nanobrush");
        GameRegistry.registerItem((Item)new ItemGlasses("glasses"), (String)"glasses");
        GameRegistry.registerItem((Item)new ItemLocationCard("location_card"), (String)"location_card");
        GameRegistry.registerItem((Item)new ItemPortalModule("portal_module"), (String)"portal_module");
        GameRegistry.registerItem((Item)new ItemUpgrade("upgrade"), (String)"upgrade");
        GameRegistry.registerItem((Item)new ItemBlankPortalModule("blank_portal_module"), (String)"blank_portal_module");
        GameRegistry.registerItem((Item)new ItemBlankUpgrade("blank_upgrade"), (String)"blank_upgrade");
        GameRegistry.registerItem((Item)new ItemManual("manual"), (String)"manual");
        if (CONFIG_RECIPES_TE && Loader.isModLoaded((String)"ThermalExpansion")) {
            ThermalExpansion.registerItems();
            ThermalExpansion.registerMachineRecipes();
        }
    }

    public void registerPotions() {
        Potion[] potionTypes = null;
        for (Field f : Potion.class.getDeclaredFields()) {
            f.setAccessible(true);
            try {
                if (!f.getName().equals("potionTypes") && !f.getName().equals("field_76425_a")) continue;
                Field modfield = Field.class.getDeclaredField("modifiers");
                modfield.setAccessible(true);
                modfield.setInt(f, f.getModifiers() & 0xFFFFFFEF);
                potionTypes = (Potion[])f.get(null);
                Potion[] newPotionTypes = new Potion[256];
                System.arraycopy(potionTypes, 0, newPotionTypes, 0, potionTypes.length);
                f.set(null, newPotionTypes);
            }
            catch (Exception e) {
                System.err.println("Severe error, please report this to the mod author:");
                System.err.println(e);
            }
        }
        featherfallPotion = new PotionFeatherfall(40, false, 0);
    }

    public void registerPackets() {
        EnhancedPortals.packetPipeline.registerPacket(PacketRequestGui.class);
        EnhancedPortals.packetPipeline.registerPacket(PacketTextureData.class);
        EnhancedPortals.packetPipeline.registerPacket(PacketRerender.class);
        EnhancedPortals.packetPipeline.registerPacket(PacketGuiData.class);
        EnhancedPortals.packetPipeline.registerPacket(PacketGui.class);
    }

    public void registerTileEntities() {
        GameRegistry.registerTileEntity(TilePortal.class, (String)"epP");
        GameRegistry.registerTileEntity(TileFrameBasic.class, (String)"epF");
        GameRegistry.registerTileEntity(TileController.class, (String)"epPC");
        GameRegistry.registerTileEntity(TileRedstoneInterface.class, (String)"epRI");
        GameRegistry.registerTileEntity(TileNetworkInterface.class, (String)"epNI");
        GameRegistry.registerTileEntity(TileDialingDevice.class, (String)"epDD");
        GameRegistry.registerTileEntity(TilePortalManipulator.class, (String)"epMM");
        GameRegistry.registerTileEntity(TileStabilizer.class, (String)"epDBS");
        GameRegistry.registerTileEntity(TileStabilizerMain.class, (String)"epDBSM");
        GameRegistry.registerTileEntity(TileTransferEnergy.class, (String)"epTE");
        GameRegistry.registerTileEntity(TileTransferFluid.class, (String)"epTF");
        GameRegistry.registerTileEntity(TileTransferItem.class, (String)"epTI");
    }

    public void setupConfiguration(File c) {
        config = new Configuration(c);
        CONFIG_FORCE_FRAME_OVERLAY = config.get("Misc", "ForceShowFrameOverlays", false).getBoolean(false);
        CONFIG_DISABLE_SOUNDS = config.get("Overrides", "DisableSounds", false).getBoolean(false);
        CONFIG_DISABLE_PARTICLES = config.get("Overrides", "DisableParticles", false).getBoolean(false);
        CONFIG_PORTAL_DESTROYS_BLOCKS = config.get("Portal", "PortalsDestroyBlocks", true).getBoolean(true);
        CONFIG_FASTER_PORTAL_COOLDOWN = config.get("Portal", "FasterPortalCooldown", false).getBoolean(false);
        CONFIG_REQUIRE_POWER = config.get("Power", "RequirePower", true).getBoolean(true);
        CONFIG_POWER_MULTIPLIER = config.get("Power", "PowerMultiplier", 1.0).getDouble(1.0);
        CONFIG_POWER_STORAGE_MULTIPLIER = config.get("Power", "DBSPowerStorageMultiplier", 1.0).getDouble(1.0);
        CONFIG_PORTAL_CONNECTIONS_PER_ROW = config.get("Portal", "ActivePortalsPerRow", 2).getInt(2);
        CONFIG_UPDATE_NOTIFIER = config.get("Misc", "NotifyOfUpdates", true).getBoolean(true);
        CONFIG_RECIPES_VANILLA = config.get("Crafting", "Vanilla", true).getBoolean(true);
        CONFIG_RECIPES_TE = config.get("Crafting", "ThermalExpansion", true).getBoolean(true);
        config.save();
        if (CONFIG_POWER_MULTIPLIER < 0.0) {
            CONFIG_REQUIRE_POWER = false;
        }
        if (CONFIG_POWER_STORAGE_MULTIPLIER < 0.01) {
            CONFIG_POWER_STORAGE_MULTIPLIER = 0.01;
        }
        try {
            URL versionIn = new URL("https://raw.githubusercontent.com/enhancedportals/enhancedportals/master/docs/VERSION");
            BufferedReader in = new BufferedReader(new InputStreamReader(versionIn.openStream()));
            UPDATE_LATEST_VER = in.readLine();
            if (FMLCommonHandler.instance().getSide() == Side.SERVER && !UPDATE_LATEST_VER.equals("3.0.12")) {
                logger.info("You're using an outdated version (v3.0.12). The newest version is: " + UPDATE_LATEST_VER);
            }
        }
        catch (Exception e) {
            logger.warn("Unable to get the latest version information");
            UPDATE_LATEST_VER = "3.0.12";
        }
    }

    public static boolean Notify(EntityPlayer player, String lateVers) {
        if (CONFIG_UPDATE_NOTIFIER) {
            player.func_145747_a((IChatComponent)new ChatComponentText("Enhanced Portals has been updated to v" + lateVers + " :: You are running v" + "3.0.12"));
            return true;
        }
        logger.info("You're using an outdated version (v3.0.12)");
        return false;
    }

    public void setupCrafting() {
        if (CONFIG_RECIPES_VANILLA) {
            Vanilla.registerRecipes();
        }
        if (CONFIG_RECIPES_TE && Loader.isModLoaded((String)"ThermalExpansion")) {
            ThermalExpansion.registerRecipes();
        }
    }

    static {
        CONFIG_PORTAL_CONNECTIONS_PER_ROW = 2;
        logger = LogManager.getLogger((String)"EnhancedPortals");
        creativeTab = new CreativeTabEP3();
    }
}

