/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.item;

import enhancedportals.block.BlockFrame;
import enhancedportals.item.ItemFrame;
import enhancedportals.network.CommonProxy;
import enhancedportals.tile.TileController;
import enhancedportals.tile.TileDialingDevice;
import enhancedportals.tile.TileFrame;
import enhancedportals.tile.TileNetworkInterface;
import enhancedportals.tile.TilePortalManipulator;
import enhancedportals.tile.TilePortalPart;
import enhancedportals.tile.TileRedstoneInterface;
import enhancedportals.tile.TileTransferEnergy;
import enhancedportals.tile.TileTransferFluid;
import enhancedportals.tile.TileTransferItem;
import enhancedportals.utility.Localization;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemUpgrade
extends Item {
    public static ItemUpgrade instance;
    static IIcon baseIcon;
    static IIcon[] overlayIcons;

    public ItemUpgrade(String n) {
        instance = this;
        this.func_77637_a(CommonProxy.creativeTab);
        this.func_77655_b(n);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    private void decrementStack(EntityPlayer player, ItemStack stack) {
        if (!player.field_71075_bZ.field_75098_d) {
            --stack.field_77994_a;
            if (stack.field_77994_a <= 0) {
                stack = null;
            }
        }
    }

    public IIcon func_77618_c(int damage, int pass) {
        if (pass == 1) {
            return overlayIcons[damage];
        }
        return baseIcon;
    }

    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int i = 0; i < overlayIcons.length; ++i) {
            par3List.add(new ItemStack(par1, 1, i));
        }
    }

    public String func_77667_c(ItemStack par1ItemStack) {
        return super.func_77658_a() + "." + ItemFrame.unlocalizedName[par1ItemStack.func_77960_j() + 2];
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return false;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        int blockMeta = stack.func_77960_j() + 2;
        if (tile instanceof TileFrame) {
            TileFrame frame = (TileFrame)tile;
            TileController controller = frame.getPortalController();
            if (controller == null) {
                frame = null;
                world.func_147465_d(x, y, z, (Block)BlockFrame.instance, blockMeta, 2);
                this.decrementStack(player, stack);
                return true;
            }
            if (controller.getDiallingDevices().size() > 0 && blockMeta == BlockFrame.NETWORK_INTERFACE) {
                player.func_146105_b((IChatComponent)new ChatComponentText(Localization.getChatError("dialAndNetwork")));
                return false;
            }
            if (controller.getNetworkInterfaces().size() > 0 && blockMeta == BlockFrame.DIALLING_DEVICE) {
                player.func_146105_b((IChatComponent)new ChatComponentText(Localization.getChatError("dialAndNetwork")));
                return false;
            }
            if (controller.getModuleManipulator() != null && blockMeta == BlockFrame.MODULE_MANIPULATOR) {
                player.func_146105_b((IChatComponent)new ChatComponentText(Localization.getChatError("multipleMod")));
                return false;
            }
            controller.removeFrame(frame.getChunkCoordinates());
            frame = null;
            world.func_147465_d(x, y, z, (Block)BlockFrame.instance, blockMeta, 2);
            this.decrementStack(player, stack);
            TilePortalPart t = (TilePortalPart)world.func_147438_o(x, y, z);
            if (t instanceof TileRedstoneInterface) {
                controller.addRedstoneInterface(t.getChunkCoordinates());
            } else if (t instanceof TileDialingDevice) {
                controller.addDialDevice(t.getChunkCoordinates());
            } else if (t instanceof TileNetworkInterface) {
                controller.addNetworkInterface(t.getChunkCoordinates());
            } else if (t instanceof TilePortalManipulator) {
                controller.setModuleManipulator(t.getChunkCoordinates());
            } else if (t instanceof TileTransferEnergy) {
                controller.addTransferEnergy(t.getChunkCoordinates());
            } else if (t instanceof TileTransferFluid) {
                controller.addTransferFluid(t.getChunkCoordinates());
            } else if (t instanceof TileTransferItem) {
                controller.addTransferItem(t.getChunkCoordinates());
            }
            t.setPortalController(controller.getChunkCoordinates());
            world.func_147471_g(controller.field_145851_c, controller.field_145848_d, controller.field_145849_e);
            return true;
        }
        return false;
    }

    public void func_94581_a(IIconRegister register) {
        baseIcon = register.func_94245_a("enhancedportals:blank_upgrade");
        for (int i = 0; i < overlayIcons.length; ++i) {
            ItemUpgrade.overlayIcons[i] = register.func_94245_a("enhancedportals:upgrade_" + i);
        }
    }

    public boolean func_77623_v() {
        return true;
    }

    static {
        overlayIcons = new IIcon[BlockFrame.FRAME_TYPES - 2];
    }
}

