/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.item;

import enhancedportals.client.PortalParticleFX;
import enhancedportals.network.ClientProxy;
import enhancedportals.network.CommonProxy;
import enhancedportals.tile.TilePortalManipulator;
import enhancedportals.utility.IPortalModule;
import enhancedportals.utility.Localization;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemPortalModule
extends Item
implements IPortalModule {
    public static ItemPortalModule instance;
    static IIcon baseIcon;
    static IIcon[] overlayIcons;

    public ItemPortalModule(String n) {
        instance = this;
        this.func_77637_a(CommonProxy.creativeTab);
        this.func_77655_b(n);
        this.func_77656_e(0);
        this.func_77625_d(64);
        this.func_77627_a(true);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add("Portal Module");
        if (stack.func_77960_j() == PortalModules.FACING.ordinal()) {
            NBTTagCompound t = stack.func_77978_p();
            int i = 0;
            if (t != null) {
                i = t.func_74762_e("facing");
            }
            list.add(EnumChatFormatting.GRAY + Localization.get("gui.facing." + i));
        }
        list.add(EnumChatFormatting.DARK_GRAY + StatCollector.func_74838_a((String)(this.func_77657_g(stack) + ".desc")));
    }

    @Override
    public boolean canInstallUpgrade(TilePortalManipulator moduleManipulator, IPortalModule[] installedUpgrades, ItemStack upgrade) {
        return true;
    }

    @Override
    public boolean canRemoveUpgrade(TilePortalManipulator moduleManipulator, IPortalModule[] installedUpgrades, ItemStack upgrade) {
        return true;
    }

    @Override
    public boolean disableParticles(TilePortalManipulator moduleManipulator, ItemStack upgrade) {
        return upgrade.func_77960_j() == PortalModules.REMOVE_PARTICLES.ordinal();
    }

    @Override
    public boolean disablePortalRendering(TilePortalManipulator modulemanipulator, ItemStack upgrade) {
        return upgrade.func_77960_j() == PortalModules.INVISIBLE_PORTAL.ordinal();
    }

    public IIcon func_77618_c(int damage, int pass) {
        if (pass == 1) {
            return overlayIcons[damage];
        }
        return baseIcon;
    }

    @Override
    public String getID(ItemStack upgrade) {
        return "ep3." + upgrade.func_77960_j();
    }

    public EnumRarity func_77613_e(ItemStack itemStack) {
        if (itemStack.func_77960_j() == PortalModules.INVISIBLE_PORTAL.ordinal()) {
            return EnumRarity.epic;
        }
        if (itemStack.func_77960_j() == PortalModules.KEEP_MOMENTUM.ordinal()) {
            return EnumRarity.rare;
        }
        return EnumRarity.common;
    }

    public void func_150895_a(Item item, CreativeTabs creativeTab, List list) {
        for (int i = 0; i < PortalModules.values().length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "." + stack.func_77960_j();
    }

    @Override
    public boolean keepMomentumOnTeleport(TilePortalManipulator tileModuleManipulator, ItemStack i) {
        return i.func_77960_j() == PortalModules.KEEP_MOMENTUM.ordinal();
    }

    @Override
    public void onEntityTeleportEnd(Entity entity, TilePortalManipulator moduleManipulator, ItemStack upgrade) {
        if (upgrade.func_77960_j() == PortalModules.FEATHERFALL.ordinal()) {
            if (entity instanceof EntityPlayer) {
                ((EntityPlayer)entity).func_70690_d(new PotionEffect(CommonProxy.featherfallPotion.field_76415_H, 200, 0));
            } else if (entity instanceof EntityLiving) {
                ((EntityLiving)entity).func_70690_d(new PotionEffect(CommonProxy.featherfallPotion.field_76415_H, 200, 0));
            }
        }
    }

    @Override
    public boolean onEntityTeleportStart(Entity entity, TilePortalManipulator moduleManipulator, ItemStack upgrade) {
        if (upgrade.func_77960_j() == PortalModules.FEATHERFALL.ordinal()) {
            if (entity instanceof EntityPlayer) {
                ((EntityPlayer)entity).func_70690_d(new PotionEffect(CommonProxy.featherfallPotion.field_76415_H, 200, 0));
            } else if (entity instanceof EntityLiving) {
                ((EntityLiving)entity).func_70690_d(new PotionEffect(CommonProxy.featherfallPotion.field_76415_H, 200, 0));
            }
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (player.func_70093_af() && stack.func_77960_j() == PortalModules.FACING.ordinal()) {
            NBTTagCompound tag = stack.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
                tag.func_74768_a("facing", 1);
            } else {
                int face = tag.func_74762_e("facing") + 1;
                if (face >= 4) {
                    face = 0;
                }
                tag.func_74768_a("facing", face);
            }
            stack.func_77982_d(tag);
        }
        return stack;
    }

    @Override
    public void onParticleCreated(TilePortalManipulator moduleManipulator, ItemStack upgrade, PortalParticleFX particle) {
        if (upgrade.func_77960_j() == PortalModules.RAINBOW_PARTICLES.ordinal()) {
            particle.func_70538_b((float)Math.random(), (float)Math.random(), (float)Math.random());
        } else if (upgrade.func_77960_j() == PortalModules.TINTSHADE_PARTICLES.ordinal()) {
            float particleRed = particle.func_70534_d();
            float particleGreen = particle.func_70542_f();
            float particleBlue = particle.func_70535_g();
            int i = ClientProxy.random.nextInt(3);
            if (i == 0) {
                particleRed *= particleRed / 4.0f * 3.0f;
                particleGreen *= particleGreen / 4.0f * 3.0f;
                particleBlue *= particleBlue / 4.0f * 3.0f;
            } else if (i == 1) {
                particleRed = (255.0f - particleRed) * (particleRed / 4.0f * 3.0f);
                particleGreen = (255.0f - particleGreen) * (particleGreen / 4.0f * 3.0f);
                particleBlue = (255.0f - particleBlue) * (particleBlue / 4.0f * 3.0f);
            }
            particle.func_70538_b(particleRed, particleGreen, particleBlue);
        }
    }

    @Override
    public void onPortalCreated(TilePortalManipulator moduleManipulator, ItemStack upgrade) {
    }

    @Override
    public void onPortalRemoved(TilePortalManipulator moduleManipulator, ItemStack upgrade) {
    }

    @Override
    public void onUpgradeInstalled(TilePortalManipulator moduleManipulator, ItemStack upgrade) {
    }

    @Override
    public void onUpgradeRemoved(TilePortalManipulator moduleManipulator, ItemStack upgrade) {
    }

    public void func_94581_a(IIconRegister register) {
        baseIcon = register.func_94245_a("enhancedportals:blank_portal_module");
        for (int i = 0; i < overlayIcons.length; ++i) {
            ItemPortalModule.overlayIcons[i] = register.func_94245_a("enhancedportals:portal_module_" + i);
        }
    }

    public boolean func_77623_v() {
        return true;
    }

    static {
        overlayIcons = new IIcon[PortalModules.values().length];
    }

    public static enum PortalModules {
        REMOVE_PARTICLES,
        RAINBOW_PARTICLES,
        REMOVE_SOUNDS,
        KEEP_MOMENTUM,
        INVISIBLE_PORTAL,
        TINTSHADE_PARTICLES,
        FACING,
        FEATHERFALL;


        public String getUniqueID() {
            ItemStack s = new ItemStack((Item)instance, 1, this.ordinal());
            return ((IPortalModule)s.func_77973_b()).getID(s);
        }
    }
}

