/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.inventory;

import enhancedportals.EnhancedPortals;
import enhancedportals.inventory.BaseContainer;
import enhancedportals.inventory.slot.SlotDBS;
import enhancedportals.network.packet.PacketGuiData;
import enhancedportals.tile.TileStabilizerMain;
import enhancedportals.utility.GeneralUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.nbt.NBTTagCompound;

public class ContainerDimensionalBridgeStabilizer
extends BaseContainer {
    int lastPower = 0;
    int lastMaxPower = 0;
    int lastPortals = -1;
    int lastInstability = 0;
    int lastPowerState = -1;
    TileStabilizerMain stabilizer;

    public ContainerDimensionalBridgeStabilizer(TileStabilizerMain s, InventoryPlayer p) {
        super(s, p, (GeneralUtils.hasEnergyCost() ? 90 : 44) + 2 + 90);
        this.stabilizer = s;
        int container = GeneralUtils.hasEnergyCost() ? 90 : 44;
        this.func_75146_a(new SlotDBS(s, 0, 152, container - 25));
    }

    public void func_75142_b() {
        super.func_75142_b();
        int currentPower = this.stabilizer.getEnergyStorage().getEnergyStored();
        int currentMaxPower = this.stabilizer.getEnergyStorage().getMaxEnergyStored();
        int currentPortals = this.stabilizer.getActiveConnections();
        int currentInstability = this.stabilizer.instability;
        int currentPowerState = this.stabilizer.powerState;
        for (int i = 0; i < this.field_75149_d.size(); ++i) {
            ICrafting icrafting = (ICrafting)this.field_75149_d.get(i);
            if (this.lastPower != currentPower || this.lastMaxPower != currentMaxPower) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a("energy", currentPower);
                tag.func_74768_a("max", currentMaxPower);
                EnhancedPortals.packetPipeline.sendTo(new PacketGuiData(tag), (EntityPlayerMP)icrafting);
            }
            if (this.lastPortals != currentPortals) {
                icrafting.func_71112_a((Container)this, 2, currentPortals);
            }
            if (this.lastInstability != currentInstability) {
                icrafting.func_71112_a((Container)this, 3, currentInstability);
            }
            if (this.lastPowerState == currentPowerState) continue;
            icrafting.func_71112_a((Container)this, 4, currentPowerState);
        }
        this.lastPower = currentPower;
        this.lastMaxPower = currentMaxPower;
        this.lastPortals = currentPortals;
        this.lastInstability = currentInstability;
        this.lastPowerState = currentPowerState;
    }

    @Override
    public void handleGuiPacket(NBTTagCompound tag, EntityPlayer player) {
        if (tag.func_74764_b("increase_powerState")) {
            if (this.stabilizer.powerState < 3) {
                ++this.stabilizer.powerState;
            }
        } else if (tag.func_74764_b("decrease_powerState")) {
            if (this.stabilizer.powerState > 0) {
                --this.stabilizer.powerState;
            }
        } else if (tag.func_74764_b("energy") && tag.func_74764_b("max")) {
            this.stabilizer.getEnergyStorage().setCapacity(tag.func_74762_e("max"));
            this.stabilizer.getEnergyStorage().setEnergyStored(tag.func_74762_e("energy"));
        }
    }

    public void func_75137_b(int par1, int par2) {
        if (par1 == 2) {
            this.stabilizer.intActiveConnections = par2;
        } else if (par1 == 3) {
            this.stabilizer.instability = par2;
        } else if (par1 == 4) {
            this.stabilizer.powerState = par2;
        }
    }
}

