/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.client.gui.elements;

import enhancedportals.client.gui.GuiTextureParticle;
import enhancedportals.client.gui.elements.BaseElement;
import enhancedportals.network.ClientProxy;
import java.util.List;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class ElementScrollParticles
extends BaseElement {
    float currentScroll = 0.0f;
    boolean isScrolling = false;
    boolean wasClicking = false;
    int scrollAmount = 0;
    int particleFrame;
    int particleCounter;

    public ElementScrollParticles(GuiTextureParticle gui, int x, int y, ResourceLocation t) {
        super(gui, x, y, 176, 54);
        this.texture = t;
    }

    @Override
    public void addTooltip(List<String> list) {
    }

    @Override
    public boolean handleMouseClicked(int x, int y, int mouseButton) {
        if (mouseButton == 1) {
            ((GuiTextureParticle)this.parent).particleSelected(0);
            return true;
        }
        x += this.parent.getGuiLeft();
        y += this.parent.getGuiTop();
        for (int i = 0; i < 27 && this.scrollAmount + i < ClientProxy.particleSets.size(); ++i) {
            int x2 = this.posX + i % 9 * 18 + 1;
            int y2 = this.posY + i / 9 * 18 + 1;
            if (x < x2 || x >= x2 + 16 || y < y2 || y >= y2 + 16) continue;
            ((GuiTextureParticle)this.parent).particleSelected(this.scrollAmount + i);
            break;
        }
        return true;
    }

    @Override
    protected void drawBackground() {
    }

    protected void handleMouse() {
        boolean isMouseDown = Mouse.isButtonDown((int)0);
        boolean ignoreScroll = false;
        int mouseX = this.parent.getMouseX() + this.parent.getGuiLeft();
        int mouseY = this.parent.getMouseY() + this.parent.getGuiTop();
        int scrollbarX = this.posX + this.sizeX - 13;
        int scrollbarY = this.posY + 1;
        int scrollbarX2 = scrollbarX + 11;
        int scrollbarY2 = scrollbarY + this.sizeY - 3;
        if (!this.wasClicking && isMouseDown && mouseX >= scrollbarX && mouseX <= scrollbarX2 && mouseY >= scrollbarY && mouseY <= scrollbarY2) {
            this.isScrolling = true;
        }
        if (!isMouseDown) {
            this.isScrolling = false;
        }
        this.wasClicking = isMouseDown;
        if (!this.isScrolling && !isMouseDown && this.intersectsWith(mouseX - this.parent.getGuiLeft(), mouseY - this.parent.getGuiTop())) {
            int wheel = Mouse.getDWheel();
            if (wheel < 0) {
                this.currentScroll = (float)((double)this.currentScroll + 0.1);
                ignoreScroll = true;
                this.isScrolling = true;
            } else if (wheel > 0) {
                this.currentScroll = (float)((double)this.currentScroll - 0.1);
                ignoreScroll = true;
                this.isScrolling = true;
            }
        }
        if (this.isScrolling) {
            int max;
            if (!ignoreScroll) {
                this.currentScroll = ((float)(mouseY - scrollbarY) - 7.5f) / ((float)(scrollbarY2 - scrollbarY) - 15.0f);
            }
            if (this.currentScroll < 0.0f) {
                this.currentScroll = 0.0f;
            } else if (this.currentScroll > 1.0f) {
                this.currentScroll = 1.0f;
            }
            int items = ClientProxy.customFrameTextures.size() - 27 + 1;
            this.scrollAmount = (int)((double)(this.currentScroll * (float)items) + 0.5);
            if (this.scrollAmount < 0) {
                this.scrollAmount = 0;
            }
            if (this.scrollAmount > (max = ClientProxy.customFrameTextures.size() - 27)) {
                this.scrollAmount = max;
            }
        }
    }

    @Override
    protected void drawContent() {
        boolean canScroll = false;
        if (ClientProxy.particleSets.size() > 27) {
            canScroll = true;
            this.handleMouse();
        }
        int l = this.posY + 1;
        int k = l + this.sizeY - 1;
        int selectedIcon = ((GuiTextureParticle)this.parent).getPTM().getParticleType();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.parent.getTextureManager().func_110577_a(this.texture);
        this.drawTexturedModalRect(this.posX + this.sizeX - 13, this.posY + 1 + (int)((float)(k - l - 16) * this.currentScroll), 244, 226 + (canScroll ? 0 : 15), 12, 15);
        this.parent.getTextureManager().func_110577_a(new ResourceLocation("textures/particle/particles.png"));
        for (int i = 0; i < 27 && this.scrollAmount + i < ClientProxy.particleSets.size(); ++i) {
            int x = this.posX + i % 9 * 18 + 1;
            int y = this.posY + i / 9 * 18 + 1;
            if (this.scrollAmount + i == selectedIcon) {
                Gui.func_73734_a((int)(x - 1), (int)(y - 1), (int)(x + 17), (int)y, (int)-16711936);
                Gui.func_73734_a((int)(x - 1), (int)(y - 1), (int)x, (int)(y + 17), (int)-16711936);
                Gui.func_73734_a((int)(x - 1), (int)(y + 16), (int)(x + 17), (int)(y + 17), (int)-16711936);
                Gui.func_73734_a((int)(x + 16), (int)(y - 1), (int)(x + 17), (int)(y + 17), (int)-16711936);
            }
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            ClientProxy.ParticleSet particles = ClientProxy.particleSets.get(this.scrollAmount + i);
            int particle = particles.frames[this.particleFrame % particles.frames.length];
            this.drawTexturedModalRect(x, y, particle % 16 * 16, particle / 16 * 16, 16, 16);
        }
    }

    @Override
    public void update() {
        ++this.particleCounter;
        if (this.particleCounter > 75) {
            this.particleCounter = 0;
            ++this.particleFrame;
        }
    }
}

