/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.client.gui.elements;

import enhancedportals.client.gui.BaseGui;
import enhancedportals.client.gui.elements.BaseElement;
import java.util.List;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidTank;
import org.lwjgl.opengl.GL11;

public class ElementFluid
extends BaseElement {
    FluidTank t;
    int scale = 1;

    public ElementFluid(BaseGui gui, int x, int y, FluidTank tank) {
        super(gui, x, y, 18, 62);
        this.t = tank;
        this.texture = new ResourceLocation("enhancedportals", "textures/gui/elements.png");
    }

    @Override
    public void addTooltip(List<String> list) {
        list.add(this.t.getFluidAmount() + " / " + this.t.getCapacity() + " mB");
    }

    @Override
    protected void drawContent() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.parent.getTextureManager().func_110577_a(this.texture);
        this.drawTexturedModalRect(this.posX, this.posY, 210, 0, this.sizeX, this.sizeY);
        if (this.t.getFluid() != null) {
            int height = 0;
            if (this.t.getFluidAmount() > 0) {
                height = Math.round((float)this.t.getFluidAmount() * (float)this.sizeY / (float)this.t.getCapacity());
                height = Math.min(height, this.sizeY - 2);
            }
            IIcon icon = this.t.getFluid().getFluid().getIcon();
            int colour = this.t.getFluid().getFluid().getColor();
            this.parent.getTextureManager().func_110577_a(TextureMap.field_110575_b);
            GL11.glColor3ub((byte)((byte)(colour >> 16 & 0xFF)), (byte)((byte)(colour >> 8 & 0xFF)), (byte)((byte)(colour & 0xFF)));
            for (int i = 0; i < height; i += 16) {
                this.drawScaledTexturedModelRectFromIcon(this.posX + 1, this.posY + this.sizeY - height - 1 + i, icon, 16, Math.min(height - i, 16));
            }
        }
        if (this.scale != 0) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.parent.getTextureManager().func_110577_a(this.texture);
            this.drawTexturedModalRect(this.posX + 1, this.posY + (this.scale == 1 ? 6 : 14), this.scale == 1 ? 228 : 210, this.scale == 1 ? 42 : 62, this.sizeX, this.sizeY);
        }
    }

    @Override
    public void update() {
    }

    void drawScaledTexturedModelRectFromIcon(int x, int y, IIcon icon, int width, int height) {
        if (icon == null) {
            return;
        }
        double minU = icon.func_94209_e();
        double maxU = icon.func_94212_f();
        double minV = icon.func_94206_g();
        double maxV = icon.func_94210_h();
        boolean zLevel = false;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 0), (double)(y + height), (double)zLevel, minU, minV + (maxV - minV) * (double)height / 16.0);
        tessellator.func_78374_a((double)(x + width), (double)(y + height), (double)zLevel, minU + (maxU - minU) * (double)width / 16.0, minV + (maxV - minV) * (double)height / 16.0);
        tessellator.func_78374_a((double)(x + width), (double)(y + 0), (double)zLevel, minU + (maxU - minU) * (double)width / 16.0, minV);
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), (double)zLevel, minU, minV);
        tessellator.func_78381_a();
    }
}

