/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.client.gui;

import enhancedportals.client.gui.BaseGui;
import enhancedportals.client.gui.elements.ElementManualCraftingGrid;
import enhancedportals.client.gui.elements.ElementManualTextButton;
import enhancedportals.inventory.ContainerManual;
import enhancedportals.network.ClientProxy;
import enhancedportals.utility.Localization;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiManual
extends BaseGui {
    public static final int CONTAINER_SIZE = 180;
    public static final int CONTAINER_WIDTH = 279;
    static ResourceLocation textureB = new ResourceLocation("enhancedportals", "textures/gui/manualB.png");
    ElementManualCraftingGrid craftingGrid;
    ArrayList<ElementManualTextButton> text_buttons = new ArrayList();
    String NEXT_PAGE;
    String PREV_PAGE;
    String START_PAGE = "enhancedportals.manual.subject";
    int RED = 0xFF0000;
    int DARK_GREY = 0x222222;
    int LIGHT_GREY = 0xBBBBBB;
    int GREY = 0x444444;
    int BLACK = 0;
    int CHARS_PER_ROW = 21;
    int ROWS_PER_PAGE = 12;
    int HEADER_ROWS = 2;
    int PAGE_MARGIN = 130;
    int CONTENT_MARGIN = 100;
    int LINE_HEIGHT = 12;
    String HR = "_____________________";
    String LOC_MANUAL_STRING = "manual.chapter";

    public GuiManual(EntityPlayer p) {
        super(new ContainerManual(p.field_71071_by), 180);
        this.field_146999_f = 279;
        this.setHidePlayerInventory();
        this.texture = new ResourceLocation("enhancedportals", "textures/gui/manualA.png");
    }

    @Override
    protected void drawBackgroundTexture() {
        boolean middleButton;
        this.field_146297_k.field_71446_o.func_110577_a(this.texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, 140, this.field_147000_g);
        this.field_146297_k.field_71446_o.func_110577_a(textureB);
        this.func_73729_b(this.field_147003_i + 140, this.field_147009_r, 0, 0, 139, this.field_147000_g);
        boolean mouseHeight = this.field_147009_r + this.mouseY >= this.field_147009_r + 180 + 3 && this.field_147009_r + this.mouseY < this.field_147009_r + 180 + 13;
        boolean rightButton = mouseHeight && this.field_147003_i + this.mouseX >= this.field_147003_i + 279 - 23 && this.field_147003_i + this.mouseX < this.field_147003_i + 279 - 5;
        boolean leftButton = mouseHeight && this.field_147003_i + this.mouseX >= this.field_147003_i + 5 && this.field_147003_i + this.mouseX < this.field_147003_i + 23;
        boolean bl = middleButton = mouseHeight && this.field_147003_i + this.mouseX >= this.field_147003_i + (this.field_146999_f / 2 - 10) && this.field_147003_i + this.mouseX < this.field_147003_i + (this.field_146999_f / 2 - 10) + 21;
        if (this.nextPage(true)) {
            this.func_73729_b(this.field_147003_i + 279 - 23, this.field_147009_r + 180 + 3, rightButton ? 23 : 0, 233, 18, 10);
        }
        if (this.prevPage(true)) {
            this.func_73729_b(this.field_147003_i + 5, this.field_147009_r + 180 + 3, leftButton ? 23 : 0, 246, 18, 10);
        }
        if (!ClientProxy.manualEntry.equals("subject") && !ClientProxy.manualEntry.equals("contents")) {
            this.func_73729_b(this.field_147003_i + (this.field_146999_f / 2 - 10), this.field_147009_r + 180 + 3, middleButton ? 21 : 0, 222, 21, 10);
        }
    }

    protected void writeChapterHeader() {
        this.writeChapterHeader(ClientProxy.chapterNum);
    }

    protected void writeChapterHeader(int chapter_num) {
        String title = Localization.get(this.LOC_MANUAL_STRING + "." + chapter_num + ".title").trim().toUpperCase();
        this.getFontRenderer().func_78276_b(title, 15, 15, this.RED);
        this.drawSplitString(10, 17, this.PAGE_MARGIN, this.HR, this.LIGHT_GREY);
    }

    protected void drawChapterPages(int chapter_num, int chapter_page) {
        ArrayList<ArrayList<String>> pages = this.getChapterPages(chapter_num);
        int left_margin = (this.PAGE_MARGIN - this.CONTENT_MARGIN) / 2;
        if (chapter_page % 2 == 1) {
            --chapter_page;
        }
        int top_margin = 15;
        if (chapter_page == 0) {
            this.writeChapterHeader(chapter_num);
            top_margin = 35;
        }
        for (String line : pages.get(chapter_page)) {
            this.getFontRenderer().func_78276_b(line.trim(), left_margin, top_margin, this.DARK_GREY);
            top_margin += this.LINE_HEIGHT;
        }
        top_margin = 15;
        if (pages.size() - 1 > chapter_page) {
            for (String line : pages.get(chapter_page + 1)) {
                this.getFontRenderer().func_78276_b(line.trim(), this.PAGE_MARGIN + left_margin, top_margin, this.DARK_GREY);
                top_margin += this.LINE_HEIGHT;
            }
        }
    }

    protected int countChapterPages(int chapter_num) {
        return this.getChapterPages(chapter_num).size();
    }

    protected List<String> parseStringByWidth(String string, int line_char_count) {
        ArrayList<String> lines = new ArrayList<String>();
        do {
            String sub;
            if (string.length() < line_char_count) {
                sub = string;
            } else {
                sub = string.substring(0, line_char_count);
                if (string.length() > line_char_count + 1 && string.charAt(line_char_count - 1) != ' ' && string.charAt(line_char_count) != ' ' && sub.lastIndexOf(32) >= 0) {
                    sub = sub.substring(0, sub.lastIndexOf(32));
                }
            }
            string = string.substring(sub.length());
            lines.add(sub);
        } while (!string.isEmpty());
        return lines;
    }

    protected ArrayList<ArrayList<String>> getChapterPages(int chapter_num) {
        String loc;
        ArrayList<ArrayList<String>> pages = new ArrayList<ArrayList<String>>();
        ArrayList<String> paragraphs = new ArrayList<String>();
        int iterator = 0;
        do {
            loc = this.LOC_MANUAL_STRING + "." + chapter_num + ".p.";
            String paragraph = Localization.get(loc + iterator);
            paragraphs.add(paragraph);
        } while (ClientProxy.locExists(loc + ++iterator));
        while (!paragraphs.isEmpty()) {
            int page_rows;
            ArrayList<String> page = new ArrayList<String>();
            int n = page_rows = pages.size() == 0 ? this.ROWS_PER_PAGE - this.HEADER_ROWS : this.ROWS_PER_PAGE;
            while (page.size() < page_rows && !paragraphs.isEmpty()) {
                ArrayList<String> paragraph_lines = new ArrayList<String>();
                paragraph_lines.addAll(this.parseStringByWidth((String)paragraphs.get(0), this.CHARS_PER_ROW));
                if (paragraph_lines.size() <= page_rows - page.size()) {
                    page = this.addListToArrayList(page, paragraph_lines);
                    if (paragraph_lines.size() != page_rows - page.size()) {
                        page.add("");
                    }
                    paragraphs.remove(0);
                    continue;
                }
                int remove_amt_of_lines = page_rows - page.size();
                page = this.addListToArrayList(page, paragraph_lines.subList(0, remove_amt_of_lines));
                paragraph_lines.subList(0, remove_amt_of_lines).clear();
                paragraphs.remove(0);
                paragraphs.add(0, this.mergeToString(paragraph_lines));
            }
            pages.add(page);
        }
        return pages;
    }

    protected String mergeToString(ArrayList<String> a) {
        ArrayList<String> l = new ArrayList<String>();
        l.addAll(a);
        return this.mergeToString((List<String>)l);
    }

    protected String mergeToString(List<String> list) {
        String string = "";
        for (String i : list) {
            string = string + i;
        }
        return string;
    }

    protected ArrayList<String> addListToArrayList(ArrayList<String> a, List<String> l) {
        for (String i : l) {
            a.add(i);
        }
        return a;
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        this.hideItemLinks();
        if (ClientProxy.manualEntry.equals("subject")) {
            this.hideCraftingTable();
            this.getFontRenderer().func_78276_b("ENHANCED", 160, 70, this.RED);
            this.getFontRenderer().func_78276_b("PORTALS", 210, 70, this.DARK_GREY);
            this.getFontRenderer().func_78279_b(Localization.get("manual.subject.sub").toLowerCase(), 160, 80, this.PAGE_MARGIN, this.LIGHT_GREY);
        } else if (ClientProxy.manualEntry.equals("contents")) {
            this.hideCraftingTable();
            GL11.glEnable((int)3008);
            this.getFontRenderer().func_78279_b("> " + Localization.get("manual.table_of_contents.title").toUpperCase() + " <", 15, 20, this.PAGE_MARGIN, this.RED);
            this.getFontRenderer().func_78279_b(":", 17, 35, this.PAGE_MARGIN, this.RED);
            this.getFontRenderer().func_78279_b(Localization.get("manual.chapter.0.title"), 20, 35, this.PAGE_MARGIN, this.GREY);
            this.getFontRenderer().func_78279_b(":", 17, 50, this.PAGE_MARGIN, this.RED);
            this.getFontRenderer().func_78279_b(Localization.get("manual.chapter.1.title"), 20, 50, this.PAGE_MARGIN, this.GREY);
            this.getFontRenderer().func_78279_b(":", 17, 65, this.PAGE_MARGIN, this.RED);
            this.getFontRenderer().func_78279_b(Localization.get("manual.chapter.2.title"), 20, 65, 120, this.GREY);
            this.getFontRenderer().func_78279_b(":", 17, 80, this.PAGE_MARGIN, this.RED);
            this.getFontRenderer().func_78279_b(Localization.get("manual.chapter.3.title"), 20, 80, 120, this.GREY);
            this.getFontRenderer().func_78279_b(":", 17, 95, this.PAGE_MARGIN, this.RED);
            this.getFontRenderer().func_78279_b(Localization.get("manual.chapter.4.title"), 20, 95, 120, this.GREY);
            this.getFontRenderer().func_78279_b(":", 17, 110, this.PAGE_MARGIN, this.RED);
            this.getFontRenderer().func_78279_b(Localization.get("manual.chapter.5.title"), 20, 110, this.PAGE_MARGIN, this.GREY);
            this.getFontRenderer().func_78279_b(":", 17, 125, this.PAGE_MARGIN, this.RED);
            this.getFontRenderer().func_78279_b(Localization.get("manual.chapter.6.title"), 20, 125, this.PAGE_MARGIN, this.GREY);
            GL11.glDisable((int)3008);
        } else if (ClientProxy.manualEntry.equals("chapter")) {
            this.hideCraftingTable();
            this.drawChapterPages(ClientProxy.chapterNum, ClientProxy.chapterPage);
        } else if (ClientProxy.manualEntry.equals("gallery")) {
            this.hideCraftingTable();
            String title = Localization.get("manual.gallery.title");
            ArrayList<String> items = new ArrayList<String>();
            this.getFontRenderer().func_78276_b(title.toUpperCase(), 40, 15, this.LIGHT_GREY);
            this.getFontRenderer().func_78276_b("==========", 45, 25, this.DARK_GREY);
            switch (ClientProxy.chapterNum) {
                default: {
                    items.add("dbs");
                    items.add("wrench");
                    break;
                }
                case 3: {
                    items.add("frame0");
                    items.add("dbs");
                    items.add("location_card");
                    items.add("wrench");
                    items.add("frame1");
                    items.add("frame3");
                    break;
                }
                case 4: {
                    items.add("frame2");
                    break;
                }
                case 5: {
                    items.add("frame4");
                    break;
                }
                case 6: {
                    items.add("nanobrush");
                    items.add("frame6");
                    items.add("frame7");
                    items.add("frame8");
                    items.add("frame9");
                }
            }
            this.drawItemLinks(items);
        } else {
            GL11.glEnable((int)3008);
            ItemStack[] stacks = ClientProxy.getCraftingRecipeForManualEntry();
            this.craftingGrid.setVisible(stacks != null);
            this.craftingGrid.setItems(stacks);
            int left_margin = 15;
            int top_margin = 15;
            String loc_entry = "manual." + ClientProxy.manualEntry;
            top_margin += this.drawSplitString(left_margin, top_margin, this.CONTENT_MARGIN, Localization.get(loc_entry + ".title").toUpperCase(), this.RED);
            if (ClientProxy.locExists(loc_entry + ".subtitle")) {
                this.getFontRenderer().func_78279_b(Localization.get(loc_entry + ".subtitle"), left_margin, top_margin, this.CONTENT_MARGIN, this.LIGHT_GREY);
            }
            top_margin = 15;
            this.getFontRenderer().func_78279_b(Localization.get(loc_entry + ".info"), this.PAGE_MARGIN + left_margin, top_margin, this.CONTENT_MARGIN, this.DARK_GREY);
            GL11.glDisable((int)3008);
        }
        super.func_146979_b(par1, par2);
    }

    protected void hideCraftingTable() {
        if (this.craftingGrid != null) {
            this.craftingGrid.setVisible(false);
            this.craftingGrid.setItems(null);
        }
    }

    protected void hideItemLinks() {
        if (!this.text_buttons.isEmpty()) {
            for (ElementManualTextButton link : this.text_buttons) {
                link.setVisible(false);
            }
        }
    }

    protected void drawItemLinks(ArrayList<String> items) {
        int top_margin = 40;
        int left_margin = 15;
        for (String item : items) {
            if (!item.isEmpty()) {
                ElementManualTextButton link = new ElementManualTextButton(this, left_margin, top_margin, item);
                link.setVisible(true);
                this.addElement(link);
                this.text_buttons.add(link);
            }
            top_margin += this.LINE_HEIGHT;
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 4 && this.nextPage(true)) {
            this.nextPage();
            return;
        }
        if (mouseButton == 3 && this.prevPage(true)) {
            this.prevPage();
            return;
        }
        if (mouseY >= this.field_147009_r + 180 + 3 && mouseY < this.field_147009_r + 180 + 13) {
            if (mouseX >= this.field_147003_i + 279 - 23 && mouseX < this.field_147003_i + 279 - 5 && this.nextPage(true)) {
                this.nextPage();
                return;
            }
            if (mouseX >= this.field_147003_i + 5 && mouseX < this.field_147003_i + 23 && this.prevPage(true)) {
                this.prevPage();
                return;
            }
            if (mouseX >= this.field_147003_i + (this.field_146999_f / 2 - 10) && mouseX < this.field_147003_i + (this.field_146999_f / 2 - 10) + 21) {
                if (ClientProxy.manualEntry.equals("chapter") || ClientProxy.manualEntry.equals("gallery")) {
                    this.changeEntry("contents");
                } else if (!ClientProxy.manualEntry.equals("subject") && !ClientProxy.manualEntry.equals("contents")) {
                    this.changeEntry("gallery");
                }
                return;
            }
        }
    }

    void nextPage() {
        this.nextPage(false);
    }

    void prevPage() {
        this.prevPage(false);
    }

    boolean nextPage(boolean is_next) {
        if (ClientProxy.manualEntry.equals("subject")) {
            if (is_next) {
                return true;
            }
            this.changeEntry("contents");
        } else if (ClientProxy.manualEntry.equals("contents")) {
            if (is_next) {
                return true;
            }
            ClientProxy.chapterNum = 0;
            ClientProxy.chapterPage = 0;
            this.changeEntry("chapter");
        } else if (ClientProxy.manualEntry.equals("chapter")) {
            int total_chapter_pages = this.countChapterPages(ClientProxy.chapterNum);
            if (total_chapter_pages > ClientProxy.chapterPage + 2) {
                if (is_next) {
                    return true;
                }
                ClientProxy.chapterPage += 2;
                this.changeEntry("chapter");
            } else if (ClientProxy.chapterNum > 1) {
                if (is_next) {
                    return true;
                }
                this.changeEntry("gallery");
            } else if (ClientProxy.manualChapterExists(ClientProxy.chapterNum + 1)) {
                if (is_next) {
                    return true;
                }
                ++ClientProxy.chapterNum;
                ClientProxy.chapterPage = 0;
                this.changeEntry("chapter");
            }
        } else if (ClientProxy.manualEntry.equals("gallery") && ClientProxy.manualChapterExists(ClientProxy.chapterNum + 1)) {
            if (is_next) {
                return true;
            }
            ++ClientProxy.chapterNum;
            ClientProxy.chapterPage = 0;
            this.changeEntry("chapter");
        }
        return false;
    }

    boolean prevPage(boolean is_prev) {
        if (ClientProxy.manualEntry.equals("contents")) {
            if (is_prev) {
                return true;
            }
            this.changeEntry("subject");
        } else if (ClientProxy.manualEntry.equals("chapter")) {
            if (ClientProxy.chapterPage > 1) {
                if (is_prev) {
                    return true;
                }
                ClientProxy.chapterPage -= 2;
                this.changeEntry("chapter");
            } else if (ClientProxy.manualChapterExists(ClientProxy.chapterNum - 1)) {
                if (is_prev) {
                    return true;
                }
                ClientProxy.chapterPage = this.countChapterPages(--ClientProxy.chapterNum) - 1;
                if (ClientProxy.chapterNum > 1) {
                    this.changeEntry("gallery");
                } else {
                    this.changeEntry("chapter");
                }
            } else {
                if (is_prev) {
                    return true;
                }
                ClientProxy.chapterNum = 0;
                ClientProxy.chapterPage = 0;
                this.changeEntry("contents");
            }
        } else if (ClientProxy.manualEntry.equals("gallery")) {
            if (is_prev) {
                return true;
            }
            ClientProxy.chapterPage = this.countChapterPages(ClientProxy.chapterNum) - 1;
            this.changeEntry("chapter");
        }
        return false;
    }

    void changeEntry(String e) {
        ClientProxy.manualChangeEntry(e);
        this.pageChanged();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.craftingGrid = new ElementManualCraftingGrid(this, 37, 57, null);
        if (ClientProxy.manualEntry.equals("subject") || ClientProxy.manualEntry.equals("gallery") || ClientProxy.manualEntry.equals("chapter") || ClientProxy.manualEntry.equals("contents")) {
            this.craftingGrid.setVisible(false);
        }
        this.addElement(this.craftingGrid);
    }

    public void pageChanged() {
    }
}

