/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.client.gui;

import enhancedportals.EnhancedPortals;
import enhancedportals.client.gui.BaseGui;
import enhancedportals.client.gui.elements.ElementScrollDiallingDevice;
import enhancedportals.client.gui.tabs.TabTip;
import enhancedportals.inventory.ContainerDialingDevice;
import enhancedportals.network.ClientProxy;
import enhancedportals.network.packet.PacketGuiData;
import enhancedportals.network.packet.PacketRequestGui;
import enhancedportals.tile.TileController;
import enhancedportals.tile.TileDialingDevice;
import enhancedportals.utility.Localization;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class GuiDialingDevice
extends BaseGui {
    public static final int CONTAINER_SIZE = 175;
    public static final int CONTAINER_WIDTH = 256;
    TileDialingDevice dial;
    TileController controller;
    GuiButton buttonDial;

    public GuiDialingDevice(TileDialingDevice d, EntityPlayer p) {
        super(new ContainerDialingDevice(d, p.field_71071_by), 175);
        this.texture = new ResourceLocation("enhancedportals", "textures/gui/dialling_device.png");
        this.field_146999_f = 256;
        this.dial = d;
        this.controller = this.dial.getPortalController();
        this.name = "gui.dialDevice";
        this.setHidePlayerInventory();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.buttonDial = new GuiButton(1, this.field_147003_i + this.field_146999_f - 147, this.field_147009_r + this.field_147000_g - 27, 140, 20, Localization.get("gui.terminate"));
        this.buttonDial.field_146124_l = this.controller.isPortalActive();
        this.field_146292_n.add(new GuiButton(0, this.field_147003_i + 7, this.field_147009_r + this.field_147000_g - 27, 100, 20, Localization.get("gui.manualEntry")));
        this.field_146292_n.add(this.buttonDial);
        this.addElement(new ElementScrollDiallingDevice(this, this.dial, 7, 28));
        this.addTab(new TabTip((BaseGui)this, "dialling"));
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        this.buttonDial.field_146124_l = this.controller.isPortalActive();
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
        this.getFontRenderer().func_78276_b(Localization.get("gui.storedIdentifiers"), 7, 18, 0x404040);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0) {
            EnhancedPortals.packetPipeline.sendToServer(new PacketRequestGui(this.dial, 5));
        } else if (button.field_146127_k == 1 && this.controller.isPortalActive()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74757_a("terminate", true);
            EnhancedPortals.packetPipeline.sendToServer(new PacketGuiData(tag));
        }
    }

    public void onEntrySelected(int entry) {
        if (!this.controller.isPortalActive()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("dial", entry);
            EnhancedPortals.packetPipeline.sendToServer(new PacketGuiData(tag));
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
        }
    }

    public void onEntryEdited(int entry) {
        ClientProxy.editingID = entry;
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("edit", entry);
        EnhancedPortals.packetPipeline.sendToServer(new PacketGuiData(tag));
    }

    public void onEntryDeleted(int entry) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("delete", entry);
        EnhancedPortals.packetPipeline.sendToServer(new PacketGuiData(tag));
    }
}

