/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.block;

import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import enhancedportals.network.ClientProxy;
import enhancedportals.network.CommonProxy;
import enhancedportals.tile.TileController;
import enhancedportals.tile.TileDialingDevice;
import enhancedportals.tile.TileFrame;
import enhancedportals.tile.TileFrameBasic;
import enhancedportals.tile.TileFrameTransfer;
import enhancedportals.tile.TileNetworkInterface;
import enhancedportals.tile.TilePortalManipulator;
import enhancedportals.tile.TilePortalPart;
import enhancedportals.tile.TileRedstoneInterface;
import enhancedportals.tile.TileTransferEnergy;
import enhancedportals.tile.TileTransferFluid;
import enhancedportals.tile.TileTransferItem;
import enhancedportals.utility.ConnectedTexturesDetailed;
import enhancedportals.utility.IDismantleable;
import enhancedportals.utility.ISidedBlockTexture;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheralProvider", modid="ComputerCraft")})
public class BlockFrame
extends BlockContainer
implements IDismantleable,
IPeripheralProvider {
    public static BlockFrame instance;
    public static ConnectedTexturesDetailed connectedTextures;
    public static IIcon[] overlayIcons;
    public static int PORTAL_CONTROLLER;
    public static int REDSTONE_INTERFACE;
    public static int NETWORK_INTERFACE;
    public static int DIALLING_DEVICE;
    public static int UNUSED;
    public static int MODULE_MANIPULATOR;
    public static int TRANSFER_FLUID;
    public static int TRANSFER_ITEM;
    public static int TRANSFER_ENERGY;
    public static int FRAME_TYPES;
    static IIcon[] fullIcons;

    public BlockFrame(String n) {
        super(Material.field_151576_e);
        instance = this;
        this.func_149647_a(CommonProxy.creativeTab);
        this.func_149711_c(5.0f);
        this.func_149752_b(2000.0f);
        this.func_149663_c(n);
        this.func_149672_a(field_149769_e);
        connectedTextures = new ConnectedTexturesDetailed("enhancedportals:frame/%s", (Block)this, -1);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int unknown) {
        TileEntity t = world.func_147438_o(x, y, z);
        if (t != null && t instanceof TileFrame) {
            ((TileFrame)t).breakBlock(block, unknown);
        }
        super.func_149749_a(world, x, y, z, block, unknown);
    }

    public boolean func_149744_f() {
        return true;
    }

    public boolean canRenderInPass(int pass) {
        ClientProxy.renderPass = pass;
        return pass < 2;
    }

    public int func_149720_d(IBlockAccess blockAccess, int x, int y, int z) {
        TileEntity tile = blockAccess.func_147438_o(x, y, z);
        if (tile instanceof TileFrame) {
            return ((TileFrame)tile).getColour();
        }
        return 0xFFFFFF;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        if (metadata == 0) {
            return new TileFrameBasic();
        }
        if (metadata == PORTAL_CONTROLLER) {
            return new TileController();
        }
        if (metadata == REDSTONE_INTERFACE) {
            return new TileRedstoneInterface();
        }
        if (metadata == NETWORK_INTERFACE) {
            return new TileNetworkInterface();
        }
        if (metadata == DIALLING_DEVICE) {
            return new TileDialingDevice();
        }
        if (metadata == MODULE_MANIPULATOR) {
            return new TilePortalManipulator();
        }
        if (metadata == TRANSFER_FLUID) {
            return new TileTransferFluid();
        }
        if (metadata == TRANSFER_ITEM) {
            return new TileTransferItem();
        }
        if (metadata == TRANSFER_ENERGY) {
            return new TileTransferEnergy();
        }
        return null;
    }

    public int func_149692_a(int par1) {
        return par1;
    }

    @Override
    public void dismantleBlock(EntityPlayer player, World world, int x, int y, int z) {
        ItemStack dropBlock = new ItemStack((Block)this, 1, world.func_72805_g(x, y, z));
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileFrame) {
            ((TileFrame)tile).onBlockDismantled();
        }
        world.func_147468_f(x, y, z);
        if (dropBlock != null) {
            float f = 0.3f;
            double x2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double y2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double z2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem item = new EntityItem(world, (double)x + x2, (double)y + y2, (double)z + z2, dropBlock);
            item.field_145804_b = 10;
            world.func_72838_d((Entity)item);
        }
    }

    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TileEntity tile = blockAccess.func_147438_o(x, y, z);
        if (tile instanceof TileFrame) {
            return ((ISidedBlockTexture)tile).getBlockTexture(side, ClientProxy.renderPass);
        }
        return fullIcons[0];
    }

    public IIcon func_149691_a(int side, int meta) {
        return fullIcons[MathHelper.func_76125_a((int)meta, (int)0, (int)FRAME_TYPES)];
    }

    @Optional.Method(modid="ComputerCraft")
    public IPeripheral getPeripheral(World world, int x, int y, int z, int side) {
        TileEntity t = world.func_147438_o(x, y, z);
        if (t != null && (t instanceof TileController || t instanceof TileNetworkInterface || t instanceof TileDialingDevice || t instanceof TileTransferEnergy || t instanceof TileTransferFluid || t instanceof TileTransferItem)) {
            return (IPeripheral)t;
        }
        return null;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return new ItemStack((Block)this, 1, world.func_72805_g(x, y, z));
    }

    public int func_149701_w() {
        return 1;
    }

    public void func_149666_a(Item par1, CreativeTabs creativeTab, List list) {
        for (int i = 0; i < FRAME_TYPES; ++i) {
            list.add(new ItemStack((Block)this, 1, i));
        }
    }

    public boolean func_149747_d(IBlockAccess p_149747_1_, int p_149747_2_, int p_149747_3_, int p_149747_4_, int p_149747_5_) {
        return false;
    }

    public boolean func_149637_q() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean isNormalCube(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public int func_149748_c(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TileEntity tile = blockAccess.func_147438_o(x, y, z);
        if (tile instanceof TileRedstoneInterface) {
            return ((TileRedstoneInterface)tile).isProvidingPower(side);
        }
        return 0;
    }

    public int func_149709_b(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TileEntity tile = blockAccess.func_147438_o(x, y, z);
        if (tile instanceof TileRedstoneInterface) {
            return ((TileRedstoneInterface)tile).isProvidingPower(side);
        }
        return 0;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileFrame) {
            return ((TileFrame)tile).activate(player, player.field_71071_by.func_70448_g());
        }
        return false;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TilePortalPart) {
            ((TilePortalPart)tile).onBlockPlaced(entity, stack);
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block b) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileRedstoneInterface) {
            ((TileRedstoneInterface)tile).onNeighborBlockChange(b);
        } else if (tile instanceof TileFrameTransfer) {
            ((TileFrameTransfer)tile).onNeighborChanged();
        }
    }

    public void func_149651_a(IIconRegister register) {
        overlayIcons = new IIcon[FRAME_TYPES];
        fullIcons = new IIcon[FRAME_TYPES];
        for (int i = 0; i < overlayIcons.length; ++i) {
            BlockFrame.overlayIcons[i] = register.func_94245_a("enhancedportals:frame_" + i);
            BlockFrame.fullIcons[i] = register.func_94245_a("enhancedportals:frame_" + i + "b");
        }
        connectedTextures.registerIcons(register);
        int counter = 0;
        ClientProxy.customFrameTextures.clear();
        while (ClientProxy.resourceExists("textures/blocks/customFrame/" + String.format("%02d", counter) + ".png")) {
            CommonProxy.logger.debug("Registered custom frame Icon: " + String.format("%02d", counter) + ".png");
            ClientProxy.customFrameTextures.add(register.func_94245_a("enhancedportals:customFrame/" + String.format("%02d", counter)));
            ++counter;
        }
    }

    public boolean func_149646_a(IBlockAccess blockAccess, int x, int y, int z, int s) {
        if (blockAccess.func_147439_a(x, y, z) == this) {
            return false;
        }
        return super.func_149646_a(blockAccess, x, y, z, s);
    }

    static {
        PORTAL_CONTROLLER = 1;
        REDSTONE_INTERFACE = 2;
        NETWORK_INTERFACE = 3;
        DIALLING_DEVICE = 4;
        UNUSED = 5;
        MODULE_MANIPULATOR = 6;
        TRANSFER_FLUID = 7;
        TRANSFER_ITEM = 8;
        TRANSFER_ENERGY = 9;
        FRAME_TYPES = 10;
    }
}

