/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import enhancedportals.block.BlockFrame;
import enhancedportals.network.CommonProxy;
import enhancedportals.network.GuiHandler;
import enhancedportals.network.LogOnHandler;
import enhancedportals.network.PacketPipeline;
import enhancedportals.portal.NetworkManager;
import java.io.File;
import java.lang.reflect.Method;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.world.WorldEvent;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.LoggerConfig;

@Mod(name="EnhancedPortals", modid="enhancedportals", version="3.0.12", dependencies="after:ThermalExpansion")
public class EnhancedPortals {
    public static final String MOD_NAME = "EnhancedPortals";
    public static final String MOD_ID = "enhancedportals";
    public static final String MOD_VERSION = "3.0.12";
    public static final String MOD_DEPENDENCIES = "after:ThermalExpansion";
    public static final String UPDATE_URL = "https://raw.githubusercontent.com/enhancedportals/enhancedportals/master/docs/VERSION";
    public static final String MODID_OPENCOMPUTERS = "OpenComputers";
    public static final String MODID_COMPUTERCRAFT = "ComputerCraft";
    public static final String MODID_THERMALEXPANSION = "ThermalExpansion";
    public static final PacketPipeline packetPipeline = new PacketPipeline();
    @Mod.Instance(value="enhancedportals")
    public static EnhancedPortals instance;
    @SidedProxy(clientSide="enhancedportals.network.ClientProxy", serverSide="enhancedportals.network.CommonProxy")
    public static CommonProxy proxy;

    public EnhancedPortals() {
        LoggerConfig fml = new LoggerConfig(FMLCommonHandler.instance().getFMLLogger().getName(), Level.ALL, true);
        LoggerConfig modConf = new LoggerConfig(CommonProxy.logger.getName(), Level.ALL, true);
        modConf.setParent(fml);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.miscSetup();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
    }

    void initializeComputerCraft() {
        if (!Loader.isModLoaded((String)MODID_COMPUTERCRAFT)) {
            return;
        }
        try {
            Class<?> computerCraft = Class.forName("dan200.computercraft.ComputerCraft");
            Method computerCraft_registerPeripheralProvider = computerCraft.getMethod("registerPeripheralProvider", Class.forName("dan200.computercraft.api.peripheral.IPeripheralProvider"));
            computerCraft_registerPeripheralProvider.invoke(null, BlockFrame.instance);
        }
        catch (Exception e) {
            CommonProxy.logger.error("Could not load the CC-API");
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        packetPipeline.postInitialise();
        this.initializeComputerCraft();
        proxy.setupCrafting();
        if (event.getSide() == Side.CLIENT) {
            FMLCommonHandler.instance().bus().register((Object)new LogOnHandler());
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        proxy.setupConfiguration(new File(event.getSuggestedConfigurationFile().getParentFile(), MOD_NAME + File.separator + "config.cfg"));
        packetPipeline.initalise();
        proxy.registerBlocks();
        proxy.registerTileEntities();
        proxy.registerItems();
        proxy.registerPackets();
        proxy.registerPotions();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        EnhancedPortals.proxy.networkManager = new NetworkManager(event);
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        PotionEffect effect = event.entityLiving.func_70660_b(CommonProxy.featherfallPotion);
        if (effect != null) {
            event.entityLiving.field_70143_R = 0.0f;
            if (event.entityLiving.func_70660_b(CommonProxy.featherfallPotion).func_76459_b() <= 0) {
                event.entityLiving.func_82170_o(CommonProxy.featherfallPotion.field_76415_H);
            }
        }
    }

    @SubscribeEvent
    public void worldSave(WorldEvent.Save event) {
        if (!event.world.field_72995_K) {
            EnhancedPortals.proxy.networkManager.saveAllData();
        }
    }
}

