/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypoint;

import java.awt.Color;
import journeymap.client.Constants;
import journeymap.client.data.WaypointsData;
import journeymap.client.io.FileHandler;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.JmUI;
import journeymap.client.waypoint.ReiReader;
import journeymap.client.waypoint.VoxelReader;
import journeymap.client.waypoint.WaypointStore;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;

public class WaypointHelp
extends JmUI {
    String importReiText;
    String importVoxelText;
    int importReiTextWidth;
    int importVoxelTextWidth;
    private Button buttonRei;
    private Button buttonVoxel;
    private Button buttonClose;

    public WaypointHelp(JmUI returnDisplay) {
        super(Constants.getString("jm.waypoint.help_title"), returnDisplay);
    }

    @Override
    public void func_73866_w_() {
        this.field_146292_n.clear();
        String jmWaypointDir = FileHandler.getWaypointDir().toString();
        FontRenderer fr = this.getFontRenderer();
        String reiFileName = ReiReader.getPointsFilename();
        this.importReiText = Constants.getString("jm.waypoint.help_import_rei", reiFileName, jmWaypointDir);
        this.importReiTextWidth = fr.func_78256_a(this.importReiText);
        this.buttonRei = new Button(Constants.getString("jm.waypoint.help_import_rei_title"));
        this.buttonRei.setEnabled(WaypointsData.isReiMinimapEnabled());
        this.field_146292_n.add(this.buttonRei);
        String voxFileName = VoxelReader.getPointsFilename();
        this.importVoxelText = Constants.getString("jm.waypoint.help_import_voxel", voxFileName, jmWaypointDir);
        this.importVoxelTextWidth = fr.func_78256_a(this.importVoxelText);
        this.buttonVoxel = new Button(Constants.getString("jm.waypoint.help_import_voxel_title"));
        this.buttonVoxel.setEnabled(WaypointsData.isVoxelMapEnabled());
        this.field_146292_n.add(this.buttonVoxel);
        this.buttonClose = new Button(Constants.getString("jm.common.close"));
        this.field_146292_n.add(this.buttonClose);
        new ButtonList(this.buttonRei, this.buttonVoxel).equalizeWidths(this.getFontRenderer());
    }

    @Override
    protected void layoutButtons() {
        if (this.field_146292_n.isEmpty()) {
            this.func_73866_w_();
        }
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (guibutton == this.buttonClose) {
            WaypointStore.instance().load(ReiReader.loadWaypoints(), true);
            this.closeAndReturn();
            return;
        }
        if (guibutton == this.buttonVoxel) {
            WaypointStore.instance().load(VoxelReader.loadWaypoints(), true);
            this.closeAndReturn();
            return;
        }
        if (guibutton == this.buttonRei) {
            this.closeAndReturn();
            return;
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
    }

    @Override
    public void func_73863_a(int par1, int par2, float par3) {
        super.func_73863_a(par1, par2, par3);
        int y = Math.max(30, this.field_146295_m / 8);
        int x = this.field_146294_l / 2 + this.getFontRenderer().func_78256_a(Constants.getString("jm.waypoint.help_create_ingame")) / 3;
        String waypointKey = Constants.getKeyName(Constants.KB_WAYPOINT);
        this.drawHelpStrings(Constants.getString("jm.waypoint.help_create_ingame"), waypointKey, x, y += 12);
        this.drawHelpStrings(Constants.getString("jm.waypoint.help_create_inmap"), waypointKey, x, y += 12);
        this.drawHelpStrings(Constants.getString("jm.waypoint.help_manage_ingame"), Constants.CONTROL_KEYNAME_COMBO + waypointKey, x, y += 12);
        FontRenderer fr = this.getFontRenderer();
        int indentX = this.field_146294_l / 20;
        int indentWidth = this.field_146294_l - indentX;
        int importReiTextWidth = fr.func_78256_a(this.importReiText);
        int importVoxelTextWidth = fr.func_78256_a(this.importVoxelText);
        if (importVoxelTextWidth < indentWidth && importReiTextWidth < indentWidth) {
            indentWidth = Math.max(importReiTextWidth, importVoxelTextWidth);
            indentX = (this.field_146294_l - indentWidth) / 2;
        }
        int reiHeight = fr.func_78271_c(this.importReiText, indentWidth).size() * this.getFontRenderer().field_78288_b;
        this.buttonRei.centerHorizontalOn(this.field_146294_l / 2).setY(y += 24);
        fr.func_78279_b(this.importReiText, indentX, y += this.buttonRei.getHeight() + 5, indentWidth, Color.white.getRGB());
        int voxelHeight = fr.func_78271_c(this.importVoxelText, indentWidth).size() * this.getFontRenderer().field_78288_b;
        this.buttonVoxel.centerHorizontalOn(this.field_146294_l / 2).setY(y += reiHeight + 16);
        if (!this.buttonVoxel.isDrawButton()) {
            fr.func_78261_a("\u00c2\u00a7n" + this.buttonVoxel.field_146126_j, indentX, y, Color.lightGray.getRGB());
        }
        fr.func_78279_b(this.importVoxelText, indentX, y += this.buttonVoxel.getHeight() + 5, indentWidth, Color.white.getRGB());
        this.buttonClose.centerHorizontalOn(this.field_146294_l / 2);
        this.buttonClose.setY(Math.min(y += voxelHeight + 16, this.field_146295_m - this.buttonClose.getHeight()));
    }

    protected void drawHelpStrings(String title, String key, int x, int y) {
        int hgap = 8;
        int tWidth = this.getFontRenderer().func_78256_a(title);
        this.func_73731_b(this.getFontRenderer(), title, x - tWidth - hgap, y, 0xFFFFFF);
        this.func_73731_b(this.getFontRenderer(), key, x + hgap, y, Color.YELLOW.getRGB());
    }
}

