/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.service;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Map;
import journeymap.client.JourneymapClient;
import journeymap.client.data.WorldData;
import journeymap.client.forge.helper.ForgeHelper;
import journeymap.client.io.FileHandler;
import journeymap.client.io.RegionImageHandler;
import journeymap.client.model.MapType;
import journeymap.client.service.BaseService;
import journeymap.client.service.FileService;
import journeymap.common.Journeymap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.world.ChunkCoordIntPair;
import org.apache.logging.log4j.Level;
import se.rupy.http.Event;
import se.rupy.http.Query;

public class TileService
extends FileService {
    public static final String CALLBACK_PARAM = "callback";
    public static final String CHARACTER_ENCODING = "UTF-8";
    private static final long serialVersionUID = 4412225358529161454L;
    private byte[] blankImage;

    @Override
    public String path() {
        return "/tile";
    }

    @Override
    public void filter(Event event) throws Event, Exception {
        File worldDir;
        long start = System.currentTimeMillis();
        Query query = event.query();
        query.parse();
        Minecraft minecraft = ForgeHelper.INSTANCE.getClient();
        WorldClient theWorld = minecraft.field_71441_e;
        if (theWorld == null) {
            this.throwEventException(503, "World not connected", event, false);
        }
        if (!JourneymapClient.getInstance().isMapping().booleanValue()) {
            this.throwEventException(503, "JourneyMap not started", event, false);
        }
        if (!(worldDir = FileHandler.getJMWorldDir(minecraft)).exists() || !worldDir.isDirectory()) {
            this.throwEventException(400, "World not found", event, true);
        }
        try {
            int zoom = this.getParameter((Map<String, String[]>)query, "zoom", 0);
            int x = this.getParameter((Map<String, String[]>)query, "x", 0);
            Integer vSlice = this.getParameter((Map<String, String[]>)query, "depth", (Integer)null);
            int z = this.getParameter((Map<String, String[]>)query, "z", 0);
            int dimension = this.getParameter((Map<String, String[]>)query, "dim", 0);
            String mapTypeString = this.getParameter(query, "mapType", MapType.Name.day.name());
            MapType.Name mapTypeName = null;
            try {
                mapTypeName = MapType.Name.valueOf(mapTypeString);
            }
            catch (Exception e) {
                String error = "Bad request: mapType=" + mapTypeString;
                this.throwEventException(400, error, event, true);
            }
            if (mapTypeName != MapType.Name.underground) {
                vSlice = null;
            }
            if (mapTypeName == MapType.Name.underground && WorldData.isHardcoreAndMultiplayer()) {
                BaseService.ResponseHeader.on(event).contentType(BaseService.ContentType.png).noCache();
                this.serveFile(RegionImageHandler.getBlank512x512ImageFile(), event);
            } else {
                int scale = (int)Math.pow(2.0, zoom);
                int distance = 32 / scale;
                int minChunkX = x * distance;
                int minChunkZ = z * distance;
                int maxChunkX = minChunkX + distance - 1;
                int maxChunkZ = minChunkZ + distance - 1;
                ChunkCoordIntPair startCoord = new ChunkCoordIntPair(minChunkX, minChunkZ);
                ChunkCoordIntPair endCoord = new ChunkCoordIntPair(maxChunkX, maxChunkZ);
                boolean showGrid = JourneymapClient.getFullMapProperties().showGrid.get();
                MapType mapType = new MapType(mapTypeName, vSlice, dimension);
                BufferedImage img = RegionImageHandler.getMergedChunks(worldDir, startCoord, endCoord, mapType, true, null, 512, 512, false, showGrid);
                BaseService.ResponseHeader.on(event).contentType(BaseService.ContentType.png).noCache();
                this.serveImage(event, img);
            }
            long stop = System.currentTimeMillis();
            if (Journeymap.getLogger().isEnabled(Level.DEBUG)) {
                Journeymap.getLogger().debug(stop - start + "ms to serve tile");
            }
        }
        catch (NumberFormatException e) {
            this.reportMalformedRequest(event);
        }
    }
}

