/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.ingame;

import java.util.Collection;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.RGB;
import journeymap.client.forge.helper.ForgeHelper;
import journeymap.client.forge.helper.IRenderHelper;
import journeymap.client.log.LogFormatter;
import journeymap.client.model.Waypoint;
import journeymap.client.properties.WaypointProperties;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.texture.TextureImpl;
import journeymap.client.waypoint.WaypointStore;
import journeymap.common.Journeymap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;

public class RenderWaypointBeacon {
    static final ResourceLocation beam = new ResourceLocation("textures/entity/beacon_beam.png");
    static Minecraft mc = ForgeHelper.INSTANCE.getClient();
    static RenderManager renderManager = ForgeHelper.INSTANCE.getRenderManager();
    static IRenderHelper renderHelper = ForgeHelper.INSTANCE.getRenderHelper();
    static String distanceLabel = Constants.getString("jm.waypoint.distance_meters", "%1.0f");
    static WaypointProperties waypointProperties;

    public static void resetStatTimers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderAll() {
        try {
            waypointProperties = JourneymapClient.getWaypointProperties();
            Collection<Waypoint> waypoints = WaypointStore.instance().getAll();
            int playerDim = RenderWaypointBeacon.mc.field_71439_g.field_71093_bK;
            for (Waypoint wp : waypoints) {
                if (!wp.isEnable() || !wp.getDimensions().contains(playerDim)) continue;
                try {
                    RenderWaypointBeacon.doRender(wp);
                }
                catch (Throwable t) {
                    Journeymap.getLogger().error("EntityWaypoint failed to render for " + wp + ": " + LogFormatter.toString(t));
                }
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error rendering waypoints: " + LogFormatter.toString(t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void doRender(Waypoint waypoint) {
        if (RenderWaypointBeacon.renderManager.field_78734_h == null) {
            return;
        }
        RenderHelper.func_74519_b();
        try {
            Vec3 playerVec = ForgeHelper.INSTANCE.getEntityPositionVector((Entity)RenderWaypointBeacon.renderManager.field_78734_h);
            Vec3 waypointVec = waypoint.getPosition().func_72441_c(0.0, 0.118, 0.0);
            double actualDistance = playerVec.func_72438_d(waypointVec);
            int maxDistance = RenderWaypointBeacon.waypointProperties.maxDistance.get();
            if (maxDistance > 0 && actualDistance > (double)maxDistance) {
                return;
            }
            double viewDistance = actualDistance;
            double maxRenderDistance = RenderWaypointBeacon.mc.field_71474_y.field_151451_c * 16;
            if (viewDistance > maxRenderDistance) {
                Vec3 delta = waypointVec.func_72444_a(playerVec).func_72432_b();
                waypointVec = playerVec.func_72441_c(-delta.field_72450_a * maxRenderDistance, -delta.field_72448_b * maxRenderDistance, -delta.field_72449_c * maxRenderDistance);
                viewDistance = maxRenderDistance;
            }
            double shiftX = waypointVec.field_72450_a - RenderWaypointBeacon.renderManager.field_78730_l;
            double shiftY = waypointVec.field_72448_b - RenderWaypointBeacon.renderManager.field_78731_m;
            double shiftZ = waypointVec.field_72449_c - RenderWaypointBeacon.renderManager.field_78728_n;
            boolean showStaticBeam = RenderWaypointBeacon.waypointProperties.showStaticBeam.get();
            boolean showRotatingBeam = RenderWaypointBeacon.waypointProperties.showRotatingBeam.get();
            if (showStaticBeam || showRotatingBeam) {
                RenderWaypointBeacon.renderBeam(shiftX, -RenderWaypointBeacon.renderManager.field_78731_m, shiftZ, waypoint.getColor(), showStaticBeam, showRotatingBeam);
            }
            String label = waypoint.getName();
            boolean labelHidden = false;
            if (viewDistance > 0.5 && RenderWaypointBeacon.waypointProperties.autoHideLabel.get()) {
                double playerYaw;
                int angle = 5;
                double yaw = Math.atan2(RenderWaypointBeacon.renderManager.field_78728_n - waypointVec.field_72449_c, RenderWaypointBeacon.renderManager.field_78730_l - waypointVec.field_72450_a);
                double degrees = Math.toDegrees(yaw) + 90.0;
                if (degrees < 0.0) {
                    degrees = 360.0 + degrees;
                }
                if ((playerYaw = (double)(RenderWaypointBeacon.renderManager.field_78734_h.func_70079_am() % 360.0f)) < 0.0) {
                    playerYaw += 360.0;
                }
                playerYaw = Math.toRadians(playerYaw);
                double playerDegrees = Math.toDegrees(playerYaw);
                labelHidden = Math.abs((degrees += (double)angle) + (double)angle - ((playerDegrees += (double)angle) + (double)angle)) > (double)angle;
            }
            double scale = 0.00390625 * ((viewDistance + 4.0) / 3.0);
            TextureImpl texture = waypoint.getTexture();
            double halfTexHeight = texture.getHeight() / 2;
            boolean showName = RenderWaypointBeacon.waypointProperties.showName.get() && label != null && label.length() > 0;
            boolean showDistance = RenderWaypointBeacon.waypointProperties.showDistance.get();
            if (!labelHidden && (showName || showDistance)) {
                StringBuilder sb = new StringBuilder();
                if (RenderWaypointBeacon.waypointProperties.boldLabel.get()) {
                    sb.append(EnumChatFormatting.BOLD);
                }
                if (showName) {
                    sb.append(label);
                }
                if (showName && showDistance) {
                    sb.append(" ");
                }
                if (showDistance) {
                    sb.append(String.format(distanceLabel, actualDistance));
                }
                if (sb.length() > 0) {
                    label = sb.toString();
                    GL11.glPushMatrix();
                    renderHelper.glDisableLighting();
                    GL11.glNormal3d((double)0.0, (double)0.0, (double)(-1.0 * scale));
                    GL11.glTranslated((double)shiftX, (double)shiftY, (double)shiftZ);
                    GL11.glRotatef((float)(-RenderWaypointBeacon.renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)RenderWaypointBeacon.renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
                    renderHelper.glScaled(-scale, -scale, scale);
                    renderHelper.glDepthMask(true);
                    renderHelper.glEnableDepth();
                    int fontScale = RenderWaypointBeacon.waypointProperties.fontScale.get();
                    double labelY = 0.0 - halfTexHeight - 8.0;
                    DrawUtil.drawLabel(label, 1.0, labelY, DrawUtil.HAlign.Center, DrawUtil.VAlign.Above, 0, 150, waypoint.getSafeColor(), 255, fontScale, false);
                    renderHelper.glDisableDepth();
                    renderHelper.glDepthMask(false);
                    DrawUtil.drawLabel(label, 1.0, labelY, DrawUtil.HAlign.Center, DrawUtil.VAlign.Above, 0, 100, waypoint.getSafeColor(), 255, fontScale, false);
                    GL11.glPopMatrix();
                }
            }
            if (viewDistance > 0.1 && RenderWaypointBeacon.waypointProperties.showTexture.get()) {
                GL11.glPushMatrix();
                renderHelper.glDisableLighting();
                GL11.glNormal3d((double)0.0, (double)0.0, (double)(-1.0 * scale));
                renderHelper.glDisableDepth();
                renderHelper.glDepthMask(false);
                int n = RenderWaypointBeacon.waypointProperties.textureSmall.get() ? 1 : 2;
                GL11.glTranslated((double)shiftX, (double)shiftY, (double)shiftZ);
                GL11.glRotatef((float)(-RenderWaypointBeacon.renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)RenderWaypointBeacon.renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
                renderHelper.glScaled(-(scale *= (double)n), -scale, scale);
                GL11.glNormal3d((double)0.0, (double)0.0, (double)(-1.0 * scale));
                DrawUtil.drawColoredImage(texture, 255, waypoint.getColor(), (double)(0 - texture.getWidth() / 2) + 0.5, 0.0 - halfTexHeight + 0.2, 0.0);
                GL11.glPopMatrix();
            }
        }
        finally {
            renderHelper.glDepthMask(true);
            renderHelper.glEnableDepth();
            renderHelper.glEnableLighting();
            renderHelper.glDepthMask(true);
            renderHelper.glEnableCull();
            renderHelper.glDisableBlend();
            renderHelper.glDisableFog();
            RenderHelper.func_74518_a();
        }
    }

    static void renderBeam(double x, double y, double z, Integer color, boolean staticBeam, boolean rotatingBeam) {
        float f1 = 1.0f;
        RenderWaypointBeacon.mc.field_71446_o.func_110577_a(beam);
        GL11.glTexParameterf((int)3553, (int)10242, (float)10497.0f);
        renderHelper.glDisableLighting();
        renderHelper.glDisableBlend();
        renderHelper.glEnableDepth();
        renderHelper.glBlendFunc(770, 1, 1, 0);
        float time = RenderWaypointBeacon.mc.field_71441_e.func_82737_E();
        if (mc.func_147113_T()) {
            time = Minecraft.func_71386_F() / 50L;
        }
        float texOffset = -(-time * 0.2f - (float)MathHelper.func_76141_d((float)(-time * 0.1f))) * 0.6f;
        if (rotatingBeam) {
            boolean b0 = true;
            double d3 = (double)time * 0.025 * (1.0 - (double)(b0 & true) * 2.5);
            renderHelper.startDrawingQuads();
            float[] c = RGB.floats(color);
            renderHelper.glColor4f(c[0], c[1], c[2], 0.45f);
            renderHelper.glEnableBlend();
            double d4 = (double)b0 * 0.2;
            double d5 = Math.cos(d3 + 2.356194490192345) * d4;
            double d6 = Math.sin(d3 + 2.356194490192345) * d4;
            double d7 = Math.cos(d3 + 0.7853981633974483) * d4;
            double d8 = Math.sin(d3 + 0.7853981633974483) * d4;
            double d9 = Math.cos(d3 + 3.9269908169872414) * d4;
            double d10 = Math.sin(d3 + 3.9269908169872414) * d4;
            double d11 = Math.cos(d3 + 5.497787143782138) * d4;
            double d12 = Math.sin(d3 + 5.497787143782138) * d4;
            double d13 = 256.0f * f1;
            double d14 = 0.0;
            double d15 = 1.0;
            double d16 = -1.0f + texOffset;
            double d17 = (double)(256.0f * f1) * (0.5 / d4) + d16;
            renderHelper.addVertexWithUV(x + d5, y + d13, z + d6, d15, d17);
            renderHelper.addVertexWithUV(x + d5, y, z + d6, d15, d16);
            renderHelper.addVertexWithUV(x + d7, y, z + d8, d14, d16);
            renderHelper.addVertexWithUV(x + d7, y + d13, z + d8, d14, d17);
            renderHelper.addVertexWithUV(x + d11, y + d13, z + d12, d15, d17);
            renderHelper.addVertexWithUV(x + d11, y, z + d12, d15, d16);
            renderHelper.addVertexWithUV(x + d9, y, z + d10, d14, d16);
            renderHelper.addVertexWithUV(x + d9, y + d13, z + d10, d14, d17);
            renderHelper.addVertexWithUV(x + d7, y + d13, z + d8, d15, d17);
            renderHelper.addVertexWithUV(x + d7, y, z + d8, d15, d16);
            renderHelper.addVertexWithUV(x + d11, y, z + d12, d14, d16);
            renderHelper.addVertexWithUV(x + d11, y + d13, z + d12, d14, d17);
            renderHelper.addVertexWithUV(x + d9, y + d13, z + d10, d15, d17);
            renderHelper.addVertexWithUV(x + d9, y, z + d10, d15, d16);
            renderHelper.addVertexWithUV(x + d5, y, z + d6, d14, d16);
            renderHelper.addVertexWithUV(x + d5, y + d13, z + d6, d14, d17);
            renderHelper.draw();
        }
        if (staticBeam) {
            renderHelper.glDisableCull();
            double d26 = 256.0f * f1;
            double d29 = -1.0f + texOffset;
            double d30 = (double)(256.0f * f1) + d29;
            x -= 0.5;
            z -= 0.5;
            renderHelper.glEnableBlend();
            renderHelper.glBlendFunc(770, 771, 1, 0);
            renderHelper.glDepthMask(false);
            renderHelper.startDrawingQuads();
            float[] c = RGB.floats(color);
            renderHelper.glColor4f(c[0], c[1], c[2], 0.15f);
            renderHelper.addVertexWithUV(x + 0.2, y + d26, z + 0.2, 1.0, d30);
            renderHelper.addVertexWithUV(x + 0.2, y, z + 0.2, 1.0, d29);
            renderHelper.addVertexWithUV(x + 0.8, y, z + 0.2, 0.0, d29);
            renderHelper.addVertexWithUV(x + 0.8, y + d26, z + 0.2, 0.0, d30);
            renderHelper.addVertexWithUV(x + 0.8, y + d26, z + 0.8, 1.0, d30);
            renderHelper.addVertexWithUV(x + 0.8, y, z + 0.8, 1.0, d29);
            renderHelper.addVertexWithUV(x + 0.2, y, z + 0.8, 0.0, d29);
            renderHelper.addVertexWithUV(x + 0.2, y + d26, z + 0.8, 0.0, d30);
            renderHelper.addVertexWithUV(x + 0.8, y + d26, z + 0.2, 1.0, d30);
            renderHelper.addVertexWithUV(x + 0.8, y, z + 0.2, 1.0, d29);
            renderHelper.addVertexWithUV(x + 0.8, y, z + 0.8, 0.0, d29);
            renderHelper.addVertexWithUV(x + 0.8, y + d26, z + 0.8, 0.0, d30);
            renderHelper.addVertexWithUV(x + 0.2, y + d26, z + 0.8, 1.0, d30);
            renderHelper.addVertexWithUV(x + 0.2, y, z + 0.8, 1.0, d29);
            renderHelper.addVertexWithUV(x + 0.2, y, z + 0.2, 0.0, d29);
            renderHelper.addVertexWithUV(x + 0.2, y + d26, z + 0.2, 0.0, d30);
            renderHelper.draw();
            renderHelper.glDisableBlend();
        }
        renderHelper.glEnableLighting();
        renderHelper.glEnableTexture2D();
        renderHelper.glEnableLighting();
        renderHelper.glEnableDepth();
    }
}

