/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.feature;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import journeymap.client.feature.Feature;
import journeymap.client.feature.Policy;
import journeymap.common.Journeymap;

public class FeatureManager {
    private static final String NAME_FAIRPLAY = "FairPlay";
    private static final String IMPL_PACKAGE = "journeymap.client.feature.impl";
    private static final String CLASS_UNLIMITED = String.format("%s.Unlimited", "journeymap.client.feature.impl");
    private final PolicySet policySet;
    private final HashMap<Feature, Policy> policyMap = new HashMap();
    private final HashMap<String, EnumSet<Feature>> disableControlCodes = new HashMap();
    private Boolean controlCodeAltered = null;

    private FeatureManager() {
        this.disableControlCodes.put("\u00a73 \u00a76 \u00a73 \u00a76 \u00a73 \u00a76 \u00a7e", Feature.radar());
        this.disableControlCodes.put("\u00a73\u00a76\u00a73\u00a76\u00a73\u00a76\u00a7e", Feature.radar());
        this.disableControlCodes.put("\u00a73 \u00a76 \u00a73 \u00a76 \u00a73 \u00a76 \u00a7d", EnumSet.of(Feature.MapCaves));
        this.disableControlCodes.put("\u00a73\u00a76\u00a73\u00a76\u00a73\u00a76\u00a7d", EnumSet.of(Feature.MapCaves));
        this.policySet = this.locatePolicySet();
        this.reset();
    }

    public static String getPolicyDetails() {
        StringBuilder sb = new StringBuilder(String.format("%s Features: ", FeatureManager.getPolicySetName()));
        for (Feature feature : Feature.values()) {
            boolean single = false;
            boolean multi = false;
            if (Holder.INSTANCE.policyMap.containsKey((Object)feature)) {
                single = Holder.INSTANCE.policyMap.get((Object)((Object)feature)).allowInSingleplayer;
                multi = Holder.INSTANCE.policyMap.get((Object)((Object)feature)).allowInMultiplayer;
            }
            sb.append(String.format("\n\t%s : singleplayer = %s , multiplayer = %s", feature.name(), single, multi));
        }
        return sb.toString();
    }

    public static FeatureManager instance() {
        return Holder.INSTANCE;
    }

    public static boolean isAllowed(Feature feature) {
        Policy policy = Holder.INSTANCE.policyMap.get((Object)feature);
        return policy != null && policy.isCurrentlyAllowed();
    }

    public static Map<Feature, Boolean> getAllowedFeatures() {
        HashMap<Feature, Boolean> map = new HashMap<Feature, Boolean>(Feature.values().length * 2);
        for (Feature feature : Feature.values()) {
            map.put(feature, FeatureManager.isAllowed(feature));
        }
        return map;
    }

    public static String getPolicySetName() {
        return FeatureManager.instance().policySet.getName();
    }

    public Set<String> getControlCodes() {
        return this.disableControlCodes.keySet();
    }

    public void handleControlCode(String controlCode) {
        if (this.disableControlCodes.containsKey(controlCode)) {
            this.controlCodeAltered = true;
            for (Feature feature : this.disableControlCodes.get(controlCode)) {
                Journeymap.getLogger().info("Feature disabled in multiplayer via control code: " + (Object)((Object)feature));
                Holder.INSTANCE.policyMap.put(feature, new Policy(feature, true, false));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        PolicySet policySet = this.policySet;
        synchronized (policySet) {
            if (this.controlCodeAltered == null || this.controlCodeAltered.booleanValue()) {
                for (Policy policy : this.policySet.getPolicies()) {
                    this.policyMap.put(policy.feature, policy);
                }
                if (this.controlCodeAltered != null) {
                    Journeymap.getLogger().info("Returning to default " + FeatureManager.getPolicyDetails());
                }
                this.controlCodeAltered = false;
            }
        }
    }

    private PolicySet locatePolicySet() {
        PolicySet fs;
        block6: {
            fs = null;
            try {
                ClassPath cp = ClassPath.from((ClassLoader)this.getClass().getClassLoader());
                ImmutableSet classInfos = cp.getTopLevelClasses(IMPL_PACKAGE);
                if (classInfos.size() > 1) {
                    try {
                        Class<?> fsClass = Class.forName(CLASS_UNLIMITED);
                        fs = (PolicySet)fsClass.newInstance();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                if (fs != null) break block6;
                for (ClassPath.ClassInfo classInfo : classInfos) {
                    Class aClass = classInfo.load();
                    if (!PolicySet.class.isAssignableFrom(aClass)) continue;
                    fs = (PolicySet)aClass.newInstance();
                    break;
                }
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
            }
        }
        return fs != null ? fs : this.createFairPlay();
    }

    private PolicySet createFairPlay() {
        return new PolicySet(){
            private final Set<Policy> policies = Policy.bulkCreate(true, false);
            private final String name = "FairPlay";

            @Override
            public Set<Policy> getPolicies() {
                return this.policies;
            }

            @Override
            public String getName() {
                return FeatureManager.NAME_FAIRPLAY;
            }
        };
    }

    private static class Holder {
        private static final FeatureManager INSTANCE = new FeatureManager();

        private Holder() {
        }
    }

    public static interface PolicySet {
        public Set<Policy> getPolicies();

        public String getName();
    }
}

