/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.panel;

import cpw.mods.fml.common.FMLCommonHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Facing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import shedar.mods.ic2.nuclearcontrol.IC2NuclearControl;
import shedar.mods.ic2.nuclearcontrol.IScreenPart;
import shedar.mods.ic2.nuclearcontrol.panel.Screen;
import shedar.mods.ic2.nuclearcontrol.tileentities.TileEntityAdvancedInfoPanel;
import shedar.mods.ic2.nuclearcontrol.tileentities.TileEntityAdvancedInfoPanelExtender;
import shedar.mods.ic2.nuclearcontrol.tileentities.TileEntityInfoPanel;
import shedar.mods.ic2.nuclearcontrol.tileentities.TileEntityInfoPanelExtender;

public class ScreenManager {
    private final Map<Integer, List<Screen>> screens = new HashMap<Integer, List<Screen>>();
    private final Map<Integer, List<TileEntityInfoPanel>> unusedPanels = new HashMap<Integer, List<TileEntityInfoPanel>>();

    private int getWorldKey(World world) {
        if (world == null) {
            return -10;
        }
        if (world.func_72912_H() == null) {
            return -10;
        }
        if (world.func_72912_H().func_76076_i() == 0 && world.field_73011_w != null) {
            return world.field_73011_w.field_76574_g;
        }
        return world.func_72912_H().func_76076_i();
    }

    private boolean isValidExtender(World world, int x, int y, int z, int facing, boolean advanced) {
        if (world.func_147439_a(x, y, z) != IC2NuclearControl.blockNuclearControlMain) {
            return false;
        }
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!(tileEntity instanceof TileEntityInfoPanelExtender)) {
            return false;
        }
        if (advanced ^ tileEntity instanceof TileEntityAdvancedInfoPanelExtender) {
            return false;
        }
        if (((TileEntityInfoPanelExtender)tileEntity).facing != facing) {
            return false;
        }
        return ((IScreenPart)tileEntity).getScreen() == null;
    }

    private void updateScreenBound(Screen screen, int dx, int dy, int dz, World world, boolean advanced) {
        if (dx == 0 && dy == 0 && dz == 0) {
            return;
        }
        boolean isMin = dx + dy + dz < 0;
        int dir = isMin ? 1 : -1;
        for (int steps = 0; steps < 20; ++steps) {
            int z;
            int y;
            int x;
            if (isMin) {
                x = screen.minX + dx;
                y = screen.minY + dy;
                z = screen.minZ + dz;
            } else {
                x = screen.maxX + dx;
                y = screen.maxY + dy;
                z = screen.maxZ + dz;
            }
            int rx = dx != 0 ? 0 : screen.maxX - screen.minX;
            int ry = dy != 0 ? 0 : screen.maxY - screen.minY;
            int rz = dz != 0 ? 0 : screen.maxZ - screen.minZ;
            boolean allOk = true;
            for (int interX = 0; interX <= rx && allOk; ++interX) {
                for (int interY = 0; interY <= ry && allOk; ++interY) {
                    for (int interZ = 0; interZ <= rz && allOk; ++interZ) {
                        TileEntityInfoPanel core = screen.getCore((IBlockAccess)world);
                        allOk = core != null && this.isValidExtender(world, x + dir * interX, y + dir * interY, z + dir * interZ, core.facing, advanced);
                    }
                }
            }
            if (!allOk) break;
            if (isMin) {
                screen.minX += dx;
                screen.minY += dy;
                screen.minZ += dz;
                continue;
            }
            screen.maxX += dx;
            screen.maxY += dy;
            screen.maxZ += dz;
        }
    }

    public Screen loadScreen(TileEntityInfoPanel panel) {
        if (panel.screenData != null) {
            NBTTagCompound tag = panel.screenData;
            Screen screen = new Screen();
            screen.minX = tag.func_74762_e("minX");
            screen.minY = tag.func_74762_e("minY");
            screen.minZ = tag.func_74762_e("minZ");
            screen.maxX = tag.func_74762_e("maxX");
            screen.maxY = tag.func_74762_e("maxY");
            screen.maxZ = tag.func_74762_e("maxZ");
            screen.setCore(panel);
            if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                Integer key = this.getWorldKey(panel.func_145831_w());
                if (!this.screens.containsKey(key)) {
                    this.screens.put(key, new ArrayList());
                }
                if (!this.unusedPanels.containsKey(key)) {
                    this.unusedPanels.put(key, new ArrayList());
                }
                if (!this.screens.get(key).contains(screen)) {
                    this.screens.get(key).add(screen);
                }
            }
            return screen;
        }
        return null;
    }

    public Screen loadScreen(World world, int coreX, int coreY, int coreZ) {
        TileEntity core = world.func_147438_o(coreX, coreY, coreZ);
        if (core != null && core instanceof TileEntityInfoPanel) {
            return this.loadScreen((TileEntityInfoPanel)core);
        }
        return null;
    }

    private Screen tryBuildFromPanel(TileEntityInfoPanel panel) {
        boolean advanced = panel instanceof TileEntityAdvancedInfoPanel;
        Screen screen = new Screen();
        screen.maxX = screen.minX = panel.field_145851_c;
        screen.maxY = screen.minY = panel.field_145848_d;
        screen.maxZ = screen.minZ = panel.field_145849_e;
        screen.setCore(panel);
        int dx = Facing.field_71586_b[panel.facing] != 0 ? 0 : -1;
        int dy = Facing.field_71587_c[panel.facing] != 0 ? 0 : -1;
        int dz = Facing.field_71585_d[panel.facing] != 0 ? 0 : -1;
        this.updateScreenBound(screen, dx, 0, 0, panel.func_145831_w(), advanced);
        this.updateScreenBound(screen, -dx, 0, 0, panel.func_145831_w(), advanced);
        this.updateScreenBound(screen, 0, dy, 0, panel.func_145831_w(), advanced);
        this.updateScreenBound(screen, 0, -dy, 0, panel.func_145831_w(), advanced);
        this.updateScreenBound(screen, 0, 0, dz, panel.func_145831_w(), advanced);
        this.updateScreenBound(screen, 0, 0, -dz, panel.func_145831_w(), advanced);
        screen.init(false, panel.func_145831_w());
        panel.updateData();
        return screen;
    }

    private void destroyScreen(Screen screen, World world) {
        this.screens.get(this.getWorldKey(world)).remove(screen);
        screen.destroy(false, world);
    }

    public void unregisterScreenPart(TileEntity part) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        if (!this.screens.containsKey(this.getWorldKey(part.func_145831_w()))) {
            return;
        }
        if (!this.unusedPanels.containsKey(this.getWorldKey(part.func_145831_w()))) {
            return;
        }
        if (!(part instanceof IScreenPart)) {
            return;
        }
        IScreenPart screenPart = (IScreenPart)part;
        Screen screen = screenPart.getScreen();
        if (screen == null) {
            if (part instanceof TileEntityInfoPanel && this.unusedPanels.get(this.getWorldKey(part.func_145831_w())).contains(part)) {
                this.unusedPanels.get(this.getWorldKey(part.func_145831_w())).remove(part);
            }
            return;
        }
        TileEntityInfoPanel core = screen.getCore((IBlockAccess)part.func_145831_w());
        this.destroyScreen(screen, part.func_145831_w());
        boolean isCoreDestroyed = part instanceof TileEntityInfoPanel;
        if (!isCoreDestroyed && core != null) {
            Screen newScreen = this.tryBuildFromPanel(core);
            if (newScreen == null) {
                this.unusedPanels.get(this.getWorldKey(core.func_145831_w())).add(core);
            } else {
                this.screens.get(this.getWorldKey(core.func_145831_w())).add(newScreen);
            }
        }
    }

    public void registerInfoPanel(TileEntityInfoPanel panel) {
        Screen screen;
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        if (!this.screens.containsKey(this.getWorldKey(panel.func_145831_w()))) {
            this.screens.put(this.getWorldKey(panel.func_145831_w()), new ArrayList());
        }
        if (!this.unusedPanels.containsKey(this.getWorldKey(panel.func_145831_w()))) {
            this.unusedPanels.put(this.getWorldKey(panel.func_145831_w()), new ArrayList());
        }
        for (Screen screen2 : this.screens.get(this.getWorldKey(panel.func_145831_w()))) {
            if (!screen2.isBlockPartOf(panel)) continue;
            this.destroyScreen(screen2, panel.func_145831_w());
            break;
        }
        if ((screen = this.tryBuildFromPanel(panel)) != null) {
            this.screens.get(this.getWorldKey(panel.func_145831_w())).add(screen);
        } else {
            this.unusedPanels.get(this.getWorldKey(panel.func_145831_w())).add(panel);
        }
    }

    public void registerInfoPanelExtender(TileEntityInfoPanelExtender extender) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        if (!this.screens.containsKey(this.getWorldKey(extender.func_145831_w()))) {
            this.screens.put(this.getWorldKey(extender.func_145831_w()), new ArrayList());
        }
        if (!this.unusedPanels.containsKey(this.getWorldKey(extender.func_145831_w()))) {
            this.unusedPanels.put(this.getWorldKey(extender.func_145831_w()), new ArrayList());
        }
        ArrayList<TileEntityInfoPanel> rebuildPanels = new ArrayList<TileEntityInfoPanel>();
        ArrayList<Screen> screensToDestroy = new ArrayList<Screen>();
        for (Screen screen : this.screens.get(this.getWorldKey(extender.func_145831_w()))) {
            TileEntityInfoPanel core = screen.getCore((IBlockAccess)extender.func_145831_w());
            if (screen.isBlockNearby(extender) && core != null && extender.facing == core.facing) {
                rebuildPanels.add(core);
                screensToDestroy.add(screen);
                continue;
            }
            if (!screen.isBlockPartOf(extender)) continue;
            return;
        }
        for (Screen screen : screensToDestroy) {
            this.destroyScreen(screen, extender.func_145831_w());
        }
        for (TileEntityInfoPanel panel : this.unusedPanels.get(this.getWorldKey(extender.func_145831_w()))) {
            if ((panel.field_145851_c != extender.field_145851_c || panel.field_145848_d != extender.field_145848_d || panel.field_145849_e != extender.field_145849_e + 1 && panel.field_145849_e != extender.field_145849_e - 1) && (panel.field_145851_c != extender.field_145851_c || panel.field_145848_d != extender.field_145848_d + 1 && panel.field_145848_d != extender.field_145848_d - 1 || panel.field_145849_e != extender.field_145849_e) && (panel.field_145851_c != extender.field_145851_c + 1 && panel.field_145851_c != extender.field_145851_c - 1 || panel.field_145848_d != extender.field_145848_d || panel.field_145849_e != extender.field_145849_e) || extender.facing != panel.facing) continue;
            rebuildPanels.add(panel);
        }
        for (TileEntityInfoPanel panel : rebuildPanels) {
            Screen screen = this.tryBuildFromPanel(panel);
            if (screen != null) {
                this.screens.get(this.getWorldKey(extender.func_145831_w())).add(screen);
                if (!this.unusedPanels.get(this.getWorldKey(extender.func_145831_w())).contains(panel)) continue;
                this.unusedPanels.get(this.getWorldKey(extender.func_145831_w())).remove(panel);
                continue;
            }
            if (this.unusedPanels.get(this.getWorldKey(extender.func_145831_w())).contains(panel)) continue;
            this.unusedPanels.get(this.getWorldKey(extender.func_145831_w())).add(panel);
        }
    }

    public void clearWorld(World world) {
        if (this.screens.containsKey(this.getWorldKey(world))) {
            this.screens.get(this.getWorldKey(world)).clear();
        }
    }
}

