/*
 * Decompiled with CFR 0.152.
 */
package com.jadarstudios.developercapes.cape;

import com.google.common.collect.HashBiMap;
import com.google.common.primitives.UnsignedBytes;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.jadarstudios.developercapes.DevCapes;
import com.jadarstudios.developercapes.cape.CapeConfig;
import com.jadarstudios.developercapes.user.Group;
import com.jadarstudios.developercapes.user.GroupManager;
import com.jadarstudios.developercapes.user.User;
import com.jadarstudios.developercapes.user.UserManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.BitSet;
import java.util.Map;

public enum CapeConfigManager {
    INSTANCE;

    protected static BitSet availableIds;
    protected HashBiMap<Integer, CapeConfig> configs = HashBiMap.create();

    public void addConfig(int id, CapeConfig config) {
        int realId = CapeConfigManager.claimId(id);
        this.configs.put((Object)id, (Object)config);
        try {
            for (User u : config.users.values()) {
                UserManager.INSTANCE.addUser(u);
            }
            for (Group g : config.groups.values()) {
                GroupManager.INSTANCE.addGroup(g);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CapeConfig getConfig(int id) {
        return (CapeConfig)this.configs.get((Object)id);
    }

    public int getIdForConfig(CapeConfig config) {
        return (Integer)this.configs.inverse().get((Object)config);
    }

    public static int getUniqueId() {
        return availableIds.nextClearBit(0);
    }

    public static int claimId(int id) {
        try {
            UnsignedBytes.checkedCast((long)id);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        boolean isRegistered = availableIds.get(id);
        if (isRegistered) {
            DevCapes.logger.error(String.format("The config ID %d was attempted to be claimed but is already claimed.", id));
        }
        availableIds.set(id);
        return id;
    }

    public CapeConfig parse(String config) {
        CapeConfig instance = new CapeConfig();
        try {
            Map entries = (Map)new Gson().fromJson(config, Map.class);
            for (Map.Entry entry : entries.entrySet()) {
                User u;
                String nodeName = (String)entry.getKey();
                Object obj = entry.getValue();
                if (obj instanceof Map) {
                    Map group = (Map)obj;
                    Group g = GroupManager.INSTANCE.parse(nodeName, group);
                    if (g == null) continue;
                    instance.groups.put(g.name, g);
                    continue;
                }
                if (!(obj instanceof String) || (u = UserManager.INSTANCE.parse(nodeName, obj)) == null) continue;
                instance.users.put(nodeName, u);
            }
        }
        catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CapeConfig parseFromStream(InputStream is) {
        if (is == null) {
            DevCapes.logger.error("Can't parse a null input stream!");
            return null;
        }
        CapeConfig instance = null;
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            String json = "";
            while (reader.ready()) {
                json = json + reader.readLine();
            }
            instance = INSTANCE.parse(json);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return instance;
    }

    static {
        availableIds = new BitSet(256);
        availableIds.clear(availableIds.size());
    }
}

