/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.tool;

import codechicken.lib.asm.ASMHelper;
import java.util.Iterator;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingMethodAdapter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class MCStripTransformer {
    public static byte[] transform(byte[] bytes) {
        ClassNode cnode = ASMHelper.createClassNode(bytes, 8);
        boolean changed = false;
        Iterator it = cnode.methods.iterator();
        while (it.hasNext()) {
            MethodNode mnode = (MethodNode)it.next();
            ReferenceDetector r = new ReferenceDetector();
            mnode.accept((MethodVisitor)new RemappingMethodAdapter(mnode.access, mnode.desc, new MethodVisitor(262144){}, (Remapper)r));
            if (!r.found) continue;
            it.remove();
            changed = true;
        }
        if (changed) {
            bytes = ASMHelper.createBytes(cnode, 0);
        }
        return bytes;
    }

    public static class ReferenceDetector
    extends Remapper {
        boolean found = false;

        public String map(String typeName) {
            if (typeName.startsWith("net/minecraft") || !typeName.contains("/")) {
                this.found = true;
            }
            return typeName;
        }
    }
}

