/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation;

import cofh.core.CoFHProps;
import cofh.core.util.ConfigHandler;
import cofh.core.util.CoreUtils;
import cofh.mod.BaseMod;
import cofh.mod.updater.IUpdatableMod;
import cofh.mod.updater.UpdateManager;
import cofh.thermalfoundation.block.TFBlocks;
import cofh.thermalfoundation.core.Proxy;
import cofh.thermalfoundation.core.TFProps;
import cofh.thermalfoundation.fluid.TFFluids;
import cofh.thermalfoundation.gui.GuiHandler;
import cofh.thermalfoundation.gui.TFCreativeTab;
import cofh.thermalfoundation.item.Equipment;
import cofh.thermalfoundation.item.TFItems;
import cofh.thermalfoundation.network.PacketTFBase;
import cofh.thermalfoundation.plugins.TFPlugins;
import cofh.thermalfoundation.util.EventHandlerLexicon;
import cofh.thermalfoundation.util.LexiconManager;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.io.File;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="ThermalFoundation", name="Thermal Foundation", version="1.7.10R1.2.0", dependencies="required-after:CoFHCore@[1.7.10R3.0.3,)", guiFactory="cofh.thermalfoundation.gui.GuiConfigTFFactory", canBeDeactivated=false, customProperties={@Mod.CustomProperty(k="cofhversion", v="true")})
public class ThermalFoundation
extends BaseMod {
    public static final String modId = "ThermalFoundation";
    public static final String modName = "Thermal Foundation";
    public static final String version = "1.7.10R1.2.0";
    public static final String dependencies = "required-after:CoFHCore@[1.7.10R3.0.3,)";
    public static final String releaseURL = "https://raw.github.com/CoFH/Version/master/ThermalFoundation";
    public static final String modGuiFactory = "cofh.thermalfoundation.gui.GuiConfigTFFactory";
    @Mod.Instance(value="ThermalFoundation")
    public static ThermalFoundation instance;
    @SidedProxy(clientSide="cofh.thermalfoundation.core.ProxyClient", serverSide="cofh.thermalfoundation.core.Proxy")
    public static Proxy proxy;
    public static final Logger log;
    public static final ConfigHandler config;
    public static final ConfigHandler configClient;
    public static final GuiHandler guiHandler;
    public static CreativeTabs tabCommon;
    public static CreativeTabs tabTools;
    public static CreativeTabs tabArmor;
    public static File worldGenOres;
    public static final String worldGenInternalOres = "assets/thermalfoundation/world/ThermalFoundation-Ores.json";

    public ThermalFoundation() {
        super(log);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent fMLPreInitializationEvent) {
        UpdateManager.registerUpdater((UpdateManager)new UpdateManager((IUpdatableMod)this, releaseURL, "http://teamcofh.com/downloads/"));
        config.setConfiguration(new Configuration(new File(CoFHProps.configDir, "/cofh/thermalfoundation/common.cfg"), true));
        configClient.setConfiguration(new Configuration(new File(CoFHProps.configDir, "cofh/thermalfoundation/client.cfg"), true));
        tabCommon = new TFCreativeTab();
        this.cleanConfig(true);
        this.configOptions();
        TFFluids.preInit();
        TFItems.preInit();
        TFBlocks.preInit();
        TFPlugins.preInit();
        LexiconManager.preInit();
    }

    @Mod.EventHandler
    public void initialize(FMLInitializationEvent fMLInitializationEvent) {
        TFFluids.initialize();
        TFItems.initialize();
        TFBlocks.initialize();
        TFPlugins.initialize();
        this.loadWorldGeneration();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)guiHandler);
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        EventHandlerLexicon.initialize();
        PacketTFBase.initialize();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent fMLPostInitializationEvent) {
        TFFluids.postInit();
        TFItems.postInit();
        TFBlocks.postInit();
        TFPlugins.postInit();
        proxy.registerEntities();
        proxy.registerRenderInformation();
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent fMLLoadCompleteEvent) {
        LexiconManager.loadComplete();
        TFPlugins.loadComplete();
        this.cleanConfig(false);
        config.cleanUp(false, true);
        configClient.cleanUp(false, true);
        log.info("Load Complete.");
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent fMLServerStartingEvent) {
        TFFluids.registerDispenserHandlers();
    }

    void configOptions() {
        TFProps.iconBlazePowder = configClient.get("Icons", "BlazePowder", TFProps.iconBlazePowder, "Set to FALSE to revert Blaze Powder to the default Minecraft icon.");
        TFProps.renderStarfieldCage = configClient.get("Render", "CageyEnder", TFProps.renderStarfieldCage, "Set to TRUE for Ender devices to be a bit more Cagey year-round.");
        String string = "Holiday";
        String string2 = "Set this to TRUE to disable April Foolishness.";
        TFProps.holidayAprilFools = !config.get(string, "IHateApril", false, string2);
        string = "Interface.CreativeTab";
        boolean bl = false;
        boolean bl2 = false;
        string2 = "Set to TRUE to put Thermal Foundation Armor under the general \"Thermal Foundation\" Creative Tab.";
        bl = configClient.get(string, "ArmorInCommonTab", bl);
        string2 = "Set to TRUE to put Thermal Foundation Tools under the general \"Thermal Foundation\" Creative Tab.";
        bl2 = configClient.get(string, "ToolsInCommonTab", bl2);
        string = "Equipment";
        string2 = "Set to TRUE to disable ALL armor sets.";
        TFProps.disableAllArmor = config.get(string, "DisableAllArmor", TFProps.disableAllArmor, string2);
        string2 = "Set to TRUE to disable ALL tool sets.";
        TFProps.disableAllTools = config.get(string, "DisableAllTools", TFProps.disableAllTools, string2);
        string2 = "Set to FALSE to hide all disabled equipment from the Creative Tabs and NEI.";
        TFProps.showDisabledEquipment = config.get(string, "ShowDisabledEquipment", TFProps.showDisabledEquipment, string2);
        if (bl) {
            tabArmor = tabCommon;
        } else if (!TFProps.disableAllArmor || TFProps.disableAllArmor && TFProps.showDisabledEquipment) {
            tabArmor = new TFCreativeTab("Armor"){

                @Override
                protected ItemStack getStack() {
                    return Equipment.Invar.armorPlate;
                }
            };
        }
        if (bl2) {
            tabTools = tabCommon;
        } else if (!TFProps.disableAllTools || TFProps.disableAllTools && TFProps.showDisabledEquipment) {
            tabTools = new TFCreativeTab("Tools"){

                @Override
                protected ItemStack getStack() {
                    return Equipment.Invar.toolPickaxe;
                }
            };
        }
    }

    void cleanConfig(boolean bl) {
        int n;
        if (bl) {
            // empty if block
        }
        String string = "config.thermalfoundation.";
        String[] stringArray = config.getCategoryNames().toArray(new String[config.getCategoryNames().size()]);
        for (n = 0; n < stringArray.length; ++n) {
            config.getCategory(stringArray[n]).setLanguageKey(string + stringArray[n]).setRequiresMcRestart(true);
        }
        stringArray = configClient.getCategoryNames().toArray(new String[configClient.getCategoryNames().size()]);
        for (n = 0; n < stringArray.length; ++n) {
            configClient.getCategory(stringArray[n]).setLanguageKey(string + stringArray[n]).setRequiresMcRestart(true);
        }
    }

    void loadWorldGeneration() {
        if (!config.get("World", "GenerateDefaultFiles", true, "If enabled, Thermal Foundation will create default world generation files - if it cannot find existing ones. Only disable this if you know what you are doing.")) {
            return;
        }
        worldGenOres = new File(CoFHProps.configDir, "/cofh/world/ThermalFoundation-Ores.json");
        boolean bl = false;
        File file = new File(CoFHProps.configDir, "/cofh/world/ThermalExpansion-Ores.json");
        if (file.exists() && file.renameTo(worldGenOres)) {
            log.warn("Thermal Foundation was unable to convert existing world generation! This is really bad - your files are probably write protected and you need to handle it now!");
            bl = true;
        }
        if (!worldGenOres.exists() && !bl) {
            try {
                worldGenOres.createNewFile();
                CoreUtils.copyFileUsingStream((String)worldGenInternalOres, (File)worldGenOres);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public String getModId() {
        return modId;
    }

    public String getModName() {
        return modName;
    }

    public String getModVersion() {
        return version;
    }

    static {
        log = LogManager.getLogger((String)modId);
        config = new ConfigHandler(version);
        configClient = new ConfigHandler(version);
        guiHandler = new GuiHandler();
        tabTools = CreativeTabs.field_78040_i;
        tabArmor = CreativeTabs.field_78037_j;
    }
}

