/*
 * Decompiled with CFR 0.152.
 */
package am2.utility;

import am2.api.blocks.IKeystoneLockable;
import am2.api.items.IKeystoneHelper;
import am2.items.ItemKeystone;
import am2.items.ItemRune;
import am2.items.ItemsCommonProxy;
import am2.playerextensions.ExtendedProperties;
import java.util.ArrayList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class KeystoneUtilities
implements IKeystoneHelper {
    public static final KeystoneUtilities instance = new KeystoneUtilities();

    public static boolean HandleKeystoneRecovery(EntityPlayer player, IKeystoneLockable lock) {
        if (ExtendedProperties.For((EntityLivingBase)player).isRecoveringKeystone) {
            if (instance.getKeyFromRunes(lock.getRunesInKey()) != 0L) {
                String combo = "";
                for (ItemStack rune : lock.getRunesInKey()) {
                    combo = rune == null ? combo + "empty " : combo + rune.func_82833_r() + " ";
                }
                player.func_145747_a((IChatComponent)new ChatComponentText(combo));
            } else {
                player.func_145747_a((IChatComponent)new ChatComponentText("No Key Present."));
            }
            ExtendedProperties.For((EntityLivingBase)player).isRecoveringKeystone = false;
            return true;
        }
        return false;
    }

    @Override
    public ArrayList<Long> GetKeysInInvenory(EntityLivingBase ent) {
        ArrayList<Long> toReturn = new ArrayList<Long>();
        toReturn.add(0L);
        if (ent instanceof EntityPlayer) {
            EntityPlayer p = (EntityPlayer)ent;
            for (ItemStack is : p.field_71071_by.field_70462_a) {
                ItemKeystone keystone;
                long key;
                if (is == null || !(is.func_77973_b() instanceof ItemKeystone) || toReturn.contains(key = (keystone = (ItemKeystone)is.func_77973_b()).getKey(is))) continue;
                toReturn.add(key);
            }
        }
        return toReturn;
    }

    @Override
    public long getKeyFromRunes(ItemStack[] runes) {
        long key = 0L;
        int index = 0;
        for (ItemStack stack : runes) {
            if (stack == null || stack.func_77973_b() != ItemsCommonProxy.rune) continue;
            long keyIndex = ((ItemRune)stack.func_77973_b()).getKeyIndex(stack);
            key |= keyIndex << index * 16;
            ++index;
        }
        return key;
    }

    @Override
    public boolean canPlayerAccess(IKeystoneLockable inventory, EntityPlayer player) {
        ItemStack[] runes = inventory.getRunesInKey();
        long key = this.getKeyFromRunes(runes);
        if (key == 0L) {
            return true;
        }
        if (inventory.keystoneMustBeHeld()) {
            if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() == ItemsCommonProxy.keystone) {
                return ((ItemKeystone)player.func_71045_bC().func_77973_b()).getKey(player.func_71045_bC()) == key;
            }
        } else if (inventory.keystoneMustBeInActionBar()) {
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack == null || stack.func_77973_b() != ItemsCommonProxy.keystone || ((ItemKeystone)stack.func_77973_b()).getKey(stack) != key) continue;
                return true;
            }
        } else {
            for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack == null || stack.func_77973_b() != ItemsCommonProxy.keystone || ((ItemKeystone)stack.func_77973_b()).getKey(stack) != key) continue;
                return true;
            }
        }
        return false;
    }
}

