/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.shapes;

import am2.api.spell.ItemSpellBase;
import am2.api.spell.component.interfaces.ISpellShape;
import am2.api.spell.enums.Affinity;
import am2.api.spell.enums.SpellCastResult;
import am2.api.spell.enums.SpellModifiers;
import am2.blocks.BlocksCommonProxy;
import am2.entities.EntitySpellEffect;
import am2.items.ItemsCommonProxy;
import am2.spell.SpellUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class Zone
implements ISpellShape {
    @Override
    public int getID() {
        return 10;
    }

    @Override
    public SpellCastResult beginStackStage(ItemSpellBase item, ItemStack stack, EntityLivingBase caster, EntityLivingBase target, World world, double x, double y, double z, int side, boolean giveXP, int useCount) {
        if (world.field_72995_K) {
            return SpellCastResult.SUCCESS;
        }
        int radius = SpellUtils.instance.getModifiedInt_Add(2, stack, caster, (Entity)target, world, 0, SpellModifiers.RADIUS);
        double gravity = SpellUtils.instance.getModifiedDouble_Add(0.0, stack, caster, (Entity)target, world, 0, SpellModifiers.GRAVITY);
        int duration = SpellUtils.instance.getModifiedInt_Mul(100, stack, caster, (Entity)target, world, 0, SpellModifiers.DURATION);
        EntitySpellEffect zone = new EntitySpellEffect(world);
        zone.setRadius(radius);
        zone.setTicksToExist(duration);
        zone.setGravity(gravity);
        zone.SetCasterAndStack(caster, SpellUtils.instance.popStackStage(stack));
        zone.func_70107_b(x, y, z);
        world.func_72838_d((Entity)zone);
        return SpellCastResult.SUCCESS;
    }

    @Override
    public boolean isChanneled() {
        return false;
    }

    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[4];
        objectArray[0] = BlocksCommonProxy.tarmaRoot;
        objectArray[1] = new ItemStack((Item)ItemsCommonProxy.itemOre, 1, 7);
        objectArray[2] = new ItemStack((Item)ItemsCommonProxy.itemOre, 1, 6);
        objectArray[3] = Items.field_151045_i;
        return objectArray;
    }

    @Override
    public float manaCostMultiplier(ItemStack spellStack) {
        return 4.5f;
    }

    @Override
    public boolean isTerminusShape() {
        return false;
    }

    @Override
    public boolean isPrincipumShape() {
        return true;
    }

    @Override
    public String getSoundForAffinity(Affinity affinity, ItemStack stack, World world) {
        switch (affinity) {
            case AIR: {
                return "arsmagica2:spell.cast.air";
            }
            case ARCANE: {
                return "arsmagica2:spell.cast.arcane";
            }
            case EARTH: {
                return "arsmagica2:spell.cast.earth";
            }
            case ENDER: {
                return "arsmagica2:spell.cast.ender";
            }
            case FIRE: {
                return "arsmagica2:spell.cast.fire";
            }
            case ICE: {
                return "arsmagica2:spell.cast.ice";
            }
            case LIFE: {
                return "arsmagica2:spell.cast.life";
            }
            case LIGHTNING: {
                return "arsmagica2:spell.cast.lightning";
            }
            case NATURE: {
                return "arsmagica2:spell.cast.nature";
            }
            case WATER: {
                return "arsmagica2:spell.cast.water";
            }
        }
        return "arsmagica2:spell.cast.none";
    }
}

