/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.shapes;

import am2.api.spell.ItemSpellBase;
import am2.api.spell.component.interfaces.ISpellShape;
import am2.api.spell.enums.Affinity;
import am2.api.spell.enums.SpellCastResult;
import am2.api.spell.enums.SpellModifiers;
import am2.items.ItemsCommonProxy;
import am2.spell.SpellHelper;
import am2.spell.SpellUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class Touch
implements ISpellShape {
    @Override
    public int getID() {
        return 9;
    }

    @Override
    public SpellCastResult beginStackStage(ItemSpellBase item, ItemStack stack, EntityLivingBase caster, EntityLivingBase target, World world, double x, double y, double z, int side, boolean giveXP, int useCount) {
        if (target != null) {
            EntityLivingBase e = target;
            if (e instanceof EntityDragonPart && ((EntityDragonPart)e).field_70259_a instanceof EntityLivingBase) {
                e = (EntityLivingBase)((EntityDragonPart)e).field_70259_a;
            }
            SpellCastResult result = SpellHelper.instance.applyStageToEntity(stack, caster, world, (Entity)e, 0, giveXP);
            return result;
        }
        boolean targetWater = SpellUtils.instance.modifierIsPresent(SpellModifiers.TARGET_NONSOLID_BLOCKS, stack, 0);
        MovingObjectPosition mop = item.getMovingObjectPosition(caster, world, 2.5, true, targetWater);
        if (mop == null) {
            return SpellCastResult.EFFECT_FAILED;
        }
        if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
            SpellCastResult result;
            Entity e = mop.field_72308_g;
            if (e instanceof EntityDragonPart && ((EntityDragonPart)e).field_70259_a instanceof EntityLivingBase) {
                e = (EntityLivingBase)((EntityDragonPart)e).field_70259_a;
            }
            if ((result = SpellHelper.instance.applyStageToEntity(stack, caster, world, (Entity)(target == null ? e : target), 0, giveXP)) != SpellCastResult.SUCCESS) {
                return result;
            }
            ItemStack newItemStack = SpellUtils.instance.popStackStage(stack);
            return SpellHelper.instance.applyStackStage(newItemStack, caster, target, mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c, 0, world, true, giveXP, 0);
        }
        SpellCastResult result = SpellHelper.instance.applyStageToGround(stack, caster, world, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, mop.field_72310_e, mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c, 0, giveXP);
        if (result != SpellCastResult.SUCCESS) {
            return result;
        }
        ItemStack newItemStack = SpellUtils.instance.popStackStage(stack);
        return SpellHelper.instance.applyStackStage(newItemStack, caster, target, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, mop.field_72310_e, world, true, giveXP, 0);
    }

    @Override
    public boolean isChanneled() {
        return false;
    }

    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[4];
        objectArray[0] = new ItemStack((Item)ItemsCommonProxy.itemOre, 1, 0);
        objectArray[1] = Items.field_151008_G;
        objectArray[2] = Items.field_151115_aP;
        objectArray[3] = Items.field_151119_aD;
        return objectArray;
    }

    @Override
    public float manaCostMultiplier(ItemStack spellStack) {
        return 1.0f;
    }

    @Override
    public boolean isTerminusShape() {
        return false;
    }

    @Override
    public boolean isPrincipumShape() {
        return false;
    }

    @Override
    public String getSoundForAffinity(Affinity affinity, ItemStack stack, World world) {
        switch (affinity) {
            case AIR: {
                return "arsmagica2:spell.cast.air";
            }
            case ARCANE: {
                return "arsmagica2:spell.cast.arcane";
            }
            case EARTH: {
                return "arsmagica2:spell.cast.earth";
            }
            case ENDER: {
                return "arsmagica2:spell.cast.ender";
            }
            case FIRE: {
                return "arsmagica2:spell.cast.fire";
            }
            case ICE: {
                return "arsmagica2:spell.cast.ice";
            }
            case LIFE: {
                return "arsmagica2:spell.cast.life";
            }
            case LIGHTNING: {
                return "arsmagica2:spell.cast.lightning";
            }
            case NATURE: {
                return "arsmagica2:spell.cast.nature";
            }
            case WATER: {
                return "arsmagica2:spell.cast.water";
            }
        }
        return "arsmagica2:spell.cast.none";
    }
}

