/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.shapes;

import am2.AMCore;
import am2.api.power.PowerTypes;
import am2.api.spell.ItemSpellBase;
import am2.api.spell.component.interfaces.ISpellModifier;
import am2.api.spell.component.interfaces.ISpellShape;
import am2.api.spell.enums.Affinity;
import am2.api.spell.enums.SpellCastResult;
import am2.api.spell.enums.SpellModifiers;
import am2.blocks.BlocksCommonProxy;
import am2.items.ItemsCommonProxy;
import am2.particles.AMBeam;
import am2.particles.AMParticle;
import am2.particles.AMParticleIcons;
import am2.particles.ParticleMoveOnHeading;
import am2.spell.SpellHelper;
import am2.spell.SpellUtils;
import am2.spell.modifiers.Colour;
import am2.utility.MathUtilities;
import cpw.mods.fml.common.FMLLog;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class Beam
implements ISpellShape {
    private final HashMap beams = new HashMap();

    @Override
    public int getID() {
        return 1;
    }

    @Override
    public SpellCastResult beginStackStage(ItemSpellBase item, ItemStack stack, EntityLivingBase caster, EntityLivingBase target, World world, double x, double y, double z, int side, boolean giveXP, int useCount) {
        boolean shouldApplyEffect = useCount % 10 == 0;
        double range = SpellUtils.instance.getModifiedDouble_Add(SpellModifiers.RANGE, stack, caster, (Entity)target, world, 0);
        boolean targetWater = SpellUtils.instance.modifierIsPresent(SpellModifiers.TARGET_NONSOLID_BLOCKS, stack, 0);
        MovingObjectPosition mop = item.getMovingObjectPosition(caster, world, range, true, targetWater);
        SpellCastResult result = null;
        Vec3 beamHitVec = null;
        Vec3 spellVec = null;
        if (mop == null) {
            spellVec = beamHitVec = MathUtilities.extrapolateEntityLook(world, caster, range);
        } else if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
            if (shouldApplyEffect) {
                Entity e = mop.field_72308_g;
                if (e instanceof EntityDragonPart && ((EntityDragonPart)e).field_70259_a instanceof EntityLivingBase) {
                    e = (EntityLivingBase)((EntityDragonPart)e).field_70259_a;
                }
                if ((result = SpellHelper.instance.applyStageToEntity(stack, caster, world, e, 0, giveXP)) != SpellCastResult.SUCCESS) {
                    return result;
                }
            }
            float rng = (float)mop.field_72307_f.func_72438_d(Vec3.func_72443_a((double)caster.field_70165_t, (double)caster.field_70163_u, (double)caster.field_70161_v));
            spellVec = beamHitVec = MathUtilities.extrapolateEntityLook(world, caster, rng);
        } else {
            if (shouldApplyEffect) {
                FMLLog.info((String)"Beam applying to ground", (Object[])new Object[0]);
                result = SpellHelper.instance.applyStageToGround(stack, caster, world, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, mop.field_72310_e, mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c, 0, giveXP);
                if (result != SpellCastResult.SUCCESS) {
                    return result;
                }
            }
            beamHitVec = mop.field_72307_f;
            spellVec = Vec3.func_72443_a((double)mop.field_72311_b, (double)mop.field_72312_c, (double)mop.field_72309_d);
        }
        if (world.field_72995_K && beamHitVec != null) {
            AMBeam beam = (AMBeam)this.beams.get(caster.func_145782_y());
            double startX = caster.field_70165_t;
            double startY = caster.field_70163_u + (double)caster.func_70047_e() - (double)0.2f;
            double startZ = caster.field_70161_v;
            Affinity affinity = SpellUtils.instance.mainAffinityFor(stack);
            int color = -1;
            if (SpellUtils.instance.modifierIsPresent(SpellModifiers.COLOR, stack, 0)) {
                ISpellModifier[] mods = SpellUtils.instance.getModifiersForStage(stack, 0);
                int ordinalCount = 0;
                for (ISpellModifier mod : mods) {
                    if (!(mod instanceof Colour)) continue;
                    byte[] meta = SpellUtils.instance.getModifierMetadataFromStack(stack, mod, 0, ordinalCount++);
                    color = (int)mod.getModifier(SpellModifiers.COLOR, null, null, null, meta);
                }
            }
            if (beam != null) {
                if (beam.field_70128_L || beam.func_70068_e((Entity)caster) > 4.0) {
                    this.beams.remove(caster.func_145782_y());
                } else {
                    beam.setBeamLocationAndTarget(startX, startY, startZ, beamHitVec.field_72450_a, beamHitVec.field_72448_b, beamHitVec.field_72449_c);
                }
            } else if (affinity == Affinity.LIGHTNING) {
                AMCore.proxy.particleManager.BoltFromEntityToPoint(world, (Entity)caster, beamHitVec.field_72450_a, beamHitVec.field_72448_b, beamHitVec.field_72449_c, 1, color == -1 ? affinity.color : color);
            } else {
                beam = (AMBeam)AMCore.proxy.particleManager.BeamFromEntityToPoint(world, (Entity)caster, beamHitVec.field_72450_a, beamHitVec.field_72448_b, beamHitVec.field_72449_c, color == -1 ? affinity.color : color);
                if (beam != null) {
                    if (AMCore.proxy.getProxyUtils().isLocalPlayerInFirstPerson()) {
                        beam.setFirstPersonPlayerCast();
                    }
                    this.beams.put(caster.func_145782_y(), beam);
                }
            }
            for (int i = 0; i < AMCore.config.getGFXLevel() + 1; ++i) {
                AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(world, AMParticleIcons.instance.getParticleForAffinity(affinity), beamHitVec.field_72450_a, beamHitVec.field_72448_b, beamHitVec.field_72449_c));
                if (particle == null) continue;
                particle.setMaxAge(2);
                particle.setParticleScale(0.1f);
                particle.setIgnoreMaxAge(false);
                if (color != -1) {
                    particle.setRGBColorI(color);
                }
                particle.AddParticleController(new ParticleMoveOnHeading(particle, world.field_73012_v.nextDouble() * 360.0, world.field_73012_v.nextDouble() * 360.0, world.field_73012_v.nextDouble() * 0.2 + (double)0.02f, 1, false));
            }
        }
        if (result != null && spellVec != null && shouldApplyEffect) {
            ItemStack newItemStack = SpellUtils.instance.popStackStage(stack);
            return SpellHelper.instance.applyStackStage(newItemStack, caster, target, spellVec.field_72450_a, spellVec.field_72448_b, spellVec.field_72449_c, mop != null ? mop.field_72310_e : 0, world, true, giveXP, 0);
        }
        return SpellCastResult.SUCCESS_REDUCE_MANA;
    }

    @Override
    public boolean isChanneled() {
        return true;
    }

    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[7];
        objectArray[0] = ItemsCommonProxy.standardFocus;
        objectArray[1] = new ItemStack((Item)ItemsCommonProxy.itemOre, 1, 5);
        objectArray[2] = new ItemStack((Item)ItemsCommonProxy.itemOre, 1, 5);
        objectArray[3] = new ItemStack((Item)ItemsCommonProxy.itemOre, 1, 3);
        objectArray[4] = BlocksCommonProxy.aum;
        objectArray[5] = String.format("E:%d", PowerTypes.NEUTRAL.ID());
        objectArray[6] = 500;
        return objectArray;
    }

    @Override
    public float manaCostMultiplier(ItemStack spellStack) {
        return 0.1f;
    }

    @Override
    public boolean isTerminusShape() {
        return false;
    }

    @Override
    public boolean isPrincipumShape() {
        return false;
    }

    @Override
    public String getSoundForAffinity(Affinity affinity, ItemStack stack, World world) {
        switch (affinity) {
            case AIR: {
                return "arsmagica2:spell.loop.air";
            }
            case ARCANE: {
                return "arsmagica2:spell.loop.arcane";
            }
            case EARTH: {
                return "arsmagica2:spell.loop.earth";
            }
            case ENDER: {
                return "arsmagica2:spell.loop.ender";
            }
            case FIRE: {
                return "arsmagica2:spell.loop.fire";
            }
            case ICE: {
                return "arsmagica2:spell.loop.ice";
            }
            case LIFE: {
                return "arsmagica2:spell.loop.life";
            }
            case LIGHTNING: {
                return "arsmagica2:spell.loop.lightning";
            }
            case NATURE: {
                return "arsmagica2:spell.loop.nature";
            }
            case WATER: {
                return "arsmagica2:spell.loop.water";
            }
        }
        return "arsmagica2:spell.loop.none";
    }
}

