/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.modifiers;

import am2.api.spell.component.interfaces.ISpellModifier;
import am2.api.spell.enums.SpellModifiers;
import am2.items.ItemsCommonProxy;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class Lunar
implements ISpellModifier {
    @Override
    public int getID() {
        return 10;
    }

    @Override
    public EnumSet<SpellModifiers> getAspectsModified() {
        return EnumSet.of(SpellModifiers.RANGE, SpellModifiers.RADIUS, SpellModifiers.DAMAGE, SpellModifiers.DURATION, SpellModifiers.HEALING);
    }

    @Override
    public float getModifier(SpellModifiers type, EntityLivingBase caster, Entity target, World world, byte[] metadata) {
        switch (type) {
            case RANGE: {
                return this.modifyValueOnLunarCycle(world, 3.0f);
            }
            case RADIUS: {
                return this.modifyValueOnLunarCycle(world, 3.0f);
            }
            case DAMAGE: {
                return this.modifyValueOnTime(world, 2.4f);
            }
            case DURATION: {
                return this.modifyValueOnTime(world, 5.0f);
            }
            case HEALING: {
                return this.modifyValueOnTime(world, 2.0f);
            }
        }
        return 1.0f;
    }

    private float modifyValueOnTime(World world, float value) {
        long x = world.field_73011_w.getWorldTime() % 24000L;
        float multiplierFromTime = (float)(Math.sin((double)((float)x / 4600.0f * ((float)x / 21000.0f) - 900.0f) * 57.29577951308232) * 3.0) + 1.0f;
        if (multiplierFromTime < 0.0f) {
            multiplierFromTime *= -0.5f;
        }
        return value * multiplierFromTime;
    }

    private float modifyValueOnLunarCycle(World world, float value) {
        long boundedTime = world.field_73011_w.getWorldTime() % 24000L;
        int phase = 8 - world.field_73011_w.func_76559_b(world.func_72912_H().func_76073_f());
        if (boundedTime > 12500L && boundedTime < 23500L) {
            return value + (float)(phase / 2);
        }
        return Math.abs(value - 1.0f);
    }

    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[3];
        objectArray[0] = new ItemStack((Item)ItemsCommonProxy.essence, 1, 5);
        objectArray[1] = new ItemStack((Item)ItemsCommonProxy.itemOre, 1, 7);
        objectArray[2] = Items.field_151113_aN;
        return objectArray;
    }

    @Override
    public float getManaCostMultiplier(ItemStack spellStack, int stage, int quantity) {
        return 4.0f * (float)quantity;
    }

    @Override
    public byte[] getModifierMetadata(ItemStack[] matchedRecipe) {
        return null;
    }
}

