/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.components;

import am2.AMCore;
import am2.api.ArsMagicaApi;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.enums.Affinity;
import am2.items.ItemsCommonProxy;
import am2.particles.AMParticle;
import am2.utility.DummyEntityPlayer;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class Plant
implements ISpellComponent {
    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, int blockx, int blocky, int blockz, int blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        Block soil = world.func_147439_a(blockx, blocky, blockz);
        InventoryPlayer inventory = DummyEntityPlayer.fromEntityLiving((EntityLivingBase)caster).field_71071_by;
        HashMap<Integer, ItemStack> seeds = this.GetAllSeedsInInventory((IInventory)inventory);
        int currentSlot = 0;
        if (soil != Blocks.field_150350_a && seeds.size() > 0) {
            currentSlot = seeds.keySet().iterator().next();
            ItemStack seedStack = seeds.get(currentSlot);
            IPlantable seed = (IPlantable)seedStack.func_77973_b();
            if (soil != null && soil.canSustainPlant((IBlockAccess)world, blockx, blocky, blockz, ForgeDirection.UP, seed) && world.func_147437_c(blockx, blocky + 1, blockz)) {
                world.func_147449_b(blockx, blocky + 1, blockz, seed.getPlant((IBlockAccess)world, blockx, blocky, blockz));
                --seedStack.field_77994_a;
                if (seedStack.field_77994_a <= 0) {
                    inventory.func_70299_a(currentSlot, null);
                    seeds.remove(currentSlot);
                    if (seeds.size() == 0) {
                        return true;
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        return false;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 80.0f;
    }

    @Override
    public float burnout(EntityLivingBase caster) {
        return ArsMagicaApi.getBurnoutFromMana(this.manaCost(caster));
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        for (int i = 0; i < 15; ++i) {
            AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(world, "plant", x, y + 1.0, z));
            if (particle == null) continue;
            particle.addRandomOffset(1.0, 1.0, 1.0);
            particle.func_70024_g(rand.nextDouble() * 0.2 - 0.1, 0.2f, rand.nextDouble() * 0.2 - 0.1);
            particle.setDontRequireControllers();
            particle.setAffectedByGravity();
            particle.setMaxAge(20);
            particle.setParticleScale(0.1f);
            if (colorModifier <= -1) continue;
            particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
        }
    }

    @Override
    public EnumSet<Affinity> getAffinity() {
        return EnumSet.of(Affinity.NATURE);
    }

    private HashMap<Integer, ItemStack> GetAllSeedsInInventory(IInventory inventory) {
        HashMap<Integer, ItemStack> seeds = new HashMap<Integer, ItemStack>();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            Item item;
            ItemStack slotStack = inventory.func_70301_a(i);
            if (slotStack == null || !((item = slotStack.func_77973_b()) instanceof IPlantable)) continue;
            seeds.put(i, slotStack);
        }
        return seeds;
    }

    @Override
    public int getID() {
        return 41;
    }

    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[4];
        objectArray[0] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 6);
        objectArray[1] = Items.field_151014_N;
        objectArray[2] = new ItemStack(Blocks.field_150345_g, 1, Short.MAX_VALUE);
        objectArray[3] = Items.field_151014_N;
        return objectArray;
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.01f;
    }
}

