/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.components;

import am2.AMCore;
import am2.api.ArsMagicaApi;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.enums.Affinity;
import am2.items.ItemsCommonProxy;
import am2.particles.AMParticle;
import am2.particles.ParticleHoldPosition;
import am2.utility.EntityUtilities;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class Forge
implements ISpellComponent {
    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, int blockx, int blocky, int blockz, int blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        if (!this.CanApplyFurnaceToBlockAtCoords(caster, world, blockx, blocky, blockz)) {
            return false;
        }
        this.ApplyFurnaceToBlockAtCoords(caster, world, blockx, blocky, blockz);
        return true;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        if (target instanceof EntityVillager && AMCore.config.forgeSmeltsVillagers()) {
            if (!world.field_72995_K && !EntityUtilities.isSummon((EntityLivingBase)target)) {
                target.func_145779_a(Items.field_151166_bC, 1);
            }
            if (caster instanceof EntityPlayer) {
                target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)caster)), 5000.0f);
            } else {
                target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)caster), 5000.0f);
            }
            return true;
        }
        return false;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 55.0f;
    }

    @Override
    public float burnout(EntityLivingBase caster) {
        return ArsMagicaApi.getBurnoutFromMana(this.manaCost(caster));
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(world, "radiant", x + 0.5, y + 0.5, z + 0.5));
        if (particle != null) {
            particle.AddParticleController(new ParticleHoldPosition(particle, 20, 1, false));
            particle.setMaxAge(20);
            particle.setParticleScale(0.3f);
            particle.setRGBColorF(0.7f, 0.4f, 0.2f);
            particle.SetParticleAlpha(0.1f);
            if (colorModifier > -1) {
                particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
            }
        }
    }

    @Override
    public EnumSet<Affinity> getAffinity() {
        return EnumSet.of(Affinity.FIRE);
    }

    private boolean ApplyFurnaceToBlockAtCoords(EntityLivingBase entity, World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block == Blocks.field_150350_a) {
            return false;
        }
        if (block == Blocks.field_150432_aD) {
            if (!world.field_72995_K) {
                world.func_147449_b(x, y, z, Blocks.field_150355_j);
            }
            return true;
        }
        ItemStack smelted = FurnaceRecipes.func_77602_a().func_151395_a(new ItemStack(block));
        if (smelted == null) {
            return false;
        }
        if (!world.field_72995_K) {
            if (this.ItemIsBlock(smelted.func_77973_b())) {
                world.func_147449_b(x, y, z, ((ItemBlock)smelted.func_77973_b()).field_150939_a);
            } else {
                entity.func_70099_a(new ItemStack(smelted.func_77973_b(), 1, smelted.func_77960_j()), 0.0f);
                world.func_147449_b(x, y, z, Blocks.field_150350_a);
            }
        }
        return true;
    }

    private boolean CanApplyFurnaceToBlockAtCoords(EntityLivingBase entity, World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block == Blocks.field_150350_a) {
            return false;
        }
        if (block == Blocks.field_150432_aD) {
            return true;
        }
        ItemStack smelted = FurnaceRecipes.func_77602_a().func_151395_a(new ItemStack(block));
        return smelted != null;
    }

    public boolean ItemIsBlock(Item smelted) {
        return smelted instanceof ItemBlock;
    }

    @Override
    public int getID() {
        return 18;
    }

    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[2];
        objectArray[0] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 14);
        objectArray[1] = Blocks.field_150460_al;
        return objectArray;
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.01f;
    }
}

