/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.components;

import am2.AMCore;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.enums.Affinity;
import am2.items.ItemsCommonProxy;
import am2.particles.AMParticle;
import am2.particles.ParticleFadeOut;
import am2.particles.ParticleFloatUpward;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class Drought
implements ISpellComponent {
    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, int blockx, int blocky, int blockz, int blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        Block block = world.func_147439_a(blockx, blocky, blockz);
        if (block instanceof BlockFlower || block instanceof BlockTallGrass) {
            world.func_147465_d(blockx, blocky, blockz, (Block)Blocks.field_150329_H, 0, 2);
            return true;
        }
        if (block == Blocks.field_150349_c || block == Blocks.field_150391_bh || block == Blocks.field_150322_A || block == Blocks.field_150346_d) {
            world.func_147449_b(blockx, blocky, blockz, (Block)Blocks.field_150354_m);
            return true;
        }
        if (block == Blocks.field_150348_b) {
            world.func_147449_b(blockx, blocky, blockz, Blocks.field_150347_e);
            return true;
        }
        if (block == Blocks.field_150417_aV && world.func_72805_g(blockx, blocky, blockz) != 2) {
            world.func_72921_c(blockx, blocky, blockz, 2, 2);
            return true;
        }
        if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
            world.func_147449_b(blockx, blocky, blockz, Blocks.field_150350_a);
            return true;
        }
        switch (blockFace) {
            case 5: {
                ++blockx;
                break;
            }
            case 2: {
                --blockz;
                break;
            }
            case 3: {
                ++blockz;
                break;
            }
            case 4: {
                --blockx;
                break;
            }
            case 0: {
                --blocky;
                break;
            }
            case 1: {
                ++blocky;
            }
        }
        block = world.func_147439_a(blockx, blocky, blockz);
        if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
            world.func_147449_b(blockx, blocky, blockz, Blocks.field_150350_a);
            return true;
        }
        return false;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        return false;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 60.0f;
    }

    @Override
    public float burnout(EntityLivingBase caster) {
        return 10.0f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        for (int i = 0; i < 25; ++i) {
            AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(world, "ember", x + 0.5, y + 1.0, z + 0.5));
            if (particle == null) continue;
            particle.addRandomOffset(1.0, 0.0, 1.0);
            particle.AddParticleController(new ParticleFloatUpward(particle, 0.0f, 0.1f, 1, false));
            particle.AddParticleController(new ParticleFadeOut(particle, 1, false).setFadeSpeed(0.05f));
            particle.setAffectedByGravity();
            particle.setRGBColorF(0.9f, 0.8f, 0.5f);
            particle.setMaxAge(40);
            particle.setParticleScale(0.1f);
            if (colorModifier <= -1) continue;
            particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
        }
    }

    @Override
    public EnumSet<Affinity> getAffinity() {
        return EnumSet.of(Affinity.FIRE, Affinity.AIR);
    }

    @Override
    public int getID() {
        return 12;
    }

    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[3];
        objectArray[0] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 11);
        objectArray[1] = Blocks.field_150354_m;
        objectArray[2] = Blocks.field_150330_I;
        return objectArray;
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        if (affinity == Affinity.FIRE) {
            return 0.008f;
        }
        return 0.004f;
    }
}

