/*
 * Decompiled with CFR 0.152.
 */
package am2.particles.ribbon;

import am2.AMCore;
import am2.api.math.AMVector3;
import java.util.Random;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;

public class Quad3D {
    AMVector3 p0;
    AMVector3 p1;
    AMVector3 p2;
    AMVector3 p3;
    AMVector3 avg;
    private IIcon icon;
    private static final Random rand = new Random();
    AMVector3 normal;

    Quad3D(AMVector3 p0, AMVector3 p1, AMVector3 p2, AMVector3 p3, IIcon icon) {
        this.p0 = p0;
        this.p1 = p1;
        this.p2 = p2;
        this.p3 = p3;
        this.avg = new AMVector3((p0.x + p1.x + p2.x + p3.x) / 4.0f, (double)(p0.y + p1.y + p2.y + p3.y) / 4.0, (double)(p0.z + p1.z + p2.z + p3.z) / 4.0);
        this.icon = icon;
        this.calcNormal(p0, p1, p2);
    }

    void calcNormal(AMVector3 v1, AMVector3 v2, AMVector3 v3) {
        float Qx = v2.x - v1.x;
        float Qy = v2.y - v1.y;
        float Qz = v2.z - v1.z;
        float Px = v3.x - v1.x;
        float Py = v3.y - v1.y;
        float Pz = v3.z - v1.z;
        this.normal = new AMVector3(Py * Qz - Pz * Qy, Pz * Qx - Px * Qz, Px * Qy - Py * Qx);
    }

    void draw() {
        Tessellator t = Tessellator.field_78398_a;
        t.func_78382_b();
        t.func_78380_c(983280);
        t.func_78374_a((double)this.p0.x, (double)this.p0.y, (double)this.p0.z, (double)this.icon.func_94209_e(), (double)this.icon.func_94206_g());
        t.func_78374_a((double)this.p1.x, (double)this.p1.y, (double)this.p1.z, (double)this.icon.func_94212_f(), (double)this.icon.func_94206_g());
        t.func_78374_a((double)this.p2.x, (double)this.p2.y, (double)this.p2.z, (double)this.icon.func_94212_f(), (double)this.icon.func_94210_h());
        t.func_78374_a((double)this.p3.x, (double)this.p3.y, (double)this.p3.z, (double)this.icon.func_94209_e(), (double)this.icon.func_94210_h());
        t.func_78381_a();
        if (AMCore.config.FullGFX()) {
            double off = 0.005;
            t.func_78382_b();
            t.func_78380_c(983280);
            GL11.glColor4f((float)0.0f, (float)0.5f, (float)1.0f, (float)0.6f);
            t.func_78374_a((double)this.p0.x + off, (double)this.p0.y + off, (double)this.p0.z + off, (double)this.icon.func_94209_e(), (double)this.icon.func_94206_g());
            t.func_78374_a((double)this.p1.x + off, (double)this.p1.y + off, (double)this.p1.z + off, (double)this.icon.func_94212_f(), (double)this.icon.func_94206_g());
            t.func_78374_a((double)this.p2.x + off, (double)this.p2.y + off, (double)this.p2.z + off, (double)this.icon.func_94212_f(), (double)this.icon.func_94210_h());
            t.func_78374_a((double)this.p3.x + off, (double)this.p3.y + off, (double)this.p3.z + off, (double)this.icon.func_94209_e(), (double)this.icon.func_94210_h());
            t.func_78381_a();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.6f);
        }
        double mul = 0.0025;
        double halfMul = 0.00125;
        AMVector3 vecOffset = new AMVector3(rand.nextDouble() * mul - halfMul, rand.nextDouble() * mul - halfMul, rand.nextDouble() * mul - halfMul);
        this.p0.add(vecOffset);
        this.p1.add(vecOffset);
        this.p2.add(vecOffset);
        this.p3.add(vecOffset);
    }
}

