/*
 * Decompiled with CFR 0.152.
 */
package am2.particles;

import am2.AMCore;
import am2.api.particles.IBeamParticle;
import am2.particles.AMParticleIcons;
import am2.texture.ResourceManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class AMBeam
extends EntityFX
implements IBeamParticle {
    int type = 0;
    double dX;
    double dY;
    double dZ;
    double updateX;
    double updateY;
    double updateZ;
    private float yaw;
    private float pitch;
    private float prevYaw;
    private float prevPitch;
    private float rotateSpeed = 5.0f;
    private final double offset = 0.0;
    private float length;
    private final float endMod = 1.0f;
    private int maxLengthAge = 10;
    private boolean positionChanged = false;
    private static final ResourceLocation beam1 = new ResourceLocation("arsmagica2", ResourceManager.GetFXTexturePath("beam.png"));
    private static final ResourceLocation beam2 = new ResourceLocation("arsmagica2", ResourceManager.GetFXTexturePath("beam1.png"));
    private static final ResourceLocation beam3 = new ResourceLocation("arsmagica2", ResourceManager.GetFXTexturePath("beam2.png"));
    private static final ResourceLocation oldLoc = new ResourceLocation("textures/particle/particles.png");
    private boolean fppc = false;

    public AMBeam(World world, double x, double y, double z, double destX, double destY, double destZ) {
        this(world, x, y, z, destX, destY, destZ, 0);
    }

    public AMBeam(World world, double x, double y, double z, double destX, double destY, double destZ, int color) {
        super(world, x, y, z);
        this.dX = destX;
        this.dY = destY;
        this.dZ = destZ;
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.func_70105_a(0.2f, 0.2f);
        this.calculateLengthAndRotation();
        this.prevYaw = this.yaw;
        this.prevPitch = this.pitch;
        this.rotateSpeed = 30.0f;
        this.maxLengthAge = 10;
        this.field_70547_e = 10;
    }

    public AMBeam setInstantSpawn() {
        this.maxLengthAge = 1;
        return this;
    }

    public void setMaxAge(int maxAge) {
        this.field_70547_e = maxAge;
    }

    private void calculateLengthAndRotation() {
        float deltaX = (float)(this.field_70165_t - this.dX);
        float deltaY = (float)(this.field_70163_u - this.dY);
        float deltaZ = (float)(this.field_70161_v - this.dZ);
        this.length = MathHelper.func_76129_c((float)(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ));
        double hDist = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaZ * deltaZ));
        this.yaw = (float)(Math.atan2(deltaX, deltaZ) * 180.0 / Math.PI);
        this.pitch = (float)(Math.atan2(deltaY, hDist) * 180.0 / Math.PI);
    }

    public void setBeamLocationAndTarget(double posX, double posY, double posZ, double targetX, double targetY, double targetZ) {
        this.updateX = posX;
        this.updateY = posY;
        this.updateZ = posZ;
        this.dX = targetX;
        this.dY = targetY;
        this.dZ = targetZ;
        if (this.field_70546_d > this.field_70547_e - 5) {
            this.field_70547_e = this.field_70546_d + 5;
        }
        this.positionChanged = true;
    }

    private void storePrevInformation() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (this.positionChanged) {
            EntityClientPlayerMP player;
            this.field_70165_t = this.updateX;
            this.field_70163_u = this.updateY;
            this.field_70161_v = this.updateZ;
            if (this.fppc && (player = Minecraft.func_71410_x().field_71439_g) != null) {
                float yaw = player.field_70177_z;
                float rotationYaw = (float)((double)yaw * Math.PI / 180.0);
                float offsetX = (float)Math.cos(rotationYaw) * 0.06f;
                float offsetZ = (float)Math.sin(rotationYaw) * 0.06f;
                this.field_70165_t -= (double)offsetX;
                this.field_70161_v -= (double)offsetZ;
                this.field_70163_u += (double)0.06f;
                this.field_70169_q = this.field_70165_t;
                this.field_70167_r = this.field_70163_u;
                this.field_70166_s = this.field_70161_v;
            }
            this.positionChanged = false;
        }
        this.prevYaw = this.yaw;
        this.prevPitch = this.pitch;
    }

    @Override
    public void setFirstPersonPlayerCast() {
        this.fppc = true;
    }

    private void handleAging() {
        ++this.field_70546_d;
        if (this.field_70546_d >= this.field_70547_e) {
            this.func_70106_y();
        }
    }

    @Override
    public void setType(int type) {
        this.type = type;
    }

    public void func_70071_h_() {
        this.storePrevInformation();
        this.calculateLengthAndRotation();
        this.handleAging();
    }

    public int func_70537_b() {
        return 2;
    }

    public void func_70539_a(Tessellator tessellator, float par2, float par3, float par4, float par5, float par6, float par7) {
        tessellator.func_78381_a();
        GL11.glPushMatrix();
        float scaleFactor = 1.0f;
        float slide = this.field_70170_p.func_82737_E();
        float rot = (float)this.field_70170_p.field_73011_w.getWorldTime() % (360.0f / this.rotateSpeed) * this.rotateSpeed + this.rotateSpeed * par2;
        float size = (float)this.field_70546_d / (float)this.maxLengthAge;
        if (size > 1.0f) {
            size = 1.0f;
        }
        float op = 0.4f;
        float widthMod = 1.0f;
        IIcon beamIcon = null;
        switch (this.type) {
            default: {
                beamIcon = AMParticleIcons.instance.getHiddenIconByName("beam");
                break;
            }
            case 1: {
                beamIcon = AMParticleIcons.instance.getHiddenIconByName("beam1");
                break;
            }
            case 2: {
                beamIcon = AMParticleIcons.instance.getHiddenIconByName("beam2");
            }
        }
        GL11.glTexParameterf((int)3553, (int)10242, (float)10497.0f);
        GL11.glTexParameterf((int)3553, (int)10243, (float)10497.0f);
        float var11 = slide + par2;
        float var12 = -var11 * 0.2f - (float)MathHelper.func_76141_d((float)(-var11 * 0.1f));
        float xx = (float)(this.field_70169_q + (this.field_70165_t - this.field_70169_q) * (double)par2 - field_70556_an);
        float yy = (float)(this.field_70167_r + (this.field_70163_u - this.field_70167_r) * (double)par2 - field_70554_ao);
        float zz = (float)(this.field_70166_s + (this.field_70161_v - this.field_70166_s) * (double)par2 - field_70555_ap);
        GL11.glTranslated((double)xx, (double)yy, (double)zz);
        if (this.fppc) {
            widthMod = 0.3f;
        }
        float deltaYaw = Math.abs(this.yaw) - Math.abs(this.prevYaw);
        float ry = this.prevYaw + deltaYaw * par2;
        float rp = this.prevPitch + (this.pitch - this.prevPitch) * par2;
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(180.0f + ry), (float)0.0f, (float)0.0f, (float)-1.0f);
        GL11.glRotatef((float)rp, (float)1.0f, (float)0.0f, (float)0.0f);
        double offset1 = -0.15 * (double)widthMod * (double)size;
        double offset2 = 0.15 * (double)widthMod * (double)size;
        double d = -0.15 * (double)widthMod * (double)size;
        this.getClass();
        double offset3 = d * 1.0;
        double d2 = 0.15 * (double)widthMod * (double)size;
        this.getClass();
        double offset4 = d2 * 1.0;
        GL11.glRotatef((float)rot, (float)0.0f, (float)1.0f, (float)0.0f);
        int i = 5;
        float inc = 36.0f;
        if (AMCore.config.LowGFX()) {
            i = 3;
            inc = 90.0f;
        } else if (AMCore.config.NoGFX()) {
            i = 1;
            inc = 180.0f;
        }
        for (int t = 0; t < i; ++t) {
            double l = this.length * size * scaleFactor;
            double tl = beamIcon.func_94209_e();
            double br = beamIcon.func_94212_f();
            double mU = beamIcon.func_94206_g();
            double mV = beamIcon.func_94210_h();
            GL11.glRotatef((float)36.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            tessellator.func_78382_b();
            tessellator.func_78380_c(200);
            if (t % 2 == 0) {
                tessellator.func_78369_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, op);
            } else {
                tessellator.func_78369_a(1.0f, 1.0f, 1.0f, 0.4f);
            }
            tessellator.func_78374_a(offset3, l, 0.0, br, mV);
            tessellator.func_78374_a(offset1, 0.0, 0.0, br, mU);
            tessellator.func_78374_a(offset2, 0.0, 0.0, tl, mU);
            tessellator.func_78374_a(offset4, l, 0.0, tl, mV);
            tessellator.func_78381_a();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        tessellator.func_78382_b();
    }

    @Override
    public void setRGBColorF(float r, float g, float b) {
        this.field_70553_i = g;
        this.field_70552_h = r;
        this.field_70551_j = b;
    }

    @Override
    public void setRGBColor(int color) {
        this.field_70552_h = (float)(color >> 16 & 0xFF) / 255.0f;
        this.field_70553_i = (float)(color >> 8 & 0xFF) / 255.0f;
        this.field_70551_j = (float)(color & 0xFF) / 255.0f;
    }

    @Override
    public void setRGBColorI(int r, int g, int b) {
        this.field_70552_h = (float)r / 255.0f;
        this.field_70553_i = (float)g / 255.0f;
        this.field_70551_j = (float)b / 255.0f;
    }
}

