/*
 * Decompiled with CFR 0.152.
 */
package am2.network;

import am2.AMCore;
import am2.api.power.IPowerNode;
import am2.api.spell.component.interfaces.ISpellModifier;
import am2.api.spell.enums.SpellModifiers;
import am2.blocks.tileentities.TileEntityCalefactor;
import am2.blocks.tileentities.TileEntityCraftingAltar;
import am2.blocks.tileentities.TileEntityLectern;
import am2.blocks.tileentities.TileEntityObelisk;
import am2.bosses.BossActions;
import am2.bosses.IArsMagicaBoss;
import am2.buffs.BuffEffect;
import am2.buffs.BuffList;
import am2.containers.ContainerMagiciansWorkbench;
import am2.guis.AMGuiHelper;
import am2.guis.GuiHudCustomization;
import am2.lore.ArcaneCompendium;
import am2.network.AMDataReader;
import am2.network.AMDataWriter;
import am2.network.AMNetHandler;
import am2.network.AMPacketProcessorServer;
import am2.particles.AMParticle;
import am2.particles.ParticleChangeSize;
import am2.particles.ParticleFadeOut;
import am2.particles.ParticleLeaveParticleTrail;
import am2.particles.ParticleMoveOnHeading;
import am2.playerextensions.AffinityData;
import am2.playerextensions.ExtendedProperties;
import am2.playerextensions.SkillData;
import am2.power.PowerNodeEntry;
import am2.power.PowerNodeRegistry;
import am2.proxy.tick.ClientTickHandler;
import am2.spell.SkillTreeManager;
import am2.spell.SpellHelper;
import am2.spell.SpellUtils;
import am2.spell.modifiers.Colour;
import am2.utility.MathUtilities;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.server.FMLServerHandler;
import io.netty.buffer.ByteBufInputStream;
import java.io.File;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class AMPacketProcessorClient
extends AMPacketProcessorServer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SubscribeEvent
    public void onPacketData(FMLNetworkEvent.ClientCustomPacketEvent event) {
        ByteBufInputStream bbis = new ByteBufInputStream(event.packet.payload());
        int packetID = -1;
        try {
            if (event.packet.getTarget() != Side.CLIENT) {
                return;
            }
            packetID = bbis.readByte();
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            byte[] remaining = new byte[bbis.available()];
            bbis.readFully(remaining);
            switch (packetID) {
                case 2: {
                    this.handleSpellCast(remaining);
                    return;
                }
                case 3: {
                    this.handleMagicLevelUpResponse(remaining);
                    return;
                }
                case 5: {
                    AMCore.proxy.particleManager.handleClientPacketData((World)Minecraft.func_71410_x().field_71441_e, remaining);
                    return;
                }
                case 7: {
                    this.handleVelocityAdd(remaining);
                    return;
                }
                case 9: {
                    this.handleFlashArmor(remaining);
                    return;
                }
                case 13: {
                    this.handleRemoveBuffEffect(remaining);
                    return;
                }
                case 16: {
                    this.handleSyncProps(remaining);
                    return;
                }
                case 17: {
                    this.handleSyncBetaParticles(remaining);
                    return;
                }
                case 31: {
                    this.handleRequestBetaParticles(remaining);
                    return;
                }
                case 33: {
                    this.handleSyncAir(remaining);
                    return;
                }
                case 34: {
                    this.handleSyncAffinity(remaining);
                    return;
                }
                case 27: {
                    this.handleSyncSpellKnowledge(remaining);
                    return;
                }
                case 37: {
                    this.openUICustomization();
                    return;
                }
                case 38: {
                    this.handleEntityActionUpdate(remaining, (EntityPlayer)player);
                    return;
                }
                case 42: {
                    this.handlePlayerLoginData(remaining, (EntityPlayer)player);
                    return;
                }
                case 43: {
                    this.handleNBTDump((EntityPlayer)player);
                    return;
                }
                case 45: {
                    this.handleSetMagicicansWorkbenchRecipe((EntityPlayer)player);
                    return;
                }
                case 46: {
                    this.handleCompendiumUnlock(remaining);
                    return;
                }
                case 47: {
                    this.handleSyncWorldName(remaining);
                    return;
                }
                case 48: {
                    this.handleStarFall(remaining);
                    return;
                }
                case 49: {
                    Minecraft.func_71410_x().field_71458_u.func_146256_a(ArcaneCompendium.componentUnlock);
                    return;
                }
                case 44: {
                    this.handleSpellApplyEffect(remaining);
                    return;
                }
                case 50: {
                    this.handleHecateDeath(remaining);
                    return;
                }
                case 53: {
                    this.handleRcvPowerPaths(remaining);
                    return;
                }
                case 55: {
                    this.handleCapabilityChange(remaining);
                    return;
                }
                case 4: {
                    this.handleCraftingAltarData(remaining);
                    return;
                }
                case 56: {
                    this.handleLecternData(remaining);
                    return;
                }
                case 57: {
                    this.handleCalefactorData(remaining);
                    return;
                }
                case 58: {
                    this.handleObeliskData(remaining);
                    return;
                }
            }
            return;
        }
        catch (Throwable t) {
            FMLLog.severe((String)"Ars Magica >> Client Packet Failed to Handle!", (Object[])new Object[0]);
            FMLLog.severe((String)("Ars Magica >> Packet Type: " + packetID), (Object[])new Object[0]);
            t.printStackTrace();
            return;
        }
        finally {
            try {
                if (bbis != null) {
                    bbis.close();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private void handleObeliskData(byte[] remaining) {
        AMDataReader rdr = new AMDataReader(remaining, false);
        TileEntity te = Minecraft.func_71410_x().field_71441_e.func_147438_o(rdr.getInt(), rdr.getInt(), rdr.getInt());
        if (te == null || !(te instanceof TileEntityObelisk)) {
            return;
        }
        ((TileEntityObelisk)te).handlePacket(rdr.getRemainingBytes());
    }

    private void handleCalefactorData(byte[] remaining) {
        AMDataReader rdr = new AMDataReader(remaining, false);
        TileEntity te = Minecraft.func_71410_x().field_71441_e.func_147438_o(rdr.getInt(), rdr.getInt(), rdr.getInt());
        if (te == null || !(te instanceof TileEntityCalefactor)) {
            return;
        }
        ((TileEntityCalefactor)te).handlePacket(rdr.getRemainingBytes());
    }

    private void handleLecternData(byte[] data) {
        AMDataReader rdr = new AMDataReader(data, false);
        TileEntity te = Minecraft.func_71410_x().field_71441_e.func_147438_o(rdr.getInt(), rdr.getInt(), rdr.getInt());
        if (te == null || !(te instanceof TileEntityLectern)) {
            return;
        }
        if (rdr.getBoolean()) {
            ((TileEntityLectern)te).setStack(rdr.getItemStack());
        } else {
            ((TileEntityLectern)te).setStack(null);
        }
    }

    private void handleCraftingAltarData(byte[] data) {
        AMDataReader rdr = new AMDataReader(data, false);
        TileEntity te = Minecraft.func_71410_x().field_71441_e.func_147438_o(rdr.getInt(), rdr.getInt(), rdr.getInt());
        if (te == null || !(te instanceof TileEntityCraftingAltar)) {
            return;
        }
        ((TileEntityCraftingAltar)te).HandleUpdatePacket(rdr.getRemainingBytes());
    }

    private void handleCapabilityChange(byte[] data) {
        AMDataReader rdr = new AMDataReader(data, false);
        int capability = rdr.getInt();
        boolean flag = rdr.getBoolean();
        switch (capability) {
            case 1: {
                Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75101_c = flag;
                break;
            }
            case 2: {
                Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75100_b = flag;
            }
        }
    }

    private void handleRcvPowerPaths(byte[] data) {
        AMDataReader rdr = new AMDataReader(data, false);
        byte bite = rdr.getByte();
        NBTTagCompound compound = rdr.getNBTTagCompound();
        if (bite == 0) {
            PowerNodeEntry pnd = PowerNodeRegistry.For((World)Minecraft.func_71410_x().field_71441_e).parseFromNBT(compound);
            AMCore.proxy.receivePowerPathVisuals(pnd.getNodePaths());
        } else if (bite == 1) {
            int x = rdr.getInt();
            int y = rdr.getInt();
            int z = rdr.getInt();
            AMCore.proxy.setTrackedPowerCompound((NBTTagCompound)compound.func_74737_b());
            TileEntity te = Minecraft.func_71410_x().field_71441_e.func_147438_o(x, y, z);
            if (te != null && te instanceof IPowerNode) {
                PowerNodeRegistry.For((World)Minecraft.func_71410_x().field_71441_e).setDataCompoundForNode((IPowerNode)te, compound);
            }
        }
    }

    private void handleHecateDeath(byte[] data) {
        AMDataReader rdr = new AMDataReader(data, false);
        double x = rdr.getDouble();
        double y = rdr.getDouble();
        double z = rdr.getDouble();
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        for (int i = 0; i < 10 * AMCore.config.getGFXLevel(); ++i) {
            world.func_72869_a("flame", x, y + 1.0, z, world.field_73012_v.nextDouble() - 0.5, world.field_73012_v.nextDouble() - 0.5, world.field_73012_v.nextDouble() - 0.5);
        }
    }

    private void handleSpellApplyEffect(byte[] data) {
        ItemStack spellStack;
        AMDataReader rdr = new AMDataReader(data, false);
        double x = rdr.getDouble();
        double y = rdr.getDouble();
        double z = rdr.getDouble();
        ItemStack itemStack = spellStack = rdr.getBoolean() ? rdr.getItemStack() : null;
        if (spellStack == null) {
            return;
        }
        int casterID = rdr.getInt();
        int targetID = rdr.getInt();
        Entity caster = Minecraft.func_71410_x().field_71441_e.func_73045_a(casterID);
        Entity target = Minecraft.func_71410_x().field_71441_e.func_73045_a(targetID);
        if (caster == null || target == null || !(caster instanceof EntityLivingBase) || !(target instanceof EntityLivingBase)) {
            return;
        }
        SpellHelper.instance.applyStackStage(spellStack, (EntityLivingBase)caster, (EntityLivingBase)target, x, y, z, 0, (World)Minecraft.func_71410_x().field_71441_e, false, false, 0);
    }

    private void handleStarFall(byte[] data) {
        AMDataReader rdr = new AMDataReader(data, false);
        double x = rdr.getDouble();
        double y = rdr.getDouble();
        double z = rdr.getDouble();
        ItemStack spellStack = null;
        if (rdr.getBoolean()) {
            spellStack = rdr.getItemStack();
        }
        int color = -1;
        if (spellStack != null && SpellUtils.instance.modifierIsPresent(SpellModifiers.COLOR, spellStack, 0)) {
            ISpellModifier[] mods = SpellUtils.instance.getModifiersForStage(spellStack, 0);
            int ordinalCount = 0;
            for (ISpellModifier mod : mods) {
                if (!(mod instanceof Colour)) continue;
                byte[] meta = SpellUtils.instance.getModifierMetadataFromStack(spellStack, mod, 0, ordinalCount++);
                color = (int)mod.getModifier(SpellModifiers.COLOR, null, null, null, meta);
            }
        }
        for (int i = 0; i < 360; i += AMCore.config.FullGFX() ? 5 : (AMCore.config.LowGFX() ? 10 : 20)) {
            AMParticle effect = (AMParticle)((Object)AMCore.proxy.particleManager.spawn((World)Minecraft.func_71410_x().field_71441_e, "sparkle2", x, y + 1.5, z));
            if (effect == null) continue;
            effect.setIgnoreMaxAge(true);
            effect.AddParticleController(new ParticleMoveOnHeading(effect, i, 0.0, 0.7f, 1, false));
            float clrMod = Minecraft.func_71410_x().field_71441_e.field_73012_v.nextFloat();
            int finalColor = -1;
            if (color == -1) {
                finalColor = MathUtilities.colorFloatsToInt(0.24f * clrMod, 0.58f * clrMod, 0.71f * clrMod);
            } else {
                float[] colors = MathUtilities.colorIntToFloats(color);
                for (int c = 0; c < colors.length; ++c) {
                    colors[c] = colors[c] * clrMod;
                }
                finalColor = MathUtilities.colorFloatsToInt(colors[0], colors[1], colors[2]);
            }
            effect.setParticleScale(1.2f);
            effect.field_70145_X = false;
            effect.setRGBColorI(finalColor);
            effect.AddParticleController(new ParticleFadeOut(effect, 1, false).setFadeSpeed(0.05f).setKillParticleOnFinish(true));
            effect.AddParticleController(new ParticleLeaveParticleTrail(effect, "sparkle2", false, 15, 1, false).addControllerToParticleList(new ParticleChangeSize(effect, 1.2f, 0.01f, 15, 1, false)).setParticleRGB_I(finalColor).setChildAffectedByGravity().addRandomOffset(0.2f, 0.2f, 0.2f));
        }
        Minecraft.func_71410_x().field_71441_e.func_72980_b(x, y, z, "arsmagica2:spell.special.starfall", 2.0f, 1.0f, false);
    }

    private void handleSyncWorldName(byte[] data) {
        String worldName;
        AMDataReader rdr = new AMDataReader(data, false);
        ClientTickHandler.worldName = worldName = rdr.getString();
    }

    private void handleCompendiumUnlock(byte[] data) {
        AMDataReader rdr = new AMDataReader(data, false);
        String s = rdr.getString();
        boolean category = rdr.getBoolean();
        if (category) {
            ArcaneCompendium.instance.unlockCategory(s);
        } else {
            ArcaneCompendium.instance.unlockEntry(s);
        }
    }

    private void handleSetMagicicansWorkbenchRecipe(EntityPlayer player) {
        if (player.field_71070_bA != null && player.field_71070_bA instanceof ContainerMagiciansWorkbench) {
            ((ContainerMagiciansWorkbench)player.field_71070_bA).updateCraftingMatrices();
            ((ContainerMagiciansWorkbench)player.field_71070_bA).func_75130_a(((ContainerMagiciansWorkbench)player.field_71070_bA).getWorkbench());
        }
    }

    private void handleNBTDump(EntityPlayer player) {
        ItemStack stack = player.func_71045_bC();
        if (stack == null || !stack.func_77942_o()) {
            return;
        }
        NBTTagCompound compound = stack.func_77955_b(new NBTTagCompound());
        String fileName = "NBTDump_" + System.currentTimeMillis() + ".dat";
        File file = new File(fileName);
        try {
            CompressedStreamTools.func_74795_b((NBTTagCompound)compound, (File)file);
        }
        catch (IOException e) {
            e.printStackTrace();
            player.func_145747_a((IChatComponent)new ChatComponentText("An error occurred while attempting to write the NBT, check the console for more information."));
            return;
        }
        player.func_145747_a((IChatComponent)new ChatComponentText("NBT Saved to " + file.getAbsolutePath()));
    }

    private void handlePlayerLoginData(byte[] data, EntityPlayer player) {
        AMDataReader rdr = new AMDataReader(data, false);
        int skillTreeLock = rdr.getInt();
        AMCore.config.setSkillTreeSecondaryTierCap(skillTreeLock);
        int[] disabledSkills = rdr.getIntArray();
        double manaCap = rdr.getDouble();
        AMCore.config.setManaCap(manaCap);
        FMLLog.info((String)"Ars Magica 2 >> Received player login packet.", (Object[])new Object[0]);
        FMLLog.info((String)"Secondary tree cap: %d", (Object[])new Object[]{skillTreeLock});
        FMLLog.info((String)"Disabled skills: %d", (Object[])new Object[]{disabledSkills.length});
        FMLLog.info((String)"Mana cap: %.2f", (Object[])new Object[]{manaCap});
        SkillTreeManager.instance.disableAllSkillsIn(disabledSkills);
    }

    private void handleEntityActionUpdate(byte[] data, EntityPlayer player) {
        AMDataReader rdr = new AMDataReader(data, false);
        int entityID = rdr.getInt();
        int actionOrdinal = rdr.getInt();
        Entity ent = player.field_70170_p.func_73045_a(entityID);
        if (ent == null || ent.field_70128_L || !(ent instanceof IArsMagicaBoss)) {
            return;
        }
        ((IArsMagicaBoss)ent).setCurrentAction(BossActions.values()[actionOrdinal]);
    }

    private void openUICustomization() {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiHudCustomization());
    }

    private void handleSyncSpellKnowledge(byte[] data) {
        AMDataReader rdr = new AMDataReader(data, false);
        byte sub = rdr.getByte();
        int entityID = rdr.getInt();
        EntityLivingBase ent = AMCore.proxy.getEntityByID(entityID);
        if (ent == null || !(ent instanceof EntityPlayer)) {
            return;
        }
        if (!SkillData.For((EntityPlayer)ent).handlePacketData(data)) {
            FMLLog.severe((String)"Ars Magica >> Critical Error Handling Spell Knowledge Sync Packet!", (Object[])new Object[0]);
        }
    }

    private void handleSyncAffinity(byte[] data) {
        AMDataReader rdr = new AMDataReader(data, false);
        int entityID = rdr.getInt();
        EntityLivingBase ent = AMCore.proxy.getEntityByID(entityID);
        if (ent == null || !(ent instanceof EntityPlayer)) {
            return;
        }
        if (!AffinityData.For(ent).handlePacketData(data)) {
            FMLLog.severe((String)"Ars Magica >> Critical Error Handling Affinity Sync Packet!", (Object[])new Object[0]);
        }
    }

    private void handleSyncAir(byte[] data) {
        AMDataReader rdr = new AMDataReader(data, false);
        int entityID = rdr.getInt();
        int air = rdr.getInt();
        EntityLivingBase ent = AMCore.proxy.getEntityByID(entityID);
        if (ent == null) {
            return;
        }
        ent.func_70050_g(air);
    }

    private void handleRequestBetaParticles(byte[] data) {
        AMDataReader rdr = new AMDataReader(data, false);
        int entityID = rdr.getInt();
        byte[] expropData = rdr.getRemainingBytes();
        EntityLivingBase ent = AMCore.proxy.getEntityByID(entityID);
        if (ent == null) {
            return;
        }
        ExtendedProperties.For(ent).readAuraData(expropData);
    }

    private void handleKeystoneGuiOpen(byte[] data) {
        AMDataReader rdr = new AMDataReader(data, false);
        int x = rdr.getInt();
        int y = rdr.getInt();
        int z = rdr.getInt();
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        FMLNetworkHandler.openGui((EntityPlayer)player, (Object)AMCore.instance, (int)12, (World)Minecraft.func_71410_x().field_71441_e, (int)x, (int)y, (int)z);
    }

    private void handlePotionReplace(byte[] data) {
        AMDataReader rdr = new AMDataReader(data, false);
        int id = rdr.getInt();
        int duration = rdr.getInt();
        int amplifier = rdr.getInt();
        EntityClientPlayerMP localPlayer = Minecraft.func_71410_x().field_71439_g;
        BuffEffect pe = BuffList.buffEffectFromPotionID(id, duration, amplifier);
        if (pe != null) {
            localPlayer.func_82170_o(id);
            localPlayer.func_70690_d((PotionEffect)pe);
        }
    }

    private void handleSyncBetaParticles(byte[] data) {
        EntityClientPlayerMP localPlayer = Minecraft.func_71410_x().field_71439_g;
        if (!AMCore.proxy.playerTracker.hasAA((EntityPlayer)localPlayer)) {
            return;
        }
        ExtendedProperties e = ExtendedProperties.For((EntityLivingBase)localPlayer);
        AMDataWriter writer = new AMDataWriter();
        writer.add(e.getAuraIndex());
        writer.add(e.getAuraBehaviour());
        writer.add(e.getAuraScale());
        writer.add(e.getAuraAlpha());
        writer.add(e.getAuraColorRandomize());
        writer.add(e.getAuraColorDefault());
        writer.add(e.getAuraColor());
        writer.add(e.getAuraDelay());
        writer.add(e.getAuraQuantity());
        writer.add(e.getAuraSpeed());
        AMNetHandler.INSTANCE.sendPacketToServer((byte)17, writer.generate());
    }

    private void handleSyncProps(byte[] data) {
        AMDataReader rdr = new AMDataReader(data, false);
        int entityID = rdr.getInt();
        EntityLivingBase ent = AMCore.proxy.getEntityByID(entityID);
        if (ent == null) {
            return;
        }
        if (!ExtendedProperties.For(ent).handleDataPacket(data)) {
            FMLLog.severe((String)"Ars Magica >> Critical Error Handling Sync Packet!", (Object[])new Object[0]);
        }
    }

    private void handleRemoveBuffEffect(byte[] data) {
        AMDataReader rdr = new AMDataReader(data, false);
        int buffID = rdr.getInt();
        EntityClientPlayerMP localPlayer = Minecraft.func_71410_x().field_71439_g;
        if (buffID == BuffList.temporalAnchor.field_76415_H) {
            localPlayer.field_71080_cy = 1.0f;
            localPlayer.field_71086_bY = 1.0f;
        } else if (buffID == BuffList.flight.field_76415_H || buffID == BuffList.levitation.field_76415_H) {
            localPlayer.field_71075_bZ.field_75101_c = false;
            localPlayer.field_71075_bZ.field_75100_b = false;
            localPlayer.field_70143_R = 0.0f;
        }
        localPlayer.func_82170_o(buffID);
    }

    private void handleFlashArmor(byte[] data) {
        AMDataReader rdr = new AMDataReader(data, false);
        AMGuiHelper.instance.blackoutArmorPiece(rdr.getInt(), rdr.getInt());
    }

    private void handleVelocityAdd(byte[] data) {
        AMDataReader rdr = new AMDataReader(data, false);
        int entityID = rdr.getInt();
        double velX = rdr.getDouble();
        double velY = rdr.getDouble();
        double velZ = rdr.getDouble();
        EntityLivingBase ent = AMCore.proxy.getEntityByID(entityID);
        EntityClientPlayerMP localPlayer = Minecraft.func_71410_x().field_71439_g;
        if (ent.func_145782_y() != localPlayer.func_145782_y()) {
            return;
        }
        if (localPlayer.field_70181_x > 0.0) {
            return;
        }
        localPlayer.func_70024_g(velX, velY, velZ);
    }

    private void handleMagicLevelUpResponse(byte[] data) {
        AMDataReader rdr = new AMDataReader(data, false);
        boolean success = rdr.getBoolean();
        int newXPLevel = rdr.getInt();
        if (success) {
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            player.field_71068_ca = newXPLevel;
            ExtendedProperties.For((EntityLivingBase)player).setMagicLevelWithMana(ExtendedProperties.For((EntityLivingBase)player).getMagicLevel() + 1);
        }
    }

    private void handleSpellCast(byte[] data) {
        AMDataReader rdr = new AMDataReader(data, false);
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        ItemStack stack = rdr.getItemStack();
        int casterID = rdr.getInt();
        int targetID = -1;
        if (rdr.getBoolean()) {
            targetID = rdr.getInt();
        }
        double x = rdr.getDouble();
        double y = rdr.getDouble();
        double z = rdr.getDouble();
        int side = rdr.getInt();
        int ticksUsed = rdr.getInt();
        Entity caster = world.func_73045_a(casterID);
        if (caster == null || !(caster instanceof EntityLivingBase)) {
            return;
        }
        Entity target = null;
        if (!(targetID == -1 || (target = world.func_73045_a(targetID)) != null && target instanceof EntityLivingBase)) {
            return;
        }
        SpellHelper.instance.applyStackStage(stack, (EntityLivingBase)caster, (EntityLivingBase)target, x, y, z, side, (World)world, false, false, ticksUsed);
    }

    @Override
    public WorldServer[] getWorldServers() {
        return FMLServerHandler.instance().getServer().field_71305_c;
    }

    @Override
    public EntityLivingBase getEntityByID(int entityID) {
        return AMCore.proxy.getEntityByID(entityID);
    }
}

