/*
 * Decompiled with CFR 0.152.
 */
package am2.network;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class AMDataReader {
    ByteArrayInputStream input;
    DataInputStream dataStream;
    public byte ID;

    public AMDataReader(byte[] data) {
        this(data, true);
    }

    public AMDataReader(byte[] data, boolean getID) {
        this.input = new ByteArrayInputStream(data);
        this.dataStream = new DataInputStream(this.input);
        if (getID) {
            try {
                this.ID = this.dataStream.readByte();
            }
            catch (IOException e) {
                FMLLog.severe((String)("AMDataReader (getID): " + e.toString()), (Object[])new Object[0]);
                e.printStackTrace();
            }
        }
    }

    public int getInt() {
        int value = 0;
        try {
            value = this.dataStream.readInt();
        }
        catch (IOException e) {
            FMLLog.severe((String)("AMDataReader (getInt): " + e.toString()), (Object[])new Object[0]);
            e.printStackTrace();
        }
        return value;
    }

    public float getFloat() {
        float value = 0.0f;
        try {
            value = this.dataStream.readFloat();
        }
        catch (IOException e) {
            FMLLog.severe((String)("AMDataReader (getFloat): " + e.toString()), (Object[])new Object[0]);
            e.printStackTrace();
        }
        return value;
    }

    public double getDouble() {
        double value = 0.0;
        try {
            value = this.dataStream.readDouble();
        }
        catch (IOException e) {
            FMLLog.severe((String)("AMDataReader (getDouble): " + e.toString()), (Object[])new Object[0]);
            e.printStackTrace();
        }
        return value;
    }

    public boolean getBoolean() {
        boolean value = false;
        try {
            value = this.dataStream.readBoolean();
        }
        catch (IOException e) {
            FMLLog.severe((String)("AMDataReader (getBoolean): " + e.toString()), (Object[])new Object[0]);
            e.printStackTrace();
        }
        return value;
    }

    public String getString() {
        String value = "";
        try {
            value = this.dataStream.readUTF();
        }
        catch (IOException e) {
            FMLLog.severe((String)("AMDataReader (getString): " + e.toString()), (Object[])new Object[0]);
            e.printStackTrace();
        }
        return value;
    }

    public byte getByte() {
        byte value = 0;
        try {
            value = this.dataStream.readByte();
        }
        catch (IOException e) {
            FMLLog.severe((String)("AMDataReader (getByte): " + e.toString()), (Object[])new Object[0]);
            e.printStackTrace();
        }
        return value;
    }

    public short getShort() {
        short value = 0;
        try {
            value = this.dataStream.readShort();
        }
        catch (IOException e) {
            FMLLog.severe((String)("AMDataReader (getShort): " + e.toString()), (Object[])new Object[0]);
            e.printStackTrace();
        }
        return value;
    }

    public long getLong() {
        long value = 0L;
        try {
            value = this.dataStream.readLong();
        }
        catch (IOException e) {
            FMLLog.severe((String)("AMDataReader (getLong): " + e.toString()), (Object[])new Object[0]);
            e.printStackTrace();
        }
        return value;
    }

    public NBTTagCompound getNBTTagCompound() {
        NBTTagCompound data = null;
        try {
            int len = this.dataStream.readInt();
            byte[] bytes = new byte[len];
            this.dataStream.read(bytes);
            ByteBuf buf = Unpooled.copiedBuffer((byte[])bytes);
            data = ByteBufUtils.readTag((ByteBuf)buf);
        }
        catch (IOException e) {
            FMLLog.severe((String)("AMDataReader (getNBTTagCompound): " + e.toString()), (Object[])new Object[0]);
            e.printStackTrace();
        }
        return data;
    }

    public byte[] getRemainingBytes() {
        byte[] remaining = null;
        try {
            remaining = new byte[this.dataStream.available()];
            this.dataStream.read(remaining);
        }
        catch (IOException e) {
            FMLLog.severe((String)("AMDataReader (getRemainingBytes): " + e.toString()), (Object[])new Object[0]);
            e.printStackTrace();
        }
        return remaining;
    }

    public ItemStack getItemStack() {
        NBTTagCompound compound = this.getNBTTagCompound();
        if (compound == null) {
            return null;
        }
        ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)compound);
        return stack;
    }

    public int[] getIntArray() {
        try {
            int[] arr = new int[this.dataStream.readInt()];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = this.dataStream.readInt();
            }
            return arr;
        }
        catch (IOException e) {
            FMLLog.severe((String)("AMDataReader (getIntArray): " + e.toString()), (Object[])new Object[0]);
            e.printStackTrace();
            return new int[0];
        }
    }
}

