/*
 * Decompiled with CFR 0.152.
 */
package am2.guis;

import am2.AMCore;
import am2.api.SkillTreeEntry;
import am2.api.spell.component.interfaces.ISkillTreeEntry;
import am2.api.spell.enums.LearnStates;
import am2.guis.AMGuiHelper;
import am2.guis.AMGuiIcons;
import am2.guis.GuiArcaneCompendium;
import am2.guis.controls.GuiButtonCompendiumLink;
import am2.guis.controls.GuiButtonCompendiumNext;
import am2.guis.controls.GuiButtonCompendiumTab;
import am2.guis.controls.GuiSpellImageButton;
import am2.lore.ArcaneCompendium;
import am2.lore.CompendiumEntry;
import am2.lore.CompendiumEntrySpellComponent;
import am2.lore.CompendiumEntrySpellModifier;
import am2.lore.CompendiumEntrySpellShape;
import am2.lore.CompendiumEntryType;
import am2.playerextensions.SkillData;
import am2.spell.SkillManager;
import am2.spell.SkillTreeManager;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class GuiCompendiumIndex
extends GuiScreen
implements GuiYesNoCallback {
    private String activeCategory;
    private String activeCategoryID;
    private final LinkedHashSet<CompendiumEntryType> categories = ArcaneCompendium.instance.getCategories();
    private HashMap<String, Integer> pagingData;
    int xSize = 360;
    int ySize = 256;
    int page = 0;
    private CompendiumEntry currentParentEntry = null;
    private String currentParentEntryName = null;
    ArrayList<String> lines;
    int lineWidth = 140;
    int maxLines = 22;
    GuiButtonCompendiumNext nextPage;
    GuiButtonCompendiumNext prevPage;
    GuiButtonCompendiumTab backToIndex;
    GuiSpellImageButton updateButton;
    SkillData sk;
    private static final ResourceLocation background = new ResourceLocation("arsmagica2", "textures/guis/ArcaneCompendiumIndexGui.png");

    public GuiCompendiumIndex() {
        this.activeCategory = ((CompendiumEntryType)this.categories.iterator().next()).getCategoryLabel();
        this.activeCategoryID = ((CompendiumEntryType)this.categories.iterator().next()).getCategoryName();
        this.pagingData = new HashMap();
        this.lines = new ArrayList();
        this.sk = SkillData.For((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
    }

    public GuiCompendiumIndex(AMGuiHelper.CompendiumBreadcrumb breadcrumb) {
        this();
        this.page = breadcrumb.page;
        this.activeCategory = (String)breadcrumb.refData[0];
        this.activeCategoryID = (String)breadcrumb.refData[1];
        this.currentParentEntryName = (String)breadcrumb.refData[2];
        this.pagingData = (HashMap)breadcrumb.refData[3];
        if (this.currentParentEntryName != null) {
            this.currentParentEntry = ArcaneCompendium.instance.getEntry(this.currentParentEntryName);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int idCount = 0;
        idCount = this.initTabs(idCount);
        for (CompendiumEntryType category : this.categories) {
            idCount = this.initButtonsForCategory(category.getCategoryName(), idCount, category.equals(this.activeCategory));
        }
        int l = (this.field_146294_l - this.xSize) / 2;
        int i1 = (this.field_146295_m - this.ySize) / 2;
        this.nextPage = new GuiButtonCompendiumNext(idCount++, l + 320, i1 + 13, true);
        this.prevPage = new GuiButtonCompendiumNext(idCount++, l + 33, i1 + 13, false);
        this.backToIndex = new GuiButtonCompendiumTab(idCount++, l - 10, i1 + 20, StatCollector.func_74838_a((String)"am2.gui.back"), "back", null);
        this.backToIndex.setActive(true);
        this.backToIndex.field_146125_m = false;
        this.updateButton = new GuiSpellImageButton(idCount++, l - 5, i1 + 10, ArcaneCompendium.instance.isModUpdateAvailable() ? AMGuiIcons.warning : AMGuiIcons.checkmark, 0, 0);
        this.updateButton.setDimensions(10, 10);
        this.updateButton.setPopupText(ArcaneCompendium.instance.isModUpdateAvailable() ? StatCollector.func_74838_a((String)"am2.tooltip.updateAvailable") : StatCollector.func_74838_a((String)"am2.tooltip.upToDate"));
        this.field_146292_n.add(this.nextPage);
        this.field_146292_n.add(this.prevPage);
        this.field_146292_n.add(this.backToIndex);
        if (AMCore.config.allowVersionChecks()) {
            this.field_146292_n.add(this.updateButton);
        }
        this.switchCategoryAndPage();
        if (this.currentParentEntry != null && this.currentParentEntry.hasSubItems()) {
            for (Object btn : this.field_146292_n) {
                if (!(btn instanceof GuiButtonCompendiumTab)) continue;
                ((GuiButtonCompendiumTab)((Object)btn)).field_146125_m = false;
            }
            this.backToIndex.field_146125_m = true;
        }
        this.nextPage.field_146125_m = this.page < this.getNumPages();
        this.prevPage.field_146125_m = this.page > 0;
    }

    protected int getNumPages() {
        Integer pages = this.pagingData.get(this.activeCategoryID);
        return pages != null ? pages : 0;
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        for (int l = 0; l < this.field_146292_n.size(); ++l) {
            GuiButton guibutton = (GuiButton)this.field_146292_n.get(l);
            if (!guibutton.func_146116_c(Minecraft.func_71410_x(), par1, par2)) continue;
            if (guibutton.field_146127_k == this.updateButton.field_146127_k) {
                this.storeBreadcrumb();
                if (par3 == 0) {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiConfirmOpenLink((GuiYesNoCallback)this, ArcaneCompendium.instance.getModDownloadLink(), 0, false));
                } else if (par3 == 1) {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiConfirmOpenLink((GuiYesNoCallback)this, ArcaneCompendium.instance.getPatchNotesLink(), 1, false));
                }
            }
            if (par3 != 0) continue;
            this.func_146284_a(guibutton);
            return;
        }
    }

    public void func_73878_a(boolean par1, int par2) {
        if (par1) {
            switch (par2) {
                case 0: {
                    this.openLink(URI.create(ArcaneCompendium.instance.getModDownloadLink()));
                    break;
                }
                case 1: {
                    this.openLink(URI.create(ArcaneCompendium.instance.getPatchNotesLink()));
                }
            }
        }
        this.field_146297_k.func_147108_a((GuiScreen)this);
    }

    private void openLink(URI par1URI) {
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke((Object)null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, par1URI);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void storeBreadcrumb() {
        AMGuiHelper.instance.pushCompendiumBreadcrumb("", this.page, 0, this.activeCategory, this.activeCategoryID, this.currentParentEntryName, this.pagingData);
    }

    protected void func_146284_a(GuiButton buttonClicked) {
        if (buttonClicked.field_146127_k == this.backToIndex.field_146127_k) {
            AMGuiHelper.CompendiumBreadcrumb crumb = AMGuiHelper.instance.popCompendiumBreadcrumb();
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiCompendiumIndex(crumb));
            return;
        }
        if (buttonClicked instanceof GuiButtonCompendiumTab) {
            this.currentParentEntry = null;
            this.currentParentEntryName = null;
            this.activeCategory = ((GuiButtonCompendiumTab)buttonClicked).field_146126_j;
            this.activeCategoryID = ((GuiButtonCompendiumTab)buttonClicked).categoryID;
            int visibleButtons = 0;
            for (Object button : this.field_146292_n) {
                if (button instanceof GuiButtonCompendiumTab) {
                    ((GuiButtonCompendiumTab)((Object)button)).setActive(false);
                    continue;
                }
                if (!(button instanceof GuiButtonCompendiumLink)) continue;
                if (((GuiButtonCompendiumLink)((Object)button)).getCategory().equals(this.activeCategoryID) && ((GuiButtonCompendiumLink)((Object)button)).getPageNum() == 0) {
                    ((GuiButtonCompendiumLink)((Object)button)).field_146125_m = true;
                    ++visibleButtons;
                    continue;
                }
                ((GuiButtonCompendiumLink)((Object)button)).field_146125_m = false;
            }
            if (visibleButtons == 0) {
                String zeroItemText = ArcaneCompendium.instance.getZeroItemText(this.activeCategoryID);
                this.lines = GuiArcaneCompendium.splitStringToLines(this.field_146289_q, zeroItemText, this.lineWidth, this.maxLines);
            } else {
                this.lines = null;
            }
            ((GuiButtonCompendiumTab)buttonClicked).setActive(true);
            this.page = 0;
            this.prevPage.field_146125_m = false;
            this.nextPage.field_146125_m = this.getNumPages() > 0;
        } else if (buttonClicked instanceof GuiButtonCompendiumLink) {
            this.currentParentEntry = null;
            if (((GuiButtonCompendiumLink)buttonClicked).hasSubItems()) {
                this.storeBreadcrumb();
                for (Object btn : this.field_146292_n) {
                    if (!(btn instanceof GuiButtonCompendiumTab)) continue;
                    ((GuiButtonCompendiumTab)((Object)btn)).field_146125_m = false;
                }
                this.backToIndex.field_146125_m = true;
                this.currentParentEntryName = ((GuiButtonCompendiumLink)buttonClicked).getEntryID();
                this.currentParentEntry = ArcaneCompendium.instance.getEntry(this.currentParentEntryName);
                this.activeCategoryID = this.activeCategoryID + ":" + this.currentParentEntryName;
                this.currentParentEntry.setIsNew(false);
                this.switchCategoryAndPage();
            } else {
                CompendiumEntry entry = ArcaneCompendium.instance.getEntry(((GuiButtonCompendiumLink)buttonClicked).getEntryID());
                if (entry != null) {
                    this.storeBreadcrumb();
                    GuiArcaneCompendium gui = entry.getCompendiumGui(((GuiButtonCompendiumLink)buttonClicked).getEntryID());
                    if (gui != null) {
                        Minecraft.func_71410_x().func_147108_a((GuiScreen)gui);
                    }
                }
            }
        }
        if (this.getNumPages() > 0) {
            if (buttonClicked.field_146127_k == this.nextPage.field_146127_k && this.page < this.getNumPages()) {
                ++this.page;
                this.switchCategoryAndPage();
                if (this.page == this.getNumPages()) {
                    this.nextPage.field_146125_m = false;
                }
                this.prevPage.field_146125_m = true;
            } else if (buttonClicked.field_146127_k == this.prevPage.field_146127_k && this.page > 0) {
                --this.page;
                this.switchCategoryAndPage();
                if (this.page == 0) {
                    this.prevPage.field_146125_m = false;
                }
                this.nextPage.field_146125_m = true;
            }
        }
    }

    private void switchCategoryAndPage() {
        if (this.currentParentEntry != null) {
            this.lines = GuiArcaneCompendium.splitStringToLines(this.field_146289_q, this.currentParentEntry.getDescription(), this.lineWidth, this.maxLines);
            int numPages = this.currentParentEntry.hasSubItems() ? this.lines.size() : this.lines.size() - 1;
            Integer existingPages = this.pagingData.get(this.activeCategoryID);
            if (existingPages == null || existingPages < numPages) {
                this.pagingData.put(this.activeCategoryID, numPages);
                this.page = 0;
                this.prevPage.field_146125_m = false;
                if (numPages > 1) {
                    this.nextPage.field_146125_m = true;
                }
            }
        }
        for (Object button : this.field_146292_n) {
            if (button == this.backToIndex || !(button instanceof GuiButtonCompendiumLink)) continue;
            if (((GuiButtonCompendiumLink)((Object)button)).getCategory().equals(this.activeCategoryID) && (((GuiButtonCompendiumLink)((Object)button)).getPageNum() == this.page || ((GuiButtonCompendiumLink)((Object)button)).getDisplayOnAllPages())) {
                ((GuiButtonCompendiumLink)((Object)button)).field_146125_m = true;
                continue;
            }
            ((GuiButtonCompendiumLink)((Object)button)).field_146125_m = false;
        }
    }

    private void setCategoryHasNewItems(String category, boolean hasNew) {
        for (Object button : this.field_146292_n) {
            if (!(button instanceof GuiButtonCompendiumTab) || !((GuiButtonCompendiumTab)((Object)button)).categoryID.equals(category)) continue;
            ((GuiButtonCompendiumTab)((Object)button)).setHasNewSubitems(true);
            break;
        }
    }

    private int initTabs(int idCount) {
        int l = (this.field_146294_l - this.xSize) / 2;
        int i1 = (this.field_146295_m - this.ySize) / 2;
        int tabX = l + 10;
        int tabY = i1 + 40;
        int tabWidth = 1;
        int tabHeight = 16;
        for (CompendiumEntryType category : this.categories) {
            int unlockedSubItems = 0;
            ArrayList<CompendiumEntry> itemsInCategory = ArcaneCompendium.instance.getEntriesForCategory(category.getCategoryName());
            for (CompendiumEntry entry : itemsInCategory) {
                if (entry.isLocked()) continue;
                ++unlockedSubItems;
            }
            if (unlockedSubItems == 0) continue;
            GuiButtonCompendiumTab tab = new GuiButtonCompendiumTab(idCount++, tabX, tabY, category.getCategoryLabel(), category.getCategoryName(), category.getRepresentItem());
            if (this.activeCategory.equals(category)) {
                tab.setActive(true);
            }
            if (tabWidth < tab.getWidth()) {
                tabWidth = tab.getWidth();
            }
            tabY += 18;
            --tabX;
            this.field_146292_n.add(tab);
        }
        for (Object button : this.field_146292_n) {
            ((GuiButtonCompendiumTab)((Object)button)).setDimensions(tabWidth, tabHeight);
        }
        return idCount;
    }

    private int initButtonsForCategory(String category, int idCount, boolean display) {
        ArrayList<CompendiumEntry> itemsInCategory = ArcaneCompendium.instance.getEntriesForCategory(category);
        int l = (this.field_146294_l - this.xSize) / 2;
        int i1 = (this.field_146295_m - this.ySize) / 2;
        int buttonX = l + 40;
        int buttonY = i1 + 35;
        int numPages = 0;
        for (int i = 0; i < itemsInCategory.size(); ++i) {
            CompendiumEntry entry = itemsInCategory.get(i);
            if (entry.isLocked() || !this.checkSCMLimit(entry)) continue;
            String buttonLabel = entry.getName();
            while (this.field_146289_q.func_78256_a(buttonLabel) > 125) {
                buttonLabel = buttonLabel.substring(0, buttonLabel.length() - 4) + "...";
            }
            GuiButtonCompendiumLink link = new GuiButtonCompendiumLink(idCount++, buttonX, buttonY, this.field_146289_q, buttonLabel, entry.getID(), category, entry.hasSubItems(), numPages);
            if (entry.isNew()) {
                this.setCategoryHasNewItems(category, true);
                link.setNewItem();
            }
            boolean bl = link.field_146125_m = display && this.page == 0;
            if ((buttonY += 12) > i1 + this.ySize - 25) {
                if (buttonX > l + 40) {
                    ++numPages;
                    buttonX = l + 40;
                } else {
                    buttonX += 155;
                }
                buttonY = i1 + 30;
            }
            this.field_146292_n.add(link);
            if (!entry.hasSubItems()) continue;
            idCount = this.initSubItemButtonsForEntry(entry, idCount, category);
        }
        this.pagingData.put(category, numPages);
        return idCount;
    }

    private int initSubItemButtonsForEntry(CompendiumEntry entry, int idCount, String category) {
        int buttonXStart;
        int l = (this.field_146294_l - this.xSize) / 2;
        int i1 = (this.field_146295_m - this.ySize) / 2;
        boolean entryHasDescription = !entry.getDescription().equals("");
        int buttonX = buttonXStart = entryHasDescription ? l + 185 : l + 40;
        int buttonY = i1 + 35;
        int numPages = 0;
        for (CompendiumEntry subItem : entry.getSubItems()) {
            if (!this.checkSCMLimit(subItem)) continue;
            String newCategory = category + ":" + entry.getID();
            GuiButtonCompendiumLink link = new GuiButtonCompendiumLink(idCount++, buttonX, buttonY, this.field_146289_q, subItem.getName(), subItem.getID(), newCategory, subItem.hasSubItems(), numPages);
            if (entryHasDescription && entry.getSubItems().length < this.maxLines) {
                link.setShowOnAllPages();
            }
            link.field_146125_m = false;
            if ((buttonY += 12) > i1 + this.ySize - 25) {
                if (buttonX > l + 40) {
                    ++numPages;
                    buttonX = buttonXStart;
                } else {
                    buttonX += 145;
                }
                buttonY = i1 + 30;
            }
            this.field_146292_n.add(link);
            if (!subItem.hasSubItems()) continue;
            idCount = this.initSubItemButtonsForEntry(subItem, idCount, category);
        }
        this.pagingData.put(category, numPages);
        return idCount;
    }

    private boolean checkSCMLimit(CompendiumEntry entry) {
        if (entry instanceof CompendiumEntrySpellComponent || entry instanceof CompendiumEntrySpellModifier || entry instanceof CompendiumEntrySpellShape) {
            ISkillTreeEntry part = SkillManager.instance.getSkill(entry.getID());
            if (part == null) {
                return false;
            }
            SkillTreeEntry ste = SkillTreeManager.instance.getSkillTreeEntry(part);
            if (ste == null) {
                return false;
            }
            return this.sk.isEntryKnown(ste) || this.sk.getLearnState(ste, (EntityPlayer)Minecraft.func_71410_x().field_71439_g) == LearnStates.CAN_LEARN;
        }
        return true;
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_73869_a(char par1, int par2) {
        if (par2 == 1) {
            this.storeBreadcrumb();
            this.func_146281_b();
        }
        super.func_73869_a(par1, par2);
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.func_146276_q_();
        RenderHelper.func_74520_c();
        int l = (this.field_146294_l - this.xSize) / 2;
        int i1 = (this.field_146295_m - this.ySize) / 2;
        this.field_146297_k.field_71446_o.func_110577_a(background);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.drawTexturedModalRect_Classic(l, i1, 0, 0, this.xSize, this.ySize, 256, 240);
        String compendiumTitle = "\u00a7nArcane Compendium";
        int y_start_title = i1 + 20;
        int x_start_title = l + 100 - this.field_146289_q.func_78256_a(compendiumTitle) / 2;
        this.field_146289_q.func_78276_b(compendiumTitle, x_start_title, y_start_title, 0);
        int x_start_line = l + 35;
        int y_start_line = i1 + 35;
        if (this.lines != null && this.lines.size() > this.page) {
            AMGuiHelper.drawCompendiumText(this.lines.get(this.page), x_start_line, y_start_line, this.lineWidth, 0, this.field_146289_q);
        }
        super.func_73863_a(par1, par2, par3);
    }

    public void drawTexturedModalRect_Classic(int dst_x, int dst_y, int src_x, int src_y, int dst_width, int dst_height, int src_width, int src_height) {
        float var7 = 0.00390625f;
        float var8 = 0.00390625f;
        Tessellator var9 = Tessellator.field_78398_a;
        var9.func_78382_b();
        var9.func_78374_a((double)(dst_x + 0), (double)(dst_y + dst_height), (double)this.field_73735_i, (double)((float)(src_x + 0) * var7), (double)((float)(src_y + src_height) * var8));
        var9.func_78374_a((double)(dst_x + dst_width), (double)(dst_y + dst_height), (double)this.field_73735_i, (double)((float)(src_x + src_width) * var7), (double)((float)(src_y + src_height) * var8));
        var9.func_78374_a((double)(dst_x + dst_width), (double)(dst_y + 0), (double)this.field_73735_i, (double)((float)(src_x + src_width) * var7), (double)((float)(src_y + 0) * var8));
        var9.func_78374_a((double)(dst_x + 0), (double)(dst_y + 0), (double)this.field_73735_i, (double)((float)(src_x + 0) * var7), (double)((float)(src_y + 0) * var8));
        var9.func_78381_a();
    }

    public void func_146281_b() {
        ArcaneCompendium.instance.saveUnlockData();
        super.func_146281_b();
    }
}

