/*
 * Decompiled with CFR 0.152.
 */
package am2.guis;

import am2.buffs.BuffList;
import am2.guis.GuiArcaneCompendium;
import am2.guis.GuiCompendiumIndex;
import am2.playerextensions.ExtendedProperties;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

public class AMGuiHelper {
    private static final RenderBlocks renderBlocks = new RenderBlocks();
    protected static RenderItem itemRenderer = new RenderItem();
    public static final AMGuiHelper instance = new AMGuiHelper();
    private static final ResourceLocation rl_items = new ResourceLocation("textures/atlas/items.png");
    private long millis;
    private long lastmillis;
    private long accumulatedMillis;
    private static float zLevel = 300.0f;
    private static int fractalLineDetail = 2;
    public float slowFlashAlpha = 1.0f;
    public float fastFlashAlpha = 1.0f;
    private int flashCounter = 0;
    public final short flashDuration = (short)20;
    private int magicXPBarShowTimer = 0;
    private float magicXPBarAlpha = 0.0f;
    public float playerRunesAlpha = 0.0f;
    private final short[] flashTimers = new short[5];
    private final int[] blackoutTimers = new int[5];
    private final int[] blackoutTimersMax = new int[5];
    private int slowUITicker = 0;
    private static int fastUITicker = 0;
    public boolean runCompendiumTicker = true;
    private final LinkedList<CompendiumBreadcrumb> compendiumBreadcrumbs = new LinkedList();
    public EntityItem dummyItem;

    private AMGuiHelper() {
        Minecraft mc = Minecraft.func_71410_x();
    }

    public void blackoutArmorPiece(int index, int duration) {
        this.flashTimers[index] = 20;
        this.blackoutTimers[index] = duration;
        this.blackoutTimersMax[index] = duration;
    }

    public void flashArmorPiece(int index) {
        this.flashTimers[index] = 20;
    }

    public void flashManaBar() {
        if (this.flashTimers[4] <= 1) {
            this.flashTimers[4] = 20;
        }
    }

    public short getFlashTimer(int index) {
        return this.flashTimers[index];
    }

    public int getBlackoutTimer(int index) {
        return this.blackoutTimers[index];
    }

    public int getBlackoutTimerMax(int index) {
        return this.blackoutTimersMax[index];
    }

    public int getSlowTicker() {
        return this.slowUITicker;
    }

    public int getFastTicker() {
        return fastUITicker;
    }

    public float getMagicXPBarAlpha() {
        return this.magicXPBarAlpha;
    }

    public void showMagicXPBar() {
        this.magicXPBarAlpha = 1.0f;
        this.magicXPBarShowTimer = 100;
    }

    public void tick() {
        int i;
        if (this.dummyItem == null) {
            this.dummyItem = new EntityItem((World)Minecraft.func_71410_x().field_71441_e);
        } else {
            ++this.dummyItem.field_70292_b;
        }
        for (i = 0; i < this.flashTimers.length; ++i) {
            if (this.flashTimers[i] <= 0) continue;
            int n = i;
            this.flashTimers[n] = (short)(this.flashTimers[n] - 1);
        }
        for (i = 0; i < this.blackoutTimers.length; ++i) {
            if (this.blackoutTimers[i] > 0) {
                int n = i;
                this.blackoutTimers[n] = this.blackoutTimers[n] - 1;
                if (this.blackoutTimers[i] != 0) continue;
                this.flashArmorPiece(i);
                continue;
            }
            this.blackoutTimersMax[i] = 0;
        }
        ++this.flashCounter;
        if (this.flashCounter > 20) {
            this.flashCounter = 0;
        }
        if (this.magicXPBarShowTimer > 0) {
            --this.magicXPBarShowTimer;
            if (this.magicXPBarShowTimer < 20) {
                this.magicXPBarAlpha -= 0.05f;
            }
        }
        if (this.runCompendiumTicker && ++fastUITicker > 40) {
            fastUITicker = 0;
            ++this.slowUITicker;
        }
        this.slowFlashAlpha = Math.abs((float)this.flashCounter / 20.0f - 0.5f) * 2.0f;
        this.fastFlashAlpha = Math.abs((float)(this.flashCounter % 5) / 5.0f - 0.5f) * 2.0f;
        this.lastmillis = this.millis;
        this.millis = System.currentTimeMillis();
    }

    public void guiTick() {
        this.lastmillis = this.millis;
        this.millis = System.currentTimeMillis();
        this.accumulatedMillis += this.millis - this.lastmillis;
        if (this.accumulatedMillis >= 50L) {
            this.tick();
            this.accumulatedMillis = 0L;
        }
    }

    public void pushCompendiumBreadcrumb(String identifier, int page, int type, Object ... refData) {
        this.compendiumBreadcrumbs.add(new CompendiumBreadcrumb(identifier, refData, type, page));
    }

    public CompendiumBreadcrumb popCompendiumBreadcrumb() {
        if (this.compendiumBreadcrumbs.size() > 0) {
            return this.compendiumBreadcrumbs.pollLast();
        }
        return null;
    }

    public void clearCompendiumBreadcrumbs() {
        this.compendiumBreadcrumbs.clear();
    }

    public static void OpenBookGUI(ItemStack stack) {
    }

    public static void OpenCompendiumGui(ItemStack stack) {
        CompendiumBreadcrumb breadcrumb = instance.popCompendiumBreadcrumb();
        if (breadcrumb != null) {
            if (breadcrumb.entryType == 1) {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiArcaneCompendium(breadcrumb));
            } else {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiCompendiumIndex(breadcrumb));
            }
        } else {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiCompendiumIndex());
        }
    }

    public static void DrawIconAtXY(IIcon IIcon2, float x, float y, float zLevel, int w, int h, boolean semitransparent) {
        if (IIcon2 == null) {
            return;
        }
        GL11.glMatrixMode((int)5890);
        GL11.glPushMatrix();
        if (semitransparent) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(rl_items);
        Tessellator tessellator = Tessellator.field_78398_a;
        boolean drawing = (Boolean)ReflectionHelper.getPrivateValue(Tessellator.class, (Object)tessellator, (String[])new String[]{"field_78415_z", "isDrawing"});
        if (drawing) {
            tessellator.func_78381_a();
        }
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x, (double)(y + (float)h), (double)zLevel, (double)IIcon2.func_94209_e(), (double)IIcon2.func_94210_h());
        tessellator.func_78374_a((double)(x + (float)w), (double)(y + (float)h), (double)zLevel, (double)IIcon2.func_94212_f(), (double)IIcon2.func_94210_h());
        tessellator.func_78374_a((double)(x + (float)w), (double)y, (double)zLevel, (double)IIcon2.func_94212_f(), (double)IIcon2.func_94206_g());
        tessellator.func_78374_a((double)x, (double)y, (double)zLevel, (double)IIcon2.func_94209_e(), (double)IIcon2.func_94206_g());
        tessellator.func_78381_a();
        if (semitransparent) {
            GL11.glDisable((int)3042);
        }
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        if (drawing) {
            tessellator.func_78382_b();
        }
    }

    public static void DrawItemAtXY(ItemStack stack, float x, float y, float zLevel) {
        AMGuiHelper.DrawItemAtXY(stack, x, y, zLevel, 1.0f);
    }

    public static void DrawItemAtXY(ItemStack stack, float x, float y, float zLevel, float scale) {
        if (stack == null) {
            return;
        }
        boolean success = false;
        GL11.glPushAttrib((int)262208);
        RenderHelper.func_74518_a();
        if (scale != 1.0f) {
            GL11.glPushMatrix();
            GL11.glScalef((float)scale, (float)scale, (float)1.0f);
            float invScale = scale - 0.045f;
            success = ForgeHooksClient.renderInventoryItem((RenderBlocks)renderBlocks, (TextureManager)Minecraft.func_71410_x().field_71446_o, (ItemStack)stack, (boolean)true, (float)zLevel, (float)(x + x * invScale), (float)(y + y * invScale));
            if (!success) {
                itemRenderer.func_77015_a(Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().field_71446_o, stack, (int)(x + x * invScale), (int)(y + y * invScale));
            }
            GL11.glPopMatrix();
        } else {
            success = ForgeHooksClient.renderInventoryItem((RenderBlocks)renderBlocks, (TextureManager)Minecraft.func_71410_x().field_71446_o, (ItemStack)stack, (boolean)true, (float)zLevel, (float)x, (float)y);
            if (!success) {
                itemRenderer.func_77015_a(Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().field_71446_o, stack, (int)x, (int)y);
            }
        }
        GL11.glPopAttrib();
    }

    public static void drawCompendiumText(String text, int x_start, int y_start, int max_width, int start_color, FontRenderer fontRenderer) {
        int cur_color = start_color;
        String[] words = text.split(" ");
        int lineLength = 0;
        int posX = x_start;
        int posY = y_start;
        for (String word : words) {
            if (word.equals("")) continue;
            int linesBefore = 0;
            int linesAfter = 0;
            int wordLength = fontRenderer.func_78256_a(word.replaceAll("#.", "") + " ");
            if (lineLength + wordLength > max_width) {
                posY += fontRenderer.field_78288_b;
                posX = x_start;
                lineLength = 0;
            }
            while (word.startsWith("\n")) {
                ++linesBefore;
                word = word.substring(1);
            }
            while (word.endsWith("\n")) {
                ++linesAfter;
                word = word.substring(0, word.length() - 1);
            }
            word = word.replace("\n", "");
            if (linesBefore > 0) {
                posY += fontRenderer.field_78288_b * linesBefore;
                posX = x_start;
                lineLength = 0;
            }
            cur_color = AMGuiHelper.parseColorAndDraw(word, posX, posY, cur_color, fontRenderer);
            posX += wordLength;
            lineLength += wordLength;
            if (linesAfter <= 0) continue;
            posY += fontRenderer.field_78288_b * linesAfter;
            posX = x_start;
            lineLength = 0;
        }
    }

    protected static void drawHoveringText(List par1List, int par2, int par3, FontRenderer font, int width, int height) {
        if (!par1List.isEmpty()) {
            GL11.glDisable((int)32826);
            RenderHelper.func_74518_a();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            int k = 0;
            for (String s : par1List) {
                int l = font.func_78256_a(s);
                if (l <= k) continue;
                k = l;
            }
            int i1 = par2 + 12;
            int j1 = par3 - 12;
            int k1 = 8;
            if (par1List.size() > 1) {
                k1 += 2 + (par1List.size() - 1) * 10;
            }
            if (i1 + k > width) {
                i1 -= 28 + k;
            }
            if (j1 + k1 + 6 > height) {
                j1 = height - k1 - 6;
            }
            int l1 = -267386864;
            AMGuiHelper.drawGradientRect(i1 - 3, j1 - 4, i1 + k + 3, j1 - 3, l1, l1);
            AMGuiHelper.drawGradientRect(i1 - 3, j1 + k1 + 3, i1 + k + 3, j1 + k1 + 4, l1, l1);
            AMGuiHelper.drawGradientRect(i1 - 3, j1 - 3, i1 + k + 3, j1 + k1 + 3, l1, l1);
            AMGuiHelper.drawGradientRect(i1 - 4, j1 - 3, i1 - 3, j1 + k1 + 3, l1, l1);
            AMGuiHelper.drawGradientRect(i1 + k + 3, j1 - 3, i1 + k + 4, j1 + k1 + 3, l1, l1);
            int i2 = 0x505000FF;
            int j2 = (i2 & 0xFEFEFE) >> 1 | i2 & 0xFF000000;
            AMGuiHelper.drawGradientRect(i1 - 3, j1 - 3 + 1, i1 - 3 + 1, j1 + k1 + 3 - 1, i2, j2);
            AMGuiHelper.drawGradientRect(i1 + k + 2, j1 - 3 + 1, i1 + k + 3, j1 + k1 + 3 - 1, i2, j2);
            AMGuiHelper.drawGradientRect(i1 - 3, j1 - 3, i1 + k + 3, j1 - 3 + 1, i2, i2);
            AMGuiHelper.drawGradientRect(i1 - 3, j1 + k1 + 2, i1 + k + 3, j1 + k1 + 3, j2, j2);
            for (int k2 = 0; k2 < par1List.size(); ++k2) {
                String s1 = (String)par1List.get(k2);
                font.func_78261_a(s1, i1, j1, -1);
                if (k2 == 0) {
                    j1 += 2;
                }
                j1 += 10;
            }
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            RenderHelper.func_74519_b();
            GL11.glEnable((int)32826);
        }
    }

    protected static void drawGradientRect(int par1, int par2, int par3, int par4, int par5, int par6) {
        float f = (float)(par5 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(par5 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(par5 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(par5 & 0xFF) / 255.0f;
        float f4 = (float)(par6 >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(par6 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(par6 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(par6 & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78369_a(f1, f2, f3, f);
        tessellator.func_78377_a((double)par3, (double)par2, (double)zLevel);
        tessellator.func_78377_a((double)par1, (double)par2, (double)zLevel);
        tessellator.func_78369_a(f5, f6, f7, f4);
        tessellator.func_78377_a((double)par1, (double)par4, (double)zLevel);
        tessellator.func_78377_a((double)par3, (double)par4, (double)zLevel);
        tessellator.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    public static void line2d(float src_x, float src_y, float dst_x, float dst_y, float zLevel, int color) {
        GL11.glDisable((int)3553);
        GL11.glLineWidth((float)1.0f);
        GL11.glColor3f((float)((float)((color & 0xFF0000) >> 16) / 255.0f), (float)((float)((color & 0xFF00) >> 8) / 255.0f), (float)((float)(color & 0xFF) / 255.0f));
        GL11.glBegin((int)1);
        GL11.glVertex3f((float)src_x, (float)src_y, (float)zLevel);
        GL11.glVertex3f((float)dst_x, (float)dst_y, (float)zLevel);
        GL11.glEnd();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
    }

    public static void line2d(float src_x, float src_y, float dst_x, float dst_y, float zLevel, float weight, int color) {
        GL11.glDisable((int)3553);
        GL11.glLineWidth((float)weight);
        GL11.glColor3f((float)((float)((color & 0xFF0000) >> 16) / 255.0f), (float)((float)((color & 0xFF00) >> 8) / 255.0f), (float)((float)(color & 0xFF) / 255.0f));
        GL11.glBegin((int)1);
        GL11.glVertex3f((float)src_x, (float)src_y, (float)zLevel);
        GL11.glVertex3f((float)dst_x, (float)dst_y, (float)zLevel);
        GL11.glEnd();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
    }

    public static void gradientline2d(float src_x, float src_y, float dst_x, float dst_y, float zLevel, int color1, int color2) {
        GL11.glDisable((int)3553);
        GL11.glShadeModel((int)7425);
        GL11.glLineWidth((float)1.0f);
        GL11.glBegin((int)1);
        GL11.glColor3f((float)((color1 & 0xFF0000) >> 16), (float)((color1 & 0xFF00) >> 8), (float)(color1 & 0xFF));
        GL11.glVertex3f((float)src_x, (float)src_y, (float)zLevel);
        GL11.glColor3f((float)((color2 & 0xFF0000) >> 16), (float)((color2 & 0xFF00) >> 8), (float)(color2 & 0xFF));
        GL11.glVertex3f((float)dst_x, (float)dst_y, (float)zLevel);
        GL11.glEnd();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)3553);
    }

    public static void fractalLine2d(int src_x, int src_y, int dst_x, int dst_y, float zLevel, int color, float displace) {
        AMGuiHelper.fractalLine2d(src_x, src_y, dst_x, dst_y, zLevel, color, displace, fractalLineDetail);
    }

    public static void fractalLine2d(int src_x, int src_y, int dst_x, int dst_y, float zLevel, int color, float displace, float fractalDetail) {
        if (displace < fractalDetail) {
            AMGuiHelper.line2d(src_x, src_y, dst_x, dst_y, zLevel, color);
        } else {
            Random rand = new Random();
            int mid_x = (dst_x + src_x) / 2;
            int mid_y = (dst_y + src_y) / 2;
            mid_x = (int)((double)mid_x + ((double)rand.nextFloat() - 0.5) * (double)displace);
            mid_y = (int)((double)mid_y + ((double)rand.nextFloat() - 0.5) * (double)displace);
            AMGuiHelper.fractalLine2d(src_x, src_y, mid_x, mid_y, zLevel, color, displace / 2.0f, fractalDetail);
            AMGuiHelper.fractalLine2d(dst_x, dst_y, mid_x, mid_y, zLevel, color, displace / 2.0f, fractalDetail);
        }
    }

    private static int parseColorAndDraw(String word, int posX, int posY, int cur_color, FontRenderer fontRenderer) {
        int index = word.indexOf("#");
        int color = cur_color;
        while (index > -1 && index < word.length() - 1) {
            String toRender = word.substring(0, index);
            fontRenderer.func_78276_b(toRender, posX, posY, color);
            posX += fontRenderer.func_78256_a(toRender);
            char nextChar = word.charAt(index + 1);
            switch (nextChar) {
                case '0': {
                    color = 0;
                    break;
                }
                case '1': {
                    color = 191;
                    break;
                }
                case '2': {
                    color = 48896;
                    break;
                }
                case '3': {
                    color = 49087;
                    break;
                }
                case '4': {
                    color = 0xBF0000;
                    break;
                }
                case '5': {
                    color = 0xBF00BF;
                    break;
                }
                case '6': {
                    color = 0xBFBF00;
                    break;
                }
                case '7': {
                    color = 0xBFBFBF;
                    break;
                }
                case '8': {
                    color = 0x404040;
                    break;
                }
                case '9': {
                    color = 0x4040FF;
                    break;
                }
                case 'a': {
                    color = 0x40FF40;
                    break;
                }
                case 'b': {
                    color = 0x40FFFF;
                    break;
                }
                case 'c': {
                    color = 0xFF4040;
                    break;
                }
                case 'd': {
                    color = 0xFF40FF;
                    break;
                }
                case 'e': {
                    color = 0xFFFF40;
                    break;
                }
                case 'f': {
                    color = 0xFFFFFF;
                }
            }
            word = word.substring(index + 2);
            index = word.indexOf("#");
        }
        fontRenderer.func_78276_b(word, posX, posY, color);
        return color;
    }

    public static int createRenderTexture() {
        int colorTextureID = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)colorTextureID);
        GL11.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
        GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)512, (int)512, (int)0, (int)6408, (int)5124, (ByteBuffer)null);
        return colorTextureID;
    }

    public static int createFBO(int textureID, int w, int h, boolean depthBuffer) {
        boolean FBOEnabled = GLContext.getCapabilities().GL_EXT_framebuffer_object;
        if (!FBOEnabled) {
            return -1;
        }
        IntBuffer buffer = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder()).asIntBuffer();
        EXTFramebufferObject.glGenFramebuffersEXT((IntBuffer)buffer);
        int myFBOId = buffer.get();
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)myFBOId);
        EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36064, (int)3553, (int)textureID, (int)0);
        int framebuffer = EXTFramebufferObject.glCheckFramebufferStatusEXT((int)36160);
        switch (framebuffer) {
            case 36053: {
                break;
            }
            case 36054: {
                throw new RuntimeException("FrameBuffer: " + myFBOId + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT exception");
            }
            case 36055: {
                throw new RuntimeException("FrameBuffer: " + myFBOId + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT exception");
            }
            case 36057: {
                throw new RuntimeException("FrameBuffer: " + myFBOId + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT exception");
            }
            case 36059: {
                throw new RuntimeException("FrameBuffer: " + myFBOId + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT exception");
            }
            case 36058: {
                throw new RuntimeException("FrameBuffer: " + myFBOId + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT exception");
            }
            case 36060: {
                throw new RuntimeException("FrameBuffer: " + myFBOId + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT exception");
            }
            default: {
                throw new RuntimeException("Unexpected reply from glCheckFramebufferStatusEXT: " + framebuffer);
            }
        }
        return myFBOId;
    }

    public static boolean bindFBOTexture(int FBOId, int w, int h) {
        try {
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)FBOId);
            GL11.glPushAttrib((int)2048);
            GL11.glViewport((int)0, (int)0, (int)w, (int)h);
            GL11.glClear((int)16384);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean unbindFBOTexture() {
        try {
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)0);
            GL11.glPopAttrib();
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static void flipView(float f) {
        float flip = ExtendedProperties.For((EntityLivingBase)Minecraft.func_71410_x().field_71439_g).getFlipRotation();
        float lastFlip = ExtendedProperties.For((EntityLivingBase)Minecraft.func_71410_x().field_71439_g).getPrevFlipRotation();
        GL11.glRotatef((float)(lastFlip + (flip - lastFlip) * f), (float)0.0f, (float)0.0f, (float)1.0f);
    }

    public static void shiftView(float f) {
        ExtendedProperties exProps;
        EntityClientPlayerMP entity = Minecraft.func_71410_x().field_71439_g;
        int viewSet = Minecraft.func_71410_x().field_71474_y.field_74320_O;
        if (viewSet == 0 && (exProps = ExtendedProperties.For((EntityLivingBase)entity)).getShrinkPct() > 0.0f) {
            float amt = exProps.getPrevShrinkPct() + (exProps.getShrinkPct() - exProps.getPrevShrinkPct()) * f;
            GL11.glTranslatef((float)0.0f, (float)(1.0f * amt), (float)0.0f);
        }
        float flip = ExtendedProperties.For((EntityLivingBase)entity).getFlipRotation();
        float prevFlip = ExtendedProperties.For((EntityLivingBase)entity).getPrevFlipRotation();
        if (flip > 0.0f) {
            float smoothedFlip = prevFlip + (flip - prevFlip) * f;
            GL11.glTranslatef((float)0.0f, (float)(entity.field_70131_O * (smoothedFlip / 180.0f) - 0.1f), (float)0.0f);
        }
    }

    public static void overrideKeyboardInput() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && mc.field_71441_e != null && ExtendedProperties.For((EntityLivingBase)mc.field_71439_g).shouldReverseInput()) {
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            if (mc.field_71474_y.field_74370_x.func_151470_d()) {
                FMLLog.info((String)"Override Left", (Object[])new Object[0]);
                player.field_71158_b.field_78902_a -= 2.0f;
            }
            if (mc.field_71474_y.field_74366_z.func_151470_d()) {
                FMLLog.info((String)"Override Rights", (Object[])new Object[0]);
                player.field_71158_b.field_78902_a += 2.0f;
            }
            if (mc.field_71439_g.func_70644_a((Potion)BuffList.scrambleSynapses)) {
                if (mc.field_71474_y.field_74351_w.func_151470_d()) {
                    player.field_71158_b.field_78900_b -= 2.0f;
                }
                if (mc.field_71474_y.field_74368_y.func_151470_d()) {
                    player.field_71158_b.field_78900_b += 2.0f;
                }
            }
        }
    }

    public static boolean overrideMouseInput(EntityRenderer renderer, float f, boolean b) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!mc.field_71415_G || mc.field_71439_g == null || mc.field_71441_e == null) {
            return true;
        }
        ExtendedProperties props = ExtendedProperties.For((EntityLivingBase)mc.field_71439_g);
        if (!(mc.field_71439_g.func_70644_a((Potion)BuffList.scrambleSynapses) ^ props.getIsFlipped())) {
            return true;
        }
        mc.field_71417_B.func_74374_c();
        float f1 = mc.field_71474_y.field_74341_c * 0.6f + 0.2f;
        float f2 = f1 * f1 * f1 * 8.0f;
        float f3 = (float)mc.field_71417_B.field_74377_a * f2;
        float f4 = (float)mc.field_71417_B.field_74375_b * f2;
        int b0 = -1;
        if (mc.field_71474_y.field_74338_d) {
            b0 = 1;
        }
        if (mc.field_71474_y.field_74326_T) {
            String[] scy = new String[]{"field_78496_H", "smoothCamYaw"};
            String[] scp = new String[]{"field_78521_m", "smoothCamPitch"};
            String[] scpt = new String[]{"field_78533_p", "smoothCamPartialTicks"};
            String[] scfx = new String[]{"field_78518_n", "smoothCamFilterX"};
            String[] scfy = new String[]{"field_78499_K", "smoothCamFilterY"};
            ReflectionHelper.setPrivateValue(EntityRenderer.class, (Object)renderer, (Object)Float.valueOf(((Float)ReflectionHelper.getPrivateValue(EntityRenderer.class, (Object)renderer, (String[])scy)).floatValue() - f3), (String[])scy);
            ReflectionHelper.setPrivateValue(EntityRenderer.class, (Object)renderer, (Object)Float.valueOf(((Float)ReflectionHelper.getPrivateValue(EntityRenderer.class, (Object)renderer, (String[])scp)).floatValue() - f4), (String[])scp);
            float f5 = f - ((Float)ReflectionHelper.getPrivateValue(EntityRenderer.class, (Object)renderer, (String[])scpt)).floatValue();
            ReflectionHelper.setPrivateValue(EntityRenderer.class, (Object)renderer, (Object)Float.valueOf(f), (String[])scpt);
            f3 = ((Float)ReflectionHelper.getPrivateValue(EntityRenderer.class, (Object)renderer, (String[])scfx)).floatValue() * f5;
            f4 = ((Float)ReflectionHelper.getPrivateValue(EntityRenderer.class, (Object)renderer, (String[])scfy)).floatValue() * f5;
            mc.field_71439_g.func_70082_c(-f3, f4 * (float)b0);
        } else {
            mc.field_71439_g.func_70082_c(-f3, f4 * (float)b0);
        }
        return false;
    }

    public class CompendiumBreadcrumb {
        public final String entryName;
        public final Object[] refData;
        public final int entryType;
        public final int page;
        public static final int TYPE_INDEX = 0;
        public static final int TYPE_ENTRY = 1;

        public CompendiumBreadcrumb(String entryName, Object[] refObject, int entryType, int page) {
            this.entryName = entryName;
            this.entryType = entryType;
            this.refData = refObject;
            this.page = page;
        }
    }
}

