/*
 * Decompiled with CFR 0.152.
 */
package am2.entities;

import am2.AMCore;
import am2.api.math.AMVector3;
import am2.api.spell.component.interfaces.ISpellModifier;
import am2.api.spell.enums.SpellModifiers;
import am2.blocks.BlocksCommonProxy;
import am2.damage.DamageSources;
import am2.items.ItemsCommonProxy;
import am2.lore.CompendiumUnlockHandler;
import am2.network.AMNetHandler;
import am2.particles.AMParticle;
import am2.particles.ParticleChangeSize;
import am2.particles.ParticleColorShift;
import am2.particles.ParticleHoldPosition;
import am2.spell.SpellHelper;
import am2.spell.SpellUtils;
import am2.spell.modifiers.Colour;
import am2.utility.MathUtilities;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityThrownRock
extends EntityLiving {
    private EntityLivingBase throwingEntity;
    private int maxTicksToExist;
    private AMVector3 target = null;
    private float damage;
    private static final int IS_MOONSTONE_METEOR = 20;
    private static final int IS_SHOOTING_STAR = 21;
    private static final int SPELL_STACK = 22;

    public EntityThrownRock(World par1World) {
        super(par1World);
        this.field_70173_aa = 0;
        this.maxTicksToExist = 120;
        this.field_70145_X = true;
    }

    public void setMoonstoneMeteor() {
        this.field_70180_af.func_75692_b(20, (Object)1);
    }

    public void setShootingStar(float damage) {
        this.field_70180_af.func_75692_b(21, (Object)1);
        this.damage = damage;
    }

    public void setMoonstoneMeteorTarget(AMVector3 target) {
        this.target = target;
    }

    public boolean getIsMoonstoneMeteor() {
        return this.field_70180_af.func_75683_a(20) == 1;
    }

    public boolean getIsShootingStar() {
        return this.field_70180_af.func_75683_a(21) == 1;
    }

    public EntityThrownRock(World world, EntityLivingBase entityLiving, double projectileSpeed) {
        super(world);
        this.field_70145_X = true;
        this.throwingEntity = entityLiving;
        this.func_70105_a(0.25f, 0.25f);
        this.func_70012_b(entityLiving.field_70165_t, entityLiving.field_70163_u + (double)entityLiving.func_70047_e(), entityLiving.field_70161_v, entityLiving.field_70177_z, entityLiving.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * 3.141593f)) * 0.16f);
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * 3.141593f)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70129_M = 0.0f;
        float f = 0.05f;
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * 3.141593f)) * f;
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * 3.141593f)) * f;
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * 3.141593f)) * f;
        this.maxTicksToExist = 100;
        this.setHeading(this.field_70159_w, this.field_70181_x, this.field_70179_y, projectileSpeed, projectileSpeed);
    }

    public void setHeading(double movementX, double movementY, double movementZ, double projectileSpeed, double projectileSpeed2) {
        float f = MathHelper.func_76133_a((double)(movementX * movementX + movementY * movementY + movementZ * movementZ));
        movementX /= (double)f;
        movementY /= (double)f;
        movementZ /= (double)f;
        movementX += this.field_70146_Z.nextGaussian() * (double)0.0075f * projectileSpeed2;
        movementY += this.field_70146_Z.nextGaussian() * (double)0.0075f * projectileSpeed2;
        movementZ += this.field_70146_Z.nextGaussian() * (double)0.0075f * projectileSpeed2;
        this.field_70159_w = movementX *= projectileSpeed;
        this.field_70181_x = movementY *= projectileSpeed;
        this.field_70179_y = movementZ *= projectileSpeed;
        float f1 = MathHelper.func_76133_a((double)(movementX * movementX + movementZ * movementZ));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(movementX, movementZ) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(movementY, f1) * 180.0 / Math.PI);
    }

    public void setThrowingEntity(EntityLivingBase thrower) {
        this.throwingEntity = thrower;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)0);
        this.field_70180_af.func_75682_a(22, (Object)new ItemStack((Item)ItemsCommonProxy.spell));
    }

    private ItemStack getSpellStack() {
        return this.field_70180_af.func_82710_f(22);
    }

    public void setSpellStack(ItemStack spellStack) {
        this.field_70180_af.func_75692_b(22, (Object)spellStack);
    }

    protected boolean func_70692_ba() {
        return !this.getIsMoonstoneMeteor() && !this.getIsShootingStar();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.target != null && this.field_70163_u > (double)this.target.y) {
            double deltaX = this.field_70165_t - (double)this.target.x;
            double deltaY = this.field_70163_u - (double)this.target.y;
            double deltaZ = this.field_70161_v - (double)this.target.z;
            double angle = Math.atan2(deltaZ, deltaX);
            double hDist = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
            double vAngle = Math.atan2(deltaY, hDist);
            this.field_70159_w = -Math.cos(angle) * 0.2;
            this.field_70179_y = -Math.sin(angle) * 0.2;
            this.field_70181_x = -Math.sin(vAngle) * 2.5;
        }
        if (!this.getIsMoonstoneMeteor() && !this.getIsShootingStar()) {
            if (!this.field_70170_p.field_72995_K && (this.throwingEntity == null || this.throwingEntity.field_70128_L)) {
                this.func_70106_y();
            } else {
                int maxTicksToLive;
                ++this.field_70173_aa;
                int n = maxTicksToLive = this.maxTicksToExist > -1 ? this.maxTicksToExist : 100;
                if (this.field_70173_aa >= maxTicksToLive && !this.field_70170_p.field_72995_K) {
                    this.func_70106_y();
                    return;
                }
            }
        }
        if (this.getIsShootingStar()) {
            this.field_70181_x -= (double)0.1f;
            if (this.field_70181_x < -2.0) {
                this.field_70181_x = -2.0;
            }
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.getIsMoonstoneMeteor()) {
                AMParticle fire = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(this.field_70170_p, "explosion_2", this.field_70165_t, this.field_70163_u, this.field_70161_v));
                if (fire != null) {
                    fire.setMaxAge(20);
                    fire.setRGBColorF(1.0f, 1.0f, 1.0f);
                    fire.setParticleScale(2.0f);
                    fire.AddParticleController(new ParticleHoldPosition(fire, 20, 1, false));
                    fire.AddParticleController(new ParticleColorShift(fire, 1, false).SetShiftSpeed(0.1f).SetColorTarget(0.01f, 0.01f, 0.01f).SetEndOnReachingTargetColor().setKillParticleOnFinish(false));
                }
            } else if (this.getIsShootingStar()) {
                int color = -1;
                if (this.getSpellStack() != null && SpellUtils.instance.modifierIsPresent(SpellModifiers.COLOR, this.getSpellStack(), 0)) {
                    ISpellModifier[] mods = SpellUtils.instance.getModifiersForStage(this.getSpellStack(), 0);
                    int ordinalCount = 0;
                    for (ISpellModifier mod : mods) {
                        if (!(mod instanceof Colour)) continue;
                        byte[] meta = SpellUtils.instance.getModifierMetadataFromStack(this.getSpellStack(), mod, 0, ordinalCount++);
                        color = (int)mod.getModifier(SpellModifiers.COLOR, null, null, null, meta);
                    }
                }
                float i = 0.0f;
                while ((double)i < Math.abs(this.field_70181_x)) {
                    AMParticle star = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(this.field_70170_p, "ember", this.field_70165_t + this.field_70159_w * (double)i, this.field_70163_u + this.field_70181_x * (double)i, this.field_70161_v + this.field_70179_y * (double)i));
                    if (star != null) {
                        star.setMaxAge(22);
                        float clr = this.field_70146_Z.nextFloat();
                        float clrMod = Minecraft.func_71410_x().field_71441_e.field_73012_v.nextFloat();
                        int finalColor = -1;
                        if (color == -1) {
                            finalColor = MathUtilities.colorFloatsToInt(0.24f * clrMod, 0.58f * clrMod, 0.71f * clrMod);
                        } else {
                            float[] colors = MathUtilities.colorIntToFloats(color);
                            for (int c = 0; c < colors.length; ++c) {
                                colors[c] = colors[c] * clrMod;
                            }
                            finalColor = MathUtilities.colorFloatsToInt(colors[0], colors[1], colors[2]);
                        }
                        star.setRGBColorI(finalColor);
                        star.AddParticleController(new ParticleHoldPosition(star, 20, 1, false));
                        star.AddParticleController(new ParticleChangeSize(star, 0.5f, 0.05f, 20, 1, false));
                    }
                    i += 0.1f;
                }
            }
        }
        Vec3 vec3d = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        Vec3 vec3d1 = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
        MovingObjectPosition movingobjectposition = this.field_70170_p.func_72933_a(vec3d, vec3d1);
        vec3d = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        vec3d1 = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
        if (movingobjectposition != null) {
            vec3d1 = Vec3.func_72443_a((double)movingobjectposition.field_72307_f.field_72450_a, (double)movingobjectposition.field_72307_f.field_72448_b, (double)movingobjectposition.field_72307_f.field_72449_c);
        }
        Entity entity = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
        double d = 0.0;
        for (int j = 0; j < list.size(); ++j) {
            double d1;
            float f2;
            AxisAlignedBB axisalignedbb;
            MovingObjectPosition movingobjectposition1;
            Entity entity1 = (Entity)list.get(j);
            if (!entity1.func_70067_L() || entity1.func_70028_i((Entity)this.throwingEntity) && this.field_70173_aa < 25 || (movingobjectposition1 = (axisalignedbb = entity1.field_70121_D.func_72314_b((double)(f2 = 0.3f), (double)f2, (double)f2)).func_72327_a(vec3d, vec3d1)) == null || !((d1 = vec3d.func_72438_d(movingobjectposition1.field_72307_f)) < d) && d != 0.0) continue;
            entity = entity1;
            d = d1;
        }
        if (entity != null) {
            movingobjectposition = new MovingObjectPosition(entity);
        }
        if (movingobjectposition != null) {
            this.HitObject(movingobjectposition);
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / 3.1415927410125732);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f) * 180.0 / 3.1415927410125732);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        float f1 = 0.95f;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    protected void HitObject(MovingObjectPosition movingobjectposition) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.getIsShootingStar()) {
            AMNetHandler.INSTANCE.sendStarImpactToClients(this.field_70165_t, this.field_70163_u + (double)(movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY ? -movingobjectposition.field_72308_g.func_70047_e() : 1.5f), this.field_70161_v, this.field_70170_p, this.getSpellStack());
            List ents = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.field_70121_D.func_72314_b(5.0, 5.0, 5.0));
            for (EntityLivingBase e : ents) {
                if (e == this.throwingEntity || !this.func_70635_at().func_75522_a((Entity)e)) continue;
                SpellHelper.instance.attackTargetSpecial(null, (Entity)e, DamageSources.causeEntityMagicDamage(this.throwingEntity), this.damage);
            }
        } else if (movingobjectposition.field_72308_g != null && movingobjectposition.field_72308_g instanceof EntityLivingBase) {
            if (movingobjectposition.field_72308_g == this.throwingEntity || this.throwingEntity == null) {
                return;
            }
            if (this.throwingEntity != null) {
                movingobjectposition.field_72308_g.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.throwingEntity), 10.0f);
            }
        } else if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && this.getIsMoonstoneMeteor()) {
            if (this.target == null) {
                this.target = new AMVector3(movingobjectposition.field_72307_f);
            }
            this.field_70170_p.func_72885_a((Entity)this, (double)this.target.x, (double)this.target.y, (double)this.target.z, 0.8f, false, AMCore.config.moonstoneMeteorsDestroyTerrain());
            int numOres = this.field_70146_Z.nextInt(6) + 1;
            for (int i = 0; i < numOres; ++i) {
                this.generateSurfaceOreAtOffset(this.field_70170_p, (int)Math.floor(this.target.x), (int)Math.floor(this.target.y), (int)Math.floor(this.target.z), i == 0);
            }
            if (this.field_70170_p.field_72995_K) {
                for (Object player : this.field_70170_p.field_73010_i) {
                    if (!(((EntityPlayer)player).func_70068_e((Entity)this) < 4096.0)) continue;
                    CompendiumUnlockHandler.unlockEntry("moonstone_meteors");
                }
            }
        }
        this.func_70106_y();
    }

    private void generateSurfaceOreAtOffset(World world, int x, int y, int z, boolean force) {
        x = x + this.field_70146_Z.nextInt(4) - 2;
        z = z + this.field_70146_Z.nextInt(4) - 2;
        while (!world.func_147437_c(x, y, z) && y < world.func_72940_L()) {
            ++y;
        }
        if (this.field_70146_Z.nextInt(4) < 2 || force) {
            world.func_147465_d(x, y, z, (Block)BlocksCommonProxy.AMOres, 3, 2);
        } else {
            world.func_147449_b(x, y, z, Blocks.field_150348_b);
        }
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        return false;
    }

    public void func_70037_a(NBTTagCompound par1nbtTagCompound) {
        super.func_70037_a(par1nbtTagCompound);
        this.damage = par1nbtTagCompound.func_74760_g("star_damage");
    }

    public void func_70014_b(NBTTagCompound par1nbtTagCompound) {
        super.func_70014_b(par1nbtTagCompound);
        par1nbtTagCompound.func_74776_a("star_damage", this.damage);
    }
}

