/*
 * Decompiled with CFR 0.152.
 */
package am2.entities;

import am2.AMCore;
import am2.api.math.AMVector3;
import am2.api.spell.component.interfaces.ISpellModifier;
import am2.api.spell.enums.Affinity;
import am2.api.spell.enums.SpellModifiers;
import am2.buffs.BuffList;
import am2.items.ItemsCommonProxy;
import am2.particles.AMParticle;
import am2.particles.AMParticleIcons;
import am2.particles.ParticleFloatUpward;
import am2.particles.ParticleHoldPosition;
import am2.spell.SpellHelper;
import am2.spell.SpellUtils;
import am2.spell.modifiers.Colour;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntitySpellProjectile
extends Entity {
    private final int maxTicksToExist;
    private int ticksExisted;
    private int originalBounceCount;
    private final double friction_coefficient = AMCore.config.getFrictionCoefficient();
    private ArrayList<AMVector3> blockhits;
    private ArrayList<Integer> entityHits;
    private static final int DW_BOUNCE_COUNTER = 21;
    private static final int DW_GRAVITY = 22;
    private static final int DW_EFFECT = 23;
    private static final int DW_ICON_NAME = 24;
    private static final int DW_PIERCE_COUNT = 25;
    private static final int DW_COLOR = 26;
    private static final int DW_SHOOTER = 27;
    private static final int DW_TARGETGRASS = 28;
    private static final float GRAVITY_TERMINAL_VELOCITY = -2.0f;
    private String particleType = "";

    public EntitySpellProjectile(World world) {
        super(world);
        this.ticksExisted = 0;
        this.maxTicksToExist = -1;
        this.field_70145_X = true;
    }

    public EntitySpellProjectile(World world, EntityLivingBase entityLiving, double projectileSpeed) {
        super(world);
        this.field_70145_X = true;
        this.func_70105_a(0.25f, 0.25f);
        this.func_70012_b(entityLiving.field_70165_t, entityLiving.field_70163_u + (double)entityLiving.func_70047_e(), entityLiving.field_70161_v, entityLiving.field_70177_z, entityLiving.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * 3.141593f)) * 0.16f);
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * 3.141593f)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70129_M = 0.0f;
        float f = 0.01f;
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * 3.141593f)) * f;
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * 3.141593f)) * f;
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * 3.141593f)) * f;
        this.maxTicksToExist = -1;
        this.setSpellProjectileHeading(this.field_70159_w, this.field_70181_x, this.field_70179_y, projectileSpeed, projectileSpeed);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(21, (Object)0);
        this.field_70180_af.func_75682_a(22, (Object)0);
        this.field_70180_af.func_75682_a(23, (Object)new ItemStack((Item)ItemsCommonProxy.spell));
        this.field_70180_af.func_75682_a(24, (Object)"arcane");
        this.field_70180_af.func_75682_a(25, (Object)0);
        this.field_70180_af.func_75682_a(26, (Object)0xFFFFFF);
        this.field_70180_af.func_75682_a(27, (Object)0);
        this.field_70180_af.func_75682_a(28, (Object)0);
        this.blockhits = new ArrayList();
        this.entityHits = new ArrayList();
    }

    public void setSpellProjectileHeading(double movementX, double movementY, double movementZ, double projectileSpeed, double projectileSpeed2) {
        float f = MathHelper.func_76133_a((double)(movementX * movementX + movementY * movementY + movementZ * movementZ));
        movementX /= (double)f;
        movementY /= (double)f;
        movementZ /= (double)f;
        this.field_70159_w = movementX *= projectileSpeed;
        this.field_70181_x = movementY *= projectileSpeed;
        this.field_70179_y = movementZ *= projectileSpeed;
        float f1 = MathHelper.func_76133_a((double)(movementX * movementX + movementZ * movementZ));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(movementX, movementZ) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(movementY, f1) * 180.0 / Math.PI);
    }

    public void setShootingEntity(EntityLivingBase caster) {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_75692_b(27, (Object)caster.func_145782_y());
        }
    }

    public void setTargetWater() {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_75692_b(28, (Object)1);
        }
    }

    private boolean targetWater() {
        return this.field_70180_af.func_75683_a(28) == 1;
    }

    private EntityLivingBase getShootingEntity() {
        int entityID = this.field_70180_af.func_75679_c(27);
        Entity e = this.field_70170_p.func_73045_a(entityID);
        if (e != null && e instanceof EntityLivingBase) {
            return (EntityLivingBase)e;
        }
        return null;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && (this.getShootingEntity() == null || this.getShootingEntity().field_70128_L)) {
            this.func_70106_y();
        } else {
            int maxTicksToLive;
            ++this.ticksExisted;
            int n = maxTicksToLive = this.maxTicksToExist > -1 ? this.maxTicksToExist : 100;
            if (this.ticksExisted >= maxTicksToLive && !this.field_70170_p.field_72995_K) {
                this.func_70106_y();
                return;
            }
        }
        Vec3 vec3d = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        Vec3 vec3d1 = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
        MovingObjectPosition movingobjectposition = null;
        movingobjectposition = this.field_70170_p.func_72901_a(vec3d, vec3d1, true);
        vec3d = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        vec3d1 = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
        if (movingobjectposition != null) {
            vec3d1 = Vec3.func_72443_a((double)movingobjectposition.field_72307_f.field_72450_a, (double)movingobjectposition.field_72307_f.field_72448_b, (double)movingobjectposition.field_72307_f.field_72449_c);
        }
        Entity entity = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
        double d = 0.0;
        for (int j = 0; j < list.size(); ++j) {
            double d1;
            float f2;
            AxisAlignedBB axisalignedbb;
            MovingObjectPosition movingobjectposition1;
            Entity entity1 = (Entity)list.get(j);
            if (!entity1.func_70067_L() || entity1.func_70028_i((Entity)this.getShootingEntity()) || (movingobjectposition1 = (axisalignedbb = entity1.field_70121_D.func_72314_b((double)(f2 = 0.3f), (double)f2, (double)f2)).func_72327_a(vec3d, vec3d1)) == null || !((d1 = vec3d.func_72438_d(movingobjectposition1.field_72307_f)) < d) && d != 0.0) continue;
            entity = entity1;
            d = d1;
        }
        if (entity != null) {
            movingobjectposition = new MovingObjectPosition(entity);
        }
        if (movingobjectposition != null) {
            Block block;
            AxisAlignedBB bb;
            boolean pierce;
            boolean doHit = true;
            boolean bl = pierce = this.getNumPierces() > 0;
            if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && movingobjectposition.field_72308_g != null && movingobjectposition.field_72308_g instanceof EntityLivingBase) {
                EntityLivingBase ent = (EntityLivingBase)movingobjectposition.field_72308_g;
                if (ent.func_82165_m(BuffList.spellReflect.field_76415_H) && !pierce) {
                    doHit = false;
                    this.setShootingEntity(ent);
                    this.field_70159_w = -this.field_70159_w;
                    this.field_70181_x = -this.field_70181_x;
                    this.field_70179_y = -this.field_70179_y;
                    if (!this.field_70170_p.field_72995_K) {
                        ent.func_82170_o(BuffList.spellReflect.field_76415_H);
                    }
                    this.setBounces(this.originalBounceCount);
                    if (this.field_70170_p.field_72995_K) {
                        for (int i = 0; i < 13; ++i) {
                            AMParticle effect = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(this.field_70170_p, "hr_lensflare", ent.field_70165_t + this.field_70146_Z.nextDouble() - 0.5, ent.field_70163_u + (double)ent.func_70047_e() + this.field_70146_Z.nextDouble() - 0.5, ent.field_70161_v + this.field_70146_Z.nextDouble() - 0.5));
                            if (effect == null) continue;
                            EntityPlayer player = AMCore.proxy.getLocalPlayer();
                            effect.setIgnoreMaxAge(true);
                            if (player != null && ent != player) {
                                effect.setParticleScale(1.5f);
                            }
                            effect.setRGBColorF(0.5f + this.field_70146_Z.nextFloat() * 0.5f, 0.2f, 0.5f + this.field_70146_Z.nextFloat() * 0.5f);
                            effect.AddParticleController(new ParticleHoldPosition(effect, 100, 1, false));
                        }
                    }
                }
            } else if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && this.getBounces() > 0) {
                doHit = false;
                switch (movingobjectposition.field_72310_e) {
                    case 0: 
                    case 1: {
                        this.field_70181_x = this.field_70181_x * this.friction_coefficient * -1.0;
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.field_70179_y = this.field_70179_y * this.friction_coefficient * -1.0;
                        break;
                    }
                    case 4: 
                    case 5: {
                        this.field_70159_w = this.field_70159_w * this.friction_coefficient * -1.0;
                    }
                }
                this.setBounces(this.getBounces() - 1);
            }
            if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && (bb = (block = this.field_70170_p.func_147439_a(movingobjectposition.field_72311_b, movingobjectposition.field_72312_c, movingobjectposition.field_72309_d)).func_149668_a(this.field_70170_p, movingobjectposition.field_72311_b, movingobjectposition.field_72312_c, movingobjectposition.field_72309_d)) == null && !SpellUtils.instance.modifierIsPresent(SpellModifiers.TARGET_NONSOLID_BLOCKS, this.getEffectStack(), 0)) {
                doHit = false;
            }
            if (doHit) {
                this.HitObject(movingobjectposition, pierce);
            }
        }
        if (this.getGravity() < 0.0 && this.field_70181_x > -2.0) {
            this.field_70181_x += this.getGravity();
        } else if (this.getGravity() > 0.0 && this.field_70181_x < 2.0) {
            this.field_70181_x -= this.getGravity();
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / 3.1415927410125732);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f) * 180.0 / 3.1415927410125732);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        float f1 = 0.95f;
        if (this.func_70090_H()) {
            for (int k = 0; k < 4; ++k) {
                float f3 = 0.25f;
                this.field_70170_p.func_72869_a("bubble", this.field_70165_t - this.field_70159_w * (double)f3, this.field_70163_u - this.field_70181_x * (double)f3, this.field_70161_v - this.field_70179_y * (double)f3, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
            f1 = 0.8f;
        }
        if (!AMCore.config.NoGFX() && this.field_70170_p.field_72995_K && this.getShootingEntity() instanceof EntityPlayer) {
            AMParticle particle;
            if (this.particleType == null || this.particleType.isEmpty()) {
                this.particleType = AMParticleIcons.instance.getSecondaryParticleForAffinity(SpellUtils.instance.mainAffinityFor(this.getEffectStack()));
            }
            if ((particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(this.field_70170_p, this.particleType, this.field_70165_t, this.field_70163_u, this.field_70161_v))) != null) {
                particle.addRandomOffset(0.3f, 0.3f, 0.3f);
                particle.AddParticleController(new ParticleFloatUpward(particle, 0.1f, 0.0f, 1, false));
                particle.setMaxAge(10);
                particle.setParticleScale(0.05f);
            }
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    protected void HitObject(MovingObjectPosition movingobjectposition, boolean pierce) {
        if (movingobjectposition.field_72308_g != null) {
            if (movingobjectposition.field_72308_g == this.getShootingEntity() || this.getShootingEntity() == null) {
                return;
            }
            Entity e = movingobjectposition.field_72308_g;
            if (e instanceof EntityDragonPart && ((EntityDragonPart)e).field_70259_a instanceof EntityLivingBase) {
                e = (EntityLivingBase)((EntityDragonPart)e).field_70259_a;
            }
            if (e instanceof EntityLivingBase && this.getShootingEntity() != null && !this.entityHits.contains(movingobjectposition.field_72308_g.func_145782_y())) {
                SpellHelper.instance.applyStageToEntity(this.getEffectStack(), this.getShootingEntity(), this.field_70170_p, e, 0, true);
                SpellHelper.instance.applyStackStage(SpellUtils.instance.popStackStage(this.getEffectStack()), this.getShootingEntity(), (EntityLivingBase)e, movingobjectposition.field_72307_f.field_72450_a, movingobjectposition.field_72307_f.field_72448_b, movingobjectposition.field_72307_f.field_72449_c, 0, this.field_70170_p, false, true, 0);
                this.entityHits.add(movingobjectposition.field_72308_g.func_145782_y());
            }
        } else {
            AMVector3 blockLoc = new AMVector3(movingobjectposition.field_72311_b, movingobjectposition.field_72312_c, movingobjectposition.field_72309_d);
            if (this.getShootingEntity() != null && !this.blockhits.contains(blockLoc)) {
                SpellHelper.instance.applyStageToGround(this.getEffectStack(), this.getShootingEntity(), this.field_70170_p, movingobjectposition.field_72311_b, movingobjectposition.field_72312_c, movingobjectposition.field_72309_d, movingobjectposition.field_72310_e, movingobjectposition.field_72307_f.field_72450_a, movingobjectposition.field_72307_f.field_72448_b, movingobjectposition.field_72307_f.field_72449_c, 0, true);
                SpellHelper.instance.applyStackStage(SpellUtils.instance.popStackStage(this.getEffectStack()), this.getShootingEntity(), this.getShootingEntity(), movingobjectposition.field_72311_b, movingobjectposition.field_72312_c, movingobjectposition.field_72309_d, movingobjectposition.field_72310_e, this.field_70170_p, false, true, 0);
                this.blockhits.add(blockLoc);
            }
        }
        this.setNumPierces(this.getNumPierces() - 1);
        if (!this.field_70170_p.field_72995_K && !pierce) {
            this.func_70106_y();
        }
    }

    public int getBounces() {
        return this.field_70180_af.func_75679_c(21);
    }

    public void setBounces(int bounces) {
        this.field_70180_af.func_75692_b(21, (Object)bounces);
    }

    public double getGravity() {
        return (double)this.field_70180_af.func_75679_c(22) / 1000.0;
    }

    public void setGravity(double gravity) {
        this.field_70180_af.func_75692_b(22, (Object)((int)(gravity * 1000.0)));
    }

    public ItemStack getEffectStack() {
        return this.field_70180_af.func_82710_f(23);
    }

    public void setEffectStack(ItemStack stack) {
        this.field_70180_af.func_75692_b(23, (Object)stack);
        if (!this.field_70170_p.field_72995_K) {
            Affinity aff = SpellUtils.instance.mainAffinityFor(stack);
            switch (aff) {
                case AIR: {
                    this.setIcon("wind");
                    break;
                }
                case ARCANE: {
                    this.setIcon("arcane");
                    break;
                }
                case EARTH: {
                    this.setIcon("rock");
                    break;
                }
                case ENDER: {
                    this.setIcon("pulse");
                    this.setColor(0x550055);
                    break;
                }
                case FIRE: {
                    this.setIcon("explosion_2");
                    break;
                }
                case ICE: {
                    this.setIcon("ember");
                    this.setColor(0x2299FF);
                    break;
                }
                case LIFE: {
                    this.setIcon("sparkle");
                    this.setColor(0x22FF44);
                    break;
                }
                case LIGHTNING: {
                    this.setIcon("lightning_hand");
                    break;
                }
                case NATURE: {
                    this.setIcon("plant");
                    break;
                }
                case WATER: {
                    this.setIcon("water_ball");
                    break;
                }
                default: {
                    this.setIcon("lens_flare");
                }
            }
        }
        if (SpellUtils.instance.modifierIsPresent(SpellModifiers.COLOR, stack, 0)) {
            ISpellModifier[] mods = SpellUtils.instance.getModifiersForStage(stack, 0);
            int ordinalCount = 0;
            for (ISpellModifier mod : mods) {
                if (!(mod instanceof Colour)) continue;
                byte[] meta = SpellUtils.instance.getModifierMetadataFromStack(stack, mod, 0, ordinalCount++);
                this.setColor((int)mod.getModifier(SpellModifiers.COLOR, null, null, null, meta));
            }
        }
    }

    public int getNumPierces() {
        return this.field_70180_af.func_75679_c(25);
    }

    public void setNumPierces(int pierces) {
        this.field_70180_af.func_75692_b(25, (Object)pierces);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        String name = this.field_70180_af.func_75681_e(24);
        return AMParticleIcons.instance.getIconByName(name);
    }

    public void setIcon(String name) {
        this.field_70180_af.func_75692_b(24, (Object)name);
    }

    public int getColor() {
        return this.field_70180_af.func_75679_c(26);
    }

    private void setColor(int color) {
        this.field_70180_af.func_75692_b(26, (Object)color);
    }

    public boolean func_70112_a(double d) {
        double d1 = this.field_70121_D.func_72320_b() * 4.0;
        return d < (d1 *= 64.0) * d1;
    }

    public boolean func_70067_L() {
        return false;
    }

    public float func_70111_Y() {
        return 0.0f;
    }

    public float func_70053_R() {
        return 0.0f;
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
    }
}

