/*
 * Decompiled with CFR 0.152.
 */
package am2.entities;

import am2.AMCore;
import am2.api.math.AMVector3;
import am2.api.spell.enums.Affinity;
import am2.armor.ArmorHelper;
import am2.items.ItemsCommonProxy;
import am2.particles.AMParticle;
import am2.particles.AMParticleIcons;
import am2.particles.ParticleFadeOut;
import am2.particles.ParticleMoveOnHeading;
import am2.utility.InventoryUtilities;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityAmbientCreature;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class EntityFlicker
extends EntityAmbientCreature {
    private static final int WATCHER_FLICKERTYPE = 20;
    private static final int WATCHER_AMBIENTFLICK = 21;
    private static final int DIRECTION_CHANGE_TIME = 200;
    private AMVector3 targetPosition = null;
    private AMVector3 normalizedMovementVector = AMVector3.zero();
    private int flickCount = 0;

    public EntityFlicker(World par1World) {
        super(par1World);
        this.func_70105_a(0.5f, 0.5f);
        this.setFlickerType(Affinity.values()[par1World.field_73012_v.nextInt(Affinity.values().length - 1)]);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)0);
    }

    public void func_70106_y() {
        AMCore.proxy.decrementFlickerCount();
        super.func_70106_y();
    }

    public void setFlickerType(Affinity affinity) {
        this.field_70180_af.func_75692_b(20, (Object)affinity.ID);
    }

    public Affinity getFlickerAffinity() {
        int flickerType = this.field_70180_af.func_75679_c(20);
        return Affinity.values()[flickerType];
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        this.flick();
        return !par1DamageSource.func_76363_c();
    }

    public boolean func_145773_az() {
        return true;
    }

    protected void func_70069_a(float par1) {
    }

    public boolean func_110164_bC() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70648_aU() {
        return true;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_70020_e(NBTTagCompound par1nbtTagCompound) {
        AMCore.proxy.incrementFlickerCount();
        super.func_70020_e(par1nbtTagCompound);
    }

    public void func_70071_h_() {
        AMParticle effect;
        super.func_70071_h_();
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        long time = this.field_70170_p.func_72820_D() % 24000L;
        if (!this.field_70170_p.field_72995_K && time >= 18500L && time <= 18600L) {
            this.func_70106_y();
            return;
        }
        boolean playerClose = false;
        AMVector3 me = new AMVector3((Entity)this);
        if (!this.field_70170_p.field_72995_K) {
            for (Object o : this.field_70170_p.field_73010_i) {
                AMVector3 aMVector3 = new AMVector3((Entity)((EntityPlayer)o));
                if (!(me.distanceSqTo(aMVector3) < 25.0)) continue;
                ItemStack chestArmor = ((EntityPlayer)o).func_82169_q(2);
                if (chestArmor != null && ArmorHelper.isInfusionPreset(chestArmor, "fl_lure")) break;
                playerClose = true;
                break;
            }
        }
        if (this.field_70173_aa > 100 && playerClose && this.field_70180_af.func_75683_a(21) == 0) {
            if (this.func_70651_bq().size() == 0 || this.func_70651_bq().size() == 1 && this.field_70170_p.field_73012_v.nextDouble() < (double)0.1f) {
                this.field_70180_af.func_75692_b(21, (Object)1);
            }
        } else if (this.field_70180_af.func_75683_a(21) == 1) {
            ++this.flickCount;
            if (this.field_70170_p.field_72995_K && this.flickCount > 7) {
                this.flick();
            } else if (!this.field_70170_p.field_72995_K && this.flickCount > 10) {
                this.flick();
            }
        }
        if (this.field_70170_p.field_72995_K && this.func_70681_au().nextInt(10) < AMCore.config.getGFXLevel() && (effect = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(this.field_70170_p, AMParticleIcons.instance.getParticleForAffinity(this.getFlickerAffinity()), this.field_70165_t, this.field_70163_u, this.field_70161_v))) != null) {
            effect.addRandomOffset(this.field_70130_N, this.field_70131_O, this.field_70130_N);
            effect.setDontRequireControllers();
            effect.setMaxAge(10);
            if (this.getFlickerAffinity() == Affinity.EARTH) {
                effect.setParticleScale(0.01f + this.field_70146_Z.nextFloat() * 0.05f);
            } else {
                effect.setParticleScale(0.05f + this.field_70146_Z.nextFloat() * 0.05f);
            }
        }
    }

    protected void func_70626_be() {
        boolean needsNewPath;
        super.func_70626_be();
        AMVector3 me = new AMVector3((Entity)this);
        boolean bl = needsNewPath = this.targetPosition == null || this.field_70173_aa % 200 == 0;
        if (needsNewPath && this.field_70170_p.field_73012_v.nextDouble() < (double)0.1f) {
            this.pickNewTargetPosition();
        }
        if (this.targetPosition == null) {
            return;
        }
        if (me.distanceSqTo(this.targetPosition) < 1.0) {
            this.targetPosition = null;
            return;
        }
        this.field_70177_z = AMVector3.anglePreNorm(me, this.targetPosition);
        this.normalizedMovementVector = me.copy().sub(this.targetPosition).normalize();
        if (this.normalizedMovementVector.y > 0.0f) {
            this.rotatePitchTowards(-70.0f * this.normalizedMovementVector.y, 30.0f);
        } else {
            this.rotatePitchTowards(0.0f, 30.0f);
        }
        float speed = 0.2f;
        this.func_70024_g(-this.normalizedMovementVector.x * speed, -this.normalizedMovementVector.y * speed, -this.normalizedMovementVector.z * speed);
    }

    public AMVector3 getNormalizedMovement() {
        return this.normalizedMovementVector;
    }

    private void rotatePitchTowards(float p, float step) {
        if (this.field_70125_A != p) {
            if (step > 0.0f && this.field_70125_A + step > p) {
                step = p - this.field_70125_A;
            } else if (step < 0.0f && this.field_70125_A + step < p) {
                step = p - this.field_70125_A;
            }
            this.field_70125_A += step;
        }
    }

    private void flick() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 10 * AMCore.config.getGFXLevel(); ++i) {
                AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(this.field_70170_p, "radiant", this.field_70165_t, this.field_70163_u, this.field_70161_v));
                if (particle == null) continue;
                particle.AddParticleController(new ParticleMoveOnHeading(particle, this.field_70170_p.field_73012_v.nextDouble() * 360.0, this.field_70170_p.field_73012_v.nextDouble() * 360.0, this.field_70170_p.field_73012_v.nextDouble() * (double)0.3f + (double)0.01f, 1, false));
                particle.setRGBColorI(this.getFlickerAffinity().color);
                particle.AddParticleController(new ParticleFadeOut(particle, 1, false).setFadeSpeed((float)(this.field_70170_p.field_73012_v.nextDouble() * 0.1 + 0.05)).setKillParticleOnFinish(true));
                particle.setIgnoreMaxAge(true);
                particle.setParticleScale(0.1f);
            }
        } else {
            this.func_70106_y();
        }
    }

    private void pickNewTargetPosition() {
        int groundLevel = 0;
        block0 : switch (this.getFlickerAffinity()) {
            case WATER: {
                for (int i = 0; i < 5; ++i) {
                    this.targetPosition = new AMVector3(this.field_70165_t - 5.0 + (double)this.field_70170_p.field_73012_v.nextInt(10), this.field_70163_u - 5.0 + (double)this.field_70170_p.field_73012_v.nextInt(10), this.field_70161_v - 5.0 + (double)this.field_70170_p.field_73012_v.nextInt(10));
                    Block block = this.field_70170_p.func_147439_a((int)Math.floor(this.targetPosition.x), (int)Math.floor(this.targetPosition.y), (int)Math.floor(this.targetPosition.z));
                    if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) break block0;
                }
                break;
            }
            case AIR: {
                groundLevel = this.getTopBlockNearMe();
                this.targetPosition = new AMVector3(this.field_70165_t - 5.0 + (double)this.field_70170_p.field_73012_v.nextInt(10), groundLevel + 10 + this.field_70170_p.field_73012_v.nextInt(15), this.field_70161_v - 5.0 + (double)this.field_70170_p.field_73012_v.nextInt(10));
                break;
            }
            case EARTH: {
                groundLevel = this.getTopBlockNearMe();
                this.targetPosition = new AMVector3(this.field_70165_t - 5.0 + (double)this.field_70170_p.field_73012_v.nextInt(10), groundLevel + this.field_70170_p.field_73012_v.nextInt(1) + 1, this.field_70161_v - 5.0 + (double)this.field_70170_p.field_73012_v.nextInt(10));
                break;
            }
            default: {
                groundLevel = this.getTopBlockNearMe();
                this.targetPosition = new AMVector3(this.field_70165_t - 5.0 + (double)this.field_70170_p.field_73012_v.nextInt(10), groundLevel + 3 + this.field_70170_p.field_73012_v.nextInt(5), this.field_70161_v - 5.0 + (double)this.field_70170_p.field_73012_v.nextInt(10));
            }
        }
    }

    private int getTopBlockNearMe() {
        int y;
        int x = (int)Math.floor(this.field_70165_t);
        int z = (int)Math.floor(this.field_70161_v);
        for (y = (int)Math.floor(this.field_70163_u); y > 0 && this.field_70170_p.func_147437_c(x, y, z); --y) {
        }
        while (y < this.field_70170_p.func_72940_L() && !this.field_70170_p.func_147437_c(x, y, z)) {
            ++y;
        }
        return y;
    }

    public void func_70014_b(NBTTagCompound par1nbtTagCompound) {
        super.func_70014_b(par1nbtTagCompound);
        par1nbtTagCompound.func_74768_a("flickerType", this.field_70180_af.func_75679_c(20));
    }

    public void func_70037_a(NBTTagCompound par1nbtTagCompound) {
        super.func_70037_a(par1nbtTagCompound);
        this.field_70180_af.func_75692_b(20, (Object)par1nbtTagCompound.func_74762_e("flickerType"));
        AMCore.proxy.incrementFlickerCount();
    }

    protected boolean func_70085_c(EntityPlayer player) {
        ItemStack stack = player.func_71045_bC();
        if (stack != null && stack.func_77973_b() == ItemsCommonProxy.flickerJar && !this.field_70128_L) {
            if (stack.func_77960_j() == 0) {
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70106_y();
                    InventoryUtilities.decrementStackQuantity((IInventory)player.field_71071_by, player.field_71071_by.field_70461_c, 1);
                    ItemStack newStack = new ItemStack((Item)ItemsCommonProxy.flickerJar);
                    ItemsCommonProxy.flickerJar.setFlickerJarTypeFromFlicker(newStack, this);
                    if (!InventoryUtilities.mergeIntoInventory((IInventory)player.field_71071_by, newStack) && !this.field_70170_p.field_72995_K) {
                        player.func_145779_a(newStack.func_77973_b(), newStack.func_77960_j());
                    }
                }
                return true;
            }
            this.flick();
        }
        return false;
    }

    public boolean func_70601_bi() {
        if (AMCore.proxy.getTotalFlickerCount() > 8 * this.field_70170_p.field_73010_i.size() || this.field_70170_p.field_73012_v.nextDouble() > (double)0.2f) {
            return false;
        }
        BiomeGenBase biome = this.field_70170_p.func_72807_a((int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70161_v));
        if (biome != null) {
            BiomeDictionary.Type[] biomeTags = BiomeDictionary.getTypesForBiome((BiomeGenBase)biome);
            BiomeDictionary.Type tagType = biomeTags[this.field_70170_p.field_73012_v.nextInt(biomeTags.length)];
            ArrayList<Affinity> validAffinities = new ArrayList<Affinity>();
            switch (tagType) {
                case END: {
                    validAffinities.add(Affinity.ENDER);
                    break;
                }
                case FOREST: 
                case CONIFEROUS: 
                case JUNGLE: {
                    validAffinities.add(Affinity.NATURE);
                    break;
                }
                case COLD: 
                case SNOWY: {
                    validAffinities.add(Affinity.ICE);
                    break;
                }
                case MAGICAL: {
                    validAffinities.add(Affinity.ARCANE);
                    break;
                }
                case NETHER: {
                    validAffinities.add(Affinity.FIRE);
                    break;
                }
                case OCEAN: {
                    validAffinities.add(Affinity.LIGHTNING);
                }
                case SWAMP: 
                case WATER: 
                case RIVER: 
                case WET: 
                case BEACH: {
                    validAffinities.add(Affinity.WATER);
                    break;
                }
            }
            if (this.field_70163_u < 55.0) {
                validAffinities.add(Affinity.EARTH);
            }
            if (this.field_70170_p.func_72937_j((int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70163_u), (int)Math.floor(this.field_70161_v))) {
                validAffinities.add(Affinity.AIR);
            }
            if (this.field_70170_p.func_72896_J() && this.field_70170_p.field_73012_v.nextBoolean()) {
                validAffinities.clear();
                validAffinities.add(Affinity.LIGHTNING);
            }
            if (validAffinities.size() <= 0) {
                return false;
            }
            if (this.field_70170_p.field_73012_v.nextDouble() < (double)0.1f) {
                this.setFlickerType(Affinity.LIFE);
            } else {
                this.setFlickerType((Affinity)((Object)validAffinities.get(this.field_70170_p.field_73012_v.nextInt(validAffinities.size()))));
            }
            if (this.field_70170_p.func_72855_b(this.field_70121_D) && this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty()) {
                AMCore.proxy.incrementFlickerCount();
                return true;
            }
        }
        return false;
    }
}

