/*
 * Decompiled with CFR 0.152.
 */
package am2.entities;

import am2.AMCore;
import am2.api.math.AMVector3;
import am2.entities.EntityBroomInventory;
import am2.entities.ai.EntityAIChestDeposit;
import am2.entities.ai.EntityAIPickup;
import am2.entities.ai.EntityAITargetNearbyInanimate;
import am2.items.ItemsCommonProxy;
import am2.particles.AMParticle;
import am2.particles.ParticleFadeOut;
import am2.particles.ParticleFloatUpward;
import am2.utility.InventoryUtilities;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityBroom
extends EntityCreature {
    private EntityBroomInventory inventory = new EntityBroomInventory();
    private AMVector3 chestLocation;
    private float moveCounter = 0.0f;
    private float moveRotation = 0.0f;

    public EntityBroom(World par1World) {
        super(par1World);
        this.initAI();
        this.func_70105_a(0.5f, 0.5f);
        this.field_70138_W = 1.05f;
    }

    public boolean func_145773_az() {
        return true;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70064_a(double par1, boolean par3) {
        if (par3) {
            if (this.field_70143_R > 0.0f) {
                this.func_70069_a(this.field_70143_R);
                this.field_70143_R = 0.0f;
            }
        } else if (par1 < 0.0) {
            this.field_70143_R = (float)((double)this.field_70143_R - par1);
        }
        if (!this.func_70090_H()) {
            this.func_70072_I();
        }
    }

    private void initAI() {
        this.field_70714_bg.field_75782_a.clear();
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIPickup(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIChestDeposit(this));
        this.field_70715_bh.field_75782_a.clear();
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetNearbyInanimate(this, 8.0f, false, EntityItem.class));
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            AMParticle particle;
            this.updateRotations();
            if (this.isMoving() && (particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(this.field_70170_p, "smoke", this.field_70165_t, this.field_70163_u, this.field_70161_v))) != null) {
                particle.addRandomOffset(0.5, 0.5, 0.5);
                particle.setRGBColorF(0.8f, 0.6f, 0.4f);
                particle.AddParticleController(new ParticleFadeOut(particle, 1, false).setFadeSpeed(0.03f).setKillParticleOnFinish(true));
            }
        }
        super.func_70071_h_();
    }

    private void updateRotations() {
        if (this.isMoving()) {
            this.moveCounter += 0.3f;
            this.moveRotation = (float)Math.sin(this.moveCounter) - (float)Math.sin(this.moveCounter - 1.0f);
            if ((int)this.moveCounter % 6 == 0) {
                // empty if block
            }
        } else {
            this.moveCounter = 1.57f;
            if (this.moveRotation > 0.0f) {
                this.moveRotation -= 0.1f;
                if (this.moveRotation < 0.0f) {
                    this.moveRotation = 0.0f;
                }
            } else if (this.moveRotation < 0.0f) {
                this.moveRotation += 0.1f;
                if (this.moveRotation > 0.0f) {
                    this.moveRotation = 0.0f;
                }
            }
        }
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public float getRotation() {
        return this.moveRotation;
    }

    protected boolean func_70650_aV() {
        return true;
    }

    public boolean isInventoryFull() {
        return InventoryUtilities.isInventoryFull(this.inventory);
    }

    public boolean isInventoryEmpty() {
        return InventoryUtilities.isInventoryEmpty(this.inventory);
    }

    public void setChestLocation(AMVector3 chestLoc) {
        this.chestLocation = chestLoc.copy();
    }

    public boolean hasRoomInInventoryFor(ItemStack stack) {
        return InventoryUtilities.inventoryHasRoomFor(this.inventory, stack);
    }

    public void addItemStackToInventory(ItemStack stack) {
        InventoryUtilities.mergeIntoInventory(this.inventory, stack);
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public void func_70109_d(NBTTagCompound nbttagcompound) {
        super.func_70109_d(nbttagcompound);
        this.inventory.saveBroomInventory(nbttagcompound);
        if (this.chestLocation != null) {
            nbttagcompound.func_74783_a("chestLoc", new int[]{(int)this.chestLocation.x, (int)this.chestLocation.y, (int)this.chestLocation.z});
        }
    }

    public boolean isMoving() {
        return this.field_70169_q != this.field_70165_t || this.field_70166_s != this.field_70161_v;
    }

    public void func_70020_e(NBTTagCompound nbttagcompound) {
        super.func_70020_e(nbttagcompound);
        this.inventory.loadBroomInventory(nbttagcompound);
        int[] chestLoc = nbttagcompound.func_74759_k("chestLoc");
        this.chestLocation = chestLoc.length == 3 ? new AMVector3(chestLoc[0], chestLoc[1], chestLoc[2]) : new AMVector3(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    protected boolean func_70085_c(EntityPlayer par1EntityPlayer) {
        if (par1EntityPlayer.func_71045_bC() != null && par1EntityPlayer.func_71045_bC().func_77973_b() == ItemsCommonProxy.spellStaffMagitech) {
            if (this.field_70170_p.field_72995_K) {
                for (int i = 0; i < AMCore.config.getGFXLevel() * 2; ++i) {
                    AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(this.field_70170_p, "smoke", this.field_70165_t, this.field_70163_u, this.field_70161_v));
                    if (particle == null) continue;
                    particle.AddParticleController(new ParticleFloatUpward(particle, 0.1f, 0.3f, 1, false));
                    particle.addRandomOffset(0.3, 1.0, 0.3);
                    particle.setMaxAge(10);
                }
            } else {
                this.func_70099_a(new ItemStack((Item)ItemsCommonProxy.magicBroom), 0.0f);
                this.dropInventoryItems();
                this.func_70106_y();
            }
            return true;
        }
        return false;
    }

    public void func_70645_a(DamageSource par1DamageSource) {
        this.dropInventoryItems();
        super.func_70645_a(par1DamageSource);
    }

    private void dropInventoryItems() {
        EntityBroomInventory inventory = this.getInventory();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null) continue;
            this.func_70099_a(stack, 0.0f);
        }
    }

    public AMVector3 getChestLocation() {
        return this.chestLocation;
    }

    public EntityBroomInventory getInventory() {
        return this.inventory;
    }
}

