/*
 * Decompiled with CFR 0.152.
 */
package am2.commands;

import am2.api.spell.component.interfaces.ISkillTreeEntry;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.component.interfaces.ISpellModifier;
import am2.api.spell.component.interfaces.ISpellPart;
import am2.api.spell.component.interfaces.ISpellShape;
import am2.items.ItemsCommonProxy;
import am2.spell.SkillManager;
import am2.spell.SpellHelper;
import am2.spell.SpellUtils;
import am2.spell.SpellValidator;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerSelector;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ApplyEffect
extends CommandBase {
    public String func_71517_b() {
        return "applyeffect";
    }

    public String func_71518_a(ICommandSender icommandsender) {
        return "/applyeffect [target] [{sg}] [{stage1}] <{stage2}> ... <{stage n}>";
    }

    public int func_82362_a() {
        return 2;
    }

    public void func_71515_b(ICommandSender icommandsender, String[] astring) {
        if (astring.length < 3) {
            throw new WrongUsageException(this.func_71518_a(icommandsender), new Object[0]);
        }
        ArrayList<EntityPlayer> targets = this.getPlayers(icommandsender, astring[0]);
        ItemStack spell = new ItemStack((Item)ItemsCommonProxy.spell);
        EffectDefinitionCollection collection = new EffectDefinitionCollection();
        for (int i = 2; i < astring.length; ++i) {
            EffectDefinition def = new EffectDefinition();
            SpellValidator.ValidationResult result = def.parse(astring[i]);
            if (!result.valid) {
                throw new WrongUsageException(result.message, new Object[0]);
            }
            collection.addEffect(def);
        }
        SpellValidator.ValidationResult finalResult = collection.validate();
        if (!finalResult.valid) {
            throw new WrongUsageException(finalResult.message, new Object[0]);
        }
        collection.writeAllToItemStack(spell);
        for (EntityPlayer player : targets) {
            SpellHelper.instance.applyStackStage(spell, (EntityLivingBase)player, (EntityLivingBase)player, player.field_70165_t, player.field_70163_u, player.field_70161_v, 1, player.field_70170_p, false, false, 0);
        }
    }

    private ArrayList<EntityPlayer> getPlayers(ICommandSender icommandsender, String arg) {
        ArrayList<EntityPlayer> targets = new ArrayList<EntityPlayer>();
        EntityPlayerMP player = ApplyEffect.func_82359_c((ICommandSender)icommandsender, (String)arg);
        if (player == null) {
            EntityPlayerMP[] players = PlayerSelector.func_82380_c((ICommandSender)icommandsender, (String)arg);
            if (players != null) {
                for (EntityPlayerMP p : players) {
                    targets.add((EntityPlayer)p);
                }
            }
        } else {
            targets.add((EntityPlayer)player);
        }
        return targets;
    }

    class EffectDefinition {
        private ISpellShape shape;
        private final ArrayList<ISpellComponent> components = new ArrayList();
        private final ArrayList<ISpellModifier> modifiers = new ArrayList();

        private SpellValidator.ValidationResult parse(String arg) {
            String[] split;
            for (String s : split = arg.toLowerCase().replace("{", "").replace("}", "").split(";")) {
                ISkillTreeEntry skill;
                if ((s = s.toLowerCase()).startsWith("s:")) {
                    if (this.shape != null) {
                        SpellValidator spellValidator = SpellValidator.instance;
                        spellValidator.getClass();
                        return new SpellValidator.ValidationResult(spellValidator, null, String.format("Too many shapes in arg %s", arg));
                    }
                    skill = SkillManager.instance.getSkill(s.replace("s:", ""));
                    if (skill == null || !(skill instanceof ISpellShape)) {
                        SpellValidator spellValidator = SpellValidator.instance;
                        spellValidator.getClass();
                        return new SpellValidator.ValidationResult(spellValidator, null, String.format("Invalid shape identifier: %s", s));
                    }
                    this.shape = (ISpellShape)skill;
                    continue;
                }
                if (s.startsWith("c:")) {
                    skill = SkillManager.instance.getSkill(s.replace("c:", ""));
                    if (skill == null || !(skill instanceof ISpellComponent)) {
                        SpellValidator spellValidator = SpellValidator.instance;
                        spellValidator.getClass();
                        return new SpellValidator.ValidationResult(spellValidator, null, String.format("Invalid component identifier: %s", s));
                    }
                    this.components.add((ISpellComponent)skill);
                    continue;
                }
                if (s.startsWith("m:")) {
                    skill = SkillManager.instance.getSkill(s.replace("m:", ""));
                    if (skill == null || !(skill instanceof ISpellModifier)) {
                        SpellValidator spellValidator = SpellValidator.instance;
                        spellValidator.getClass();
                        return new SpellValidator.ValidationResult(spellValidator, null, String.format("Invalid modifier identifier: %s", s));
                    }
                    this.modifiers.add((ISpellModifier)skill);
                    continue;
                }
                SpellValidator spellValidator = SpellValidator.instance;
                spellValidator.getClass();
                return new SpellValidator.ValidationResult(spellValidator, null, String.format("Syntax Error: %s", s));
            }
            return new SpellValidator.ValidationResult(SpellValidator.instance);
        }

        public ArrayList<ISpellPart> toArray() {
            ArrayList<ISpellPart> definition = new ArrayList<ISpellPart>();
            definition.add(this.shape);
            definition.addAll(this.components);
            definition.addAll(this.modifiers);
            return definition;
        }

        public void writeStageToItemStack(ItemStack stack) {
            SpellUtils.instance.addSpellStageToScroll(stack, this.shape.getID(), this.getComponentList(this.components), (ListMultimap<Integer, byte[]>)this.getModifierList(this.modifiers));
        }

        private int[] getComponentList(ArrayList<ISpellComponent> list) {
            int[] arr = new int[list.size()];
            int count = 0;
            for (ISpellComponent entry : list) {
                arr[count++] = entry.getID() + 1000;
            }
            return arr;
        }

        private ArrayListMultimap<Integer, byte[]> getModifierList(ArrayList<ISpellModifier> list) {
            ArrayListMultimap ret = ArrayListMultimap.create();
            for (ISpellModifier modifier : list) {
                ret.put((Object)(modifier.getID() + 5000), (Object)modifier.getModifierMetadata(0, new ItemStack[0]));
            }
            return ret;
        }
    }

    class EffectDefinitionCollection {
        ArrayList<EffectDefinition> effects = new ArrayList();
        EffectDefinition shapeGroup;

        public void addEffect(EffectDefinition def) {
            this.effects.add(def);
        }

        public void setShapeGroup(EffectDefinition def) {
            this.shapeGroup = def;
        }

        public SpellValidator.ValidationResult validate() {
            ArrayList<ArrayList<ISpellPart>> segmented = new ArrayList<ArrayList<ISpellPart>>();
            for (EffectDefinition def : this.effects) {
                segmented.add(def.toArray());
            }
            ArrayList<ArrayList<ISpellPart>> shapeGroupDef = new ArrayList<ArrayList<ISpellPart>>();
            shapeGroupDef.add(this.shapeGroup.toArray());
            return SpellValidator.instance.spellDefIsValid(shapeGroupDef, segmented);
        }

        public void writeAllToItemStack(ItemStack stack) {
            for (EffectDefinition def : this.effects) {
                def.writeStageToItemStack(stack);
            }
        }
    }
}

