/*
 * Decompiled with CFR 0.152.
 */
package am2.buffs;

import am2.buffs.BuffList;
import am2.utility.KeyValuePair;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.potion.Potion;

public class BuffStatModifiers {
    public static final BuffStatModifiers instance = new BuffStatModifiers();
    private static final UUID furyMoveID = UUID.fromString("03B0A79B-9769-43AE-BFE3-830D993D4A69");
    private static final AttributeModifier furyMoveMod = new AttributeModifier(furyMoveID, "Fury (Movement)", 2.0, 2);
    private static final UUID furyDmgID = UUID.fromString("03B0A79B-9769-43AE-BFE3-830D993D4A70");
    private static final AttributeModifier furyDmgMod = new AttributeModifier(furyDmgID, "Fury (Damage)", 5.0, 2);
    private static final UUID entangledID = UUID.fromString("F5047292-E5F9-4EB1-986E-9A5DFE832203");
    private static final AttributeModifier entangled = new AttributeModifier(entangledID, "Entangled", -10.0, 2);
    private static final UUID hasteID = UUID.fromString("CA4D2B5D-D509-49C0-9B2C-C0A338883AB1");
    private static final AttributeModifier hasteSpeedBoost_Diminished = new AttributeModifier(hasteID, "Haste Speed Boost (Diminished)", 0.3, 2);
    private static final AttributeModifier hasteSpeedBoost_Normal = new AttributeModifier(hasteID, "Haste Speed Boost (Normal)", 0.6, 2);
    private static final AttributeModifier hasteSpeedBoost_Augmented = new AttributeModifier(hasteID, "Haste Speed Boost (Augmented)", 1.2, 2);
    private static final UUID frostSlowID = UUID.fromString("03B0A79B-9569-43AE-BFE3-820D993D4A64");
    private static final AttributeModifier frostSlow_Diminished = new AttributeModifier(frostSlowID, "Frost Slow (Diminished)", -0.2, 2);
    private static final AttributeModifier frostSlow_Normal = new AttributeModifier(frostSlowID, "Frost Slow (Normal)", -0.5, 2);
    private static final AttributeModifier frostSlow_Augmented = new AttributeModifier(frostSlowID, "Frost Slow (Augmented)", -0.8, 2);

    public void applyStatModifiersBasedOnBuffs(EntityLivingBase entity) {
        this.applyOrRemoveModifiersForBuff(entity, BuffList.entangled.field_76415_H, new KeyValuePair<IAttribute, AttributeModifier>(SharedMonsterAttributes.field_111263_d, entangled));
        this.applyOrRemoveModifiersForBuff(entity, BuffList.frostSlowed.field_76415_H, 0, new KeyValuePair<IAttribute, AttributeModifier>(SharedMonsterAttributes.field_111263_d, frostSlow_Diminished));
        this.applyOrRemoveModifiersForBuff(entity, BuffList.frostSlowed.field_76415_H, 1, new KeyValuePair<IAttribute, AttributeModifier>(SharedMonsterAttributes.field_111263_d, frostSlow_Normal));
        this.applyOrRemoveModifiersForBuff(entity, BuffList.frostSlowed.field_76415_H, 2, new KeyValuePair<IAttribute, AttributeModifier>(SharedMonsterAttributes.field_111263_d, frostSlow_Augmented));
        this.applyOrRemoveModifiersForBuff(entity, BuffList.fury.field_76415_H, new KeyValuePair<IAttribute, AttributeModifier>(SharedMonsterAttributes.field_111263_d, furyMoveMod), new KeyValuePair<IAttribute, AttributeModifier>(SharedMonsterAttributes.field_111264_e, furyDmgMod));
        this.applyOrRemoveModifiersForBuff(entity, BuffList.haste.field_76415_H, 0, new KeyValuePair<IAttribute, AttributeModifier>(SharedMonsterAttributes.field_111263_d, hasteSpeedBoost_Diminished));
        this.applyOrRemoveModifiersForBuff(entity, BuffList.haste.field_76415_H, 1, new KeyValuePair<IAttribute, AttributeModifier>(SharedMonsterAttributes.field_111263_d, hasteSpeedBoost_Normal));
        this.applyOrRemoveModifiersForBuff(entity, BuffList.haste.field_76415_H, 2, new KeyValuePair<IAttribute, AttributeModifier>(SharedMonsterAttributes.field_111263_d, hasteSpeedBoost_Augmented));
    }

    private void applyOrRemoveModifiersForBuff(EntityLivingBase entity, int buffID, KeyValuePair<IAttribute, AttributeModifier> ... modifiers) {
        if (entity.func_82165_m(buffID)) {
            this.applyAllModifiers(entity, modifiers);
        } else {
            this.clearAllModifiers(entity, modifiers);
        }
    }

    private void applyOrRemoveModifiersForBuff(EntityLivingBase entity, int buffID, int magnitude, KeyValuePair<IAttribute, AttributeModifier> ... modifiers) {
        if (entity.func_82165_m(buffID)) {
            if (entity.func_70660_b(Potion.field_76425_a[buffID]).func_76458_c() == magnitude) {
                this.applyAllModifiers(entity, modifiers);
            }
        } else {
            this.clearAllModifiers(entity, modifiers);
        }
    }

    private void applyAllModifiers(EntityLivingBase entity, KeyValuePair<IAttribute, AttributeModifier> ... modifiers) {
        for (KeyValuePair<IAttribute, AttributeModifier> entry : modifiers) {
            IAttributeInstance inst = entity.func_110148_a(entry.getKey());
            if (inst == null || inst.func_111127_a(entry.getValue().func_111167_a()) != null) continue;
            inst.func_111121_a(entry.getValue());
        }
    }

    private void clearAllModifiers(EntityLivingBase entity, KeyValuePair<IAttribute, AttributeModifier> ... modifiers) {
        for (KeyValuePair<IAttribute, AttributeModifier> entry : modifiers) {
            IAttributeInstance inst = entity.func_110148_a(entry.getKey());
            if (inst == null) continue;
            inst.func_111124_b(entry.getValue());
        }
    }
}

