/*
 * Decompiled with CFR 0.152.
 */
package am2.bosses;

import am2.AMCore;
import am2.bosses.AM2Boss;
import am2.bosses.BossActions;
import am2.bosses.ai.EntityAICastSpell;
import am2.bosses.ai.EntityAISmash;
import am2.bosses.ai.EntityAIStrikeAttack;
import am2.bosses.ai.EntityWinterGuardianLaunchArm;
import am2.bosses.ai.ISpellCastCallback;
import am2.buffs.BuffEffectFrostSlowed;
import am2.damage.DamageSourceFire;
import am2.damage.DamageSourceFrost;
import am2.damage.DamageSources;
import am2.items.ItemsCommonProxy;
import am2.network.AMNetHandler;
import am2.particles.AMParticle;
import am2.particles.ParticleApproachEntity;
import am2.particles.ParticleFleeEntity;
import am2.particles.ParticleFloatUpward;
import am2.particles.ParticleOrbitEntity;
import am2.utility.NPCSpells;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityWinterGuardian
extends AM2Boss {
    private boolean hasRightArm;
    private boolean hasLeftArm;
    private float orbitRotation;

    public EntityWinterGuardian(World par1World) {
        super(par1World);
        this.func_70105_a(1.0f, 2.0f);
        this.hasRightArm = true;
        this.hasLeftArm = true;
    }

    @Override
    protected void initSpecificAI() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAICastSpell(this, NPCSpells.instance.dispel, 16, 23, 50, BossActions.CASTING, new ISpellCastCallback<EntityWinterGuardian>(){

            @Override
            public boolean shouldCast(EntityWinterGuardian host, ItemStack spell) {
                return host.func_70651_bq().size() > 0;
            }
        }));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAISmash(this, 0.5f, DamageSources.DamageSourceTypes.FROST));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIStrikeAttack(this, 0.5f, 6.0f, DamageSources.DamageSourceTypes.FROST));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityWinterGuardianLaunchArm(this, 0.5f));
    }

    public void returnOneArm() {
        if (!this.hasLeftArm) {
            this.hasLeftArm = true;
        } else if (!this.hasRightArm) {
            this.hasRightArm = true;
        }
    }

    public void launchOneArm() {
        if (this.hasLeftArm) {
            this.hasLeftArm = false;
        } else if (this.hasRightArm) {
            this.hasRightArm = false;
        }
    }

    public boolean hasLeftArm() {
        return this.hasLeftArm;
    }

    public boolean hasRightArm() {
        return this.hasRightArm;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(290.0);
    }

    public int func_70658_aO() {
        return 23;
    }

    @Override
    public void func_70071_h_() {
        if (this.field_70170_p.func_72807_a((int)this.field_70165_t, (int)this.field_70161_v).func_76746_c() && this.field_70170_p.func_72912_H().func_76059_o()) {
            if (this.field_70170_p.field_72995_K) {
                AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(this.field_70170_p, "ember", this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 6.0f - 3.0f), this.field_70163_u + 2.0 + (double)(this.field_70146_Z.nextFloat() * 2.0f - 1.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 6.0f - 3.0f)));
                if (particle != null) {
                    particle.AddParticleController(new ParticleApproachEntity(particle, (Entity)this, 0.15f, 0.1, 1, false));
                    particle.setIgnoreMaxAge(false);
                    particle.setMaxAge(30);
                    particle.setParticleScale(0.35f);
                    particle.setRGBColorF(0.7843f, 0.5098f, 0.5098f);
                }
            } else {
                this.func_70691_i(0.1f);
            }
        }
        if (this.field_70170_p.field_72995_K) {
            this.updateRotations();
            this.spawnParticles();
        } else if (this.field_70173_aa % 100 == 0) {
            List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.field_70121_D.func_72314_b(2.0, 2.0, 2.0));
            for (EntityLivingBase entity : entities) {
                if (entity == this) continue;
                entity.func_70690_d((PotionEffect)new BuffEffectFrostSlowed(220, 1));
                entity.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, 220, 3));
            }
        }
        super.func_70071_h_();
    }

    @Override
    public void setCurrentAction(BossActions action) {
        super.setCurrentAction(action);
        if (!this.field_70170_p.field_72995_K) {
            AMNetHandler.INSTANCE.sendActionUpdateToAllAround(this);
        }
    }

    private void updateRotations() {
        this.orbitRotation += 2.0f;
        this.orbitRotation %= 360.0f;
    }

    private void spawnParticles() {
        for (int i = 0; i < AMCore.config.getGFXLevel() * 4; ++i) {
            int rnd = this.field_70146_Z.nextInt(10);
            AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(this.field_70170_p, rnd < 5 ? "snowflakes" : "ember", this.field_70165_t + ((double)this.field_70146_Z.nextFloat() * 0.4 - 0.2), this.field_70163_u + 2.0, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() * 0.4 - 0.2)));
            if (particle == null) continue;
            if (rnd < 2 || rnd > 8) {
                particle.AddParticleController(new ParticleOrbitEntity(particle, (Entity)this, 0.2f, 1, false));
            } else {
                particle.AddParticleController(new ParticleFloatUpward(particle, 0.5f, -0.2f, 1, false));
                particle.AddParticleController(new ParticleFleeEntity(particle, (Entity)this, 0.06f, 2.0, 2, false).setKillParticleOnFinish(true));
            }
            particle.setIgnoreMaxAge(false);
            particle.setMaxAge(30);
            particle.setParticleScale(rnd < 5 ? 0.15f : 0.35f);
            particle.setRGBColorF(0.5098f, 0.7843f, 0.7843f);
        }
    }

    public float getOrbitRotation() {
        return this.orbitRotation;
    }

    protected void func_70628_a(boolean par1, int par2) {
        if (par1) {
            this.func_70099_a(new ItemStack((Item)ItemsCommonProxy.rune, 1, 19), 0.0f);
        }
        int i = this.field_70146_Z.nextInt(4);
        for (int j = 0; j < i; ++j) {
            this.func_70099_a(new ItemStack((Item)ItemsCommonProxy.essence, 1, 6), 0.0f);
        }
        i = this.field_70146_Z.nextInt(10);
        if (i < 3) {
            this.func_70099_a(ItemsCommonProxy.winterArmEnchanted.func_77946_l(), 0.0f);
        }
    }

    @Override
    protected float modifyDamageAmount(DamageSource source, float damageAmt) {
        if (source instanceof DamageSourceFrost) {
            damageAmt = 0.0f;
        }
        if (source.func_76347_k() || source instanceof DamageSourceFire) {
            damageAmt *= 2.0f;
        }
        return damageAmt;
    }

    protected String func_70621_aR() {
        return "arsmagica2:mob.winterguardian.hit";
    }

    protected String func_70673_aS() {
        return "arsmagica2:mob.winterguardian.death";
    }

    protected String func_70639_aQ() {
        return "arsmagica2:mob.winterguardian.idle";
    }

    @Override
    public String getAttackSound() {
        return "arsmagica2:mob.winterguardian.attack";
    }
}

