/*
 * Decompiled with CFR 0.152.
 */
package am2.bosses;

import am2.AMCore;
import am2.bosses.AM2Boss;
import am2.bosses.BossActions;
import am2.bosses.ai.EntityAICastSpell;
import am2.bosses.ai.EntityAIDispel;
import am2.bosses.ai.EntityAILightningBolt;
import am2.bosses.ai.EntityAILightningRod;
import am2.bosses.ai.EntityAIStatic;
import am2.items.ItemsCommonProxy;
import am2.particles.AMParticle;
import am2.particles.ParticleHoldPosition;
import am2.playerextensions.ExtendedProperties;
import am2.utility.NPCSpells;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import thehippomaster.AnimationAPI.IAnimatedEntity;

public class EntityLightningGuardian
extends AM2Boss
implements IAnimatedEntity {
    public EntityLightningGuardian(World par1World) {
        super(par1World);
        this.func_70105_a(1.0f, 2.0f);
    }

    public float func_70047_e() {
        return 2.0f;
    }

    @Override
    protected void initSpecificAI() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIDispel(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAILightningRod(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIStatic(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAICastSpell(this, NPCSpells.instance.lightningRune, 22, 27, 200, BossActions.CASTING));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAICastSpell(this, NPCSpells.instance.scrambleSynapses, 45, 60, 300, BossActions.SMASH));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILightningBolt(this));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(250.0);
    }

    public void func_70645_a(DamageSource par1DamageSource) {
        if (this.func_70638_az() != null) {
            ExtendedProperties.For(this.func_70638_az()).setDisableGravity(false);
        }
        super.func_70645_a(par1DamageSource);
    }

    public int func_70658_aO() {
        return 18;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70638_az() != null) {
            if (this.getCurrentAction() != BossActions.LONG_CASTING) {
                ExtendedProperties.For(this.func_70638_az()).setDisableGravity(false);
            }
            if (!this.field_70170_p.field_72995_K && this.func_70068_e((Entity)this.func_70638_az()) > 64.0 && this.getCurrentAction() == BossActions.IDLE) {
                this.func_70661_as().func_75497_a((Entity)this.func_70638_az(), 0.5);
            }
        }
        if (this.field_70170_p.field_72995_K) {
            int halfDist = 8;
            int dist = 16;
            if (this.getCurrentAction() == BossActions.CHARGE) {
                if (this.ticksInCurrentAction > 50) {
                    for (int i = 0; i < 2 * AMCore.config.getGFXLevel(); ++i) {
                        AMParticle smoke = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(this.field_70170_p, "smoke", this.field_70165_t, this.field_70163_u + 4.0, this.field_70161_v));
                        if (smoke == null) continue;
                        smoke.addRandomOffset(halfDist, 1.0, halfDist);
                        smoke.SetParticleAlpha(1.0f);
                        smoke.setParticleScale(1.0f);
                        smoke.setMaxAge(20);
                        smoke.AddParticleController(new ParticleHoldPosition(smoke, 10, 1, false));
                    }
                }
                if (this.ticksInCurrentAction > 66) {
                    AMCore.proxy.particleManager.BoltFromPointToPoint(this.field_70170_p, this.field_70165_t + this.field_70146_Z.nextDouble() - 0.5, this.field_70163_u + this.field_70146_Z.nextDouble() - 0.5 + 2.0, this.field_70161_v + this.field_70146_Z.nextDouble() - 0.5, this.field_70165_t + this.field_70146_Z.nextDouble() * (double)dist - (double)halfDist, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)dist - (double)halfDist, this.field_70161_v + this.field_70146_Z.nextDouble() * (double)dist - (double)halfDist);
                }
            } else if (this.getCurrentAction() == BossActions.LONG_CASTING && this.ticksInCurrentAction > 25 && this.ticksInCurrentAction < 150) {
                for (int i = 0; i < 2 * AMCore.config.getGFXLevel(); ++i) {
                    AMParticle smoke = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(this.field_70170_p, "smoke", this.field_70165_t, this.field_70163_u + 4.0, this.field_70161_v));
                    if (smoke == null) continue;
                    smoke.addRandomOffset(halfDist, 1.0, halfDist);
                    smoke.SetParticleAlpha(1.0f);
                    smoke.setParticleScale(1.0f);
                    smoke.setRGBColorI(this.ticksInCurrentAction < 85 ? 0xFFFFFF - 0x111111 * ((this.ticksInCurrentAction - 25) / 4) : 0x222222);
                    smoke.setMaxAge(20);
                    smoke.AddParticleController(new ParticleHoldPosition(smoke, 10, 1, false));
                }
            }
        }
    }

    @Override
    protected float modifyDamageAmount(DamageSource source, float damageAmt) {
        if (source.func_82725_o() || source.field_76373_n.equals("magic")) {
            damageAmt *= 2.0f;
        }
        if (source.field_76373_n.equals("drown")) {
            damageAmt *= 4.0f;
        }
        if (source.field_76373_n.equals("DamageAMLightning")) {
            damageAmt *= -1.0f;
        }
        return damageAmt;
    }

    protected String func_70621_aR() {
        return "arsmagica2:mob.lightningguardian.hit";
    }

    protected String func_70673_aS() {
        return "arsmagica2:mob.lightningguardian.death";
    }

    protected String func_70639_aQ() {
        return "arsmagica2:mob.lightningguardian.idle";
    }

    @Override
    public String getAttackSound() {
        return "arsmagica2:mob.lightningguardian.attack_static";
    }

    protected void func_70628_a(boolean par1, int par2) {
        if (par1) {
            this.func_70099_a(new ItemStack((Item)ItemsCommonProxy.rune, 1, 18), 0.0f);
        }
        int i = this.field_70146_Z.nextInt(4);
        for (int j = 0; j < i; ++j) {
            this.func_70099_a(new ItemStack((Item)ItemsCommonProxy.essence, 1, 7), 0.0f);
        }
        i = this.field_70146_Z.nextInt(10);
        if (i < 3 && par1) {
            this.func_70099_a(ItemsCommonProxy.lightningCharmEnchanted.func_77946_l(), 0.0f);
        }
    }

    public void setAnimID(int id) {
        this.setCurrentAction(BossActions.values()[id]);
    }

    public void setAnimTick(int tick) {
        this.ticksInCurrentAction = tick;
    }

    public int getAnimID() {
        return this.currentAction.ordinal();
    }

    public int getAnimTick() {
        return this.ticksInCurrentAction;
    }
}

