/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentities.flickers;

import am2.api.flickers.IFlickerController;
import am2.api.flickers.IFlickerFunctionality;
import am2.api.spell.enums.Affinity;
import am2.items.ItemsCommonProxy;
import am2.utility.InventoryUtilities;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class FlickerOperatorPackedEarth
implements IFlickerFunctionality {
    @Override
    public boolean RequiresPower() {
        return false;
    }

    @Override
    public int PowerPerOperation() {
        return 10;
    }

    @Override
    public boolean DoOperation(World worldObj, IFlickerController habitat, boolean powered) {
        int searchesPerLoop = 12;
        int radius = 6;
        int diameter = radius * 2 + 1;
        if (!worldObj.field_72995_K) {
            boolean actionPerformed = false;
            for (int i = 0; i < searchesPerLoop && !actionPerformed; ++i) {
                int inventoryIndex;
                TileEntity te = worldObj.func_147438_o(((TileEntity)habitat).field_145851_c, ((TileEntity)habitat).field_145848_d - 1, ((TileEntity)habitat).field_145849_e);
                if (te == null || !(te instanceof IInventory)) {
                    return false;
                }
                int effectX = ((TileEntity)habitat).field_145851_c - radius + worldObj.field_73012_v.nextInt(diameter);
                int effectZ = ((TileEntity)habitat).field_145849_e - radius + worldObj.field_73012_v.nextInt(diameter);
                int effectY = ((TileEntity)habitat).field_145848_d - 1 - worldObj.field_73012_v.nextInt(radius);
                if (effectY < 3) {
                    effectY = 3;
                }
                Block block = worldObj.func_147439_a(effectX, effectY, effectZ);
                if (!worldObj.func_147437_c(effectX, effectY, effectZ) && !block.isReplaceable((IBlockAccess)worldObj, effectX, effectY, effectZ) || (inventoryIndex = InventoryUtilities.getFirstBlockInInventory((IInventory)te)) <= -1) continue;
                ItemStack stack = ((IInventory)te).func_70301_a(inventoryIndex);
                InventoryUtilities.decrementStackQuantity((IInventory)te, inventoryIndex, 1);
                worldObj.func_147465_d(effectX, effectY, effectZ, Block.func_149634_a((Item)stack.func_77973_b()), stack.func_77960_j(), 2);
                actionPerformed = true;
            }
        }
        return true;
    }

    @Override
    public boolean DoOperation(World worldObj, IFlickerController controller, boolean powered, Affinity[] flickers) {
        return this.DoOperation(worldObj, controller, powered);
    }

    @Override
    public void RemoveOperator(World worldObj, IFlickerController controller, boolean powered) {
    }

    @Override
    public int TimeBetweenOperation(boolean powered, Affinity[] flickers) {
        return powered ? 1 : 20;
    }

    @Override
    public void RemoveOperator(World worldObj, IFlickerController controller, boolean powered, Affinity[] flickers) {
    }

    @Override
    public Object[] getRecipe() {
        Object[] objectArray = new Object[11];
        objectArray[0] = "DDD";
        objectArray[1] = "RFR";
        objectArray[2] = " E ";
        objectArray[3] = Character.valueOf('D');
        objectArray[4] = Blocks.field_150346_d;
        objectArray[5] = Character.valueOf('R');
        objectArray[6] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 0);
        objectArray[7] = Character.valueOf('E');
        objectArray[8] = new ItemStack((Item)ItemsCommonProxy.essence, 1, 1);
        objectArray[9] = Character.valueOf('F');
        objectArray[10] = new ItemStack((Item)ItemsCommonProxy.flickerJar, 1, Affinity.EARTH.ordinal());
        return objectArray;
    }
}

