/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentities;

import am2.AMCore;
import am2.api.math.AMVector3;
import am2.items.ItemsCommonProxy;
import am2.network.AMDataWriter;
import am2.network.AMNetHandler;
import am2.particles.AMParticle;
import am2.particles.AMParticleIcons;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public class TileEntityParticleEmitter
extends TileEntity {
    private int particleType = 0;
    private int particleQuantity = 1;
    private int spawnRate = 5;
    private int particleBehaviour = 0;
    private int particleColor = 0;
    private float particleScale = 0.5f;
    private float particleAlpha = 1.0f;
    private boolean defaultColor = true;
    private boolean randomColor = false;
    private boolean show = true;
    private float speed;
    private boolean hasReceivedFullUpdate = false;
    private int fullUpdateDelayTicks;
    private int updateCounter = 0;
    private int spawnTicks = 0;
    private int showTicks = 0;
    boolean forceShow = false;
    private Random random = new Random();

    public TileEntityParticleEmitter() {
        this.fullUpdateDelayTicks = this.random.nextInt(40);
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K && this.spawnTicks++ >= this.spawnRate) {
            for (int i = 0; i < this.particleQuantity; ++i) {
                this.doSpawn();
            }
            this.spawnTicks = 0;
        }
        if (!this.show && this.field_145850_b.field_72995_K && (this.forceShow && this.showTicks++ > 100 || !this.forceShow)) {
            AMVector3 playerLoc;
            AMVector3 myLoc;
            this.showTicks = 0;
            this.forceShow = false;
            EntityPlayer localPlayer = AMCore.proxy.getLocalPlayer();
            if (localPlayer != null && localPlayer.field_71071_by.func_70448_g() != null && localPlayer.field_71071_by.func_70448_g().func_77973_b() == ItemsCommonProxy.crystalWrench && (myLoc = new AMVector3(this.field_145851_c, this.field_145848_d, this.field_145849_e)).distanceSqTo(playerLoc = new AMVector3((Entity)localPlayer)) < 64.0) {
                this.forceShow = true;
            }
            int oldMeta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (this.forceShow) {
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, oldMeta & 0xFFFFFFF7, 2);
            } else {
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, oldMeta | 8, 2);
            }
        }
    }

    private void doSpawn() {
        double z;
        double y;
        if (!this.hasReceivedFullUpdate) {
            return;
        }
        double x = this.randomzieCoord((double)this.field_145851_c + 0.5);
        AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(this.field_145850_b, AMParticle.particleTypes[this.particleType], x, y = this.randomzieCoord((double)this.field_145848_d + 0.5), z = this.randomzieCoord((double)this.field_145849_e + 0.5)));
        if (particle != null) {
            particle.AddParticleController(AMCore.proxy.particleManager.createDefaultParticleController(this.particleBehaviour, (Object)particle, new AMVector3(x, y, z), this.speed, this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e)));
            particle.setParticleAge(Math.min(Math.max(this.spawnRate, 10), 40));
            particle.setIgnoreMaxAge(false);
            particle.setParticleScale(this.particleScale);
            particle.SetParticleAlpha(this.particleAlpha);
            if (!this.defaultColor) {
                if (!this.randomColor) {
                    particle.setRGBColorF((float)(this.particleColor >> 16 & 0xFF) / 255.0f, (float)(this.particleColor >> 8 & 0xFF) / 255.0f, (float)(this.particleColor & 0xFF) / 255.0f);
                } else {
                    particle.setRGBColorF(this.random.nextFloat(), this.random.nextFloat(), this.random.nextFloat());
                }
            }
        }
    }

    private double randomzieCoord(double base) {
        return base + this.random.nextDouble() - 0.5;
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_145841_b(compound);
        S35PacketUpdateTileEntity packet = new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e), compound);
        return packet;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.applyParamConstraints();
        this.hasReceivedFullUpdate = true;
    }

    private void applyParamConstraints() {
        if (this.spawnRate < 1) {
            this.spawnRate = 1;
        }
        if (this.particleQuantity < 1) {
            this.particleQuantity = 1;
        }
        if (this.particleQuantity > 5) {
            this.particleQuantity = 5;
        }
        if (this.particleType < 0) {
            this.particleType = 0;
        }
        if (this.particleType > AMParticleIcons.instance.numParticles()) {
            this.particleType = AMParticleIcons.instance.numParticles() - 1;
        }
        if (this.particleBehaviour < 0) {
            this.particleBehaviour = 0;
        }
        if (this.particleBehaviour > 6) {
            this.particleBehaviour = 6;
        }
        if (this.particleScale < 0.0f) {
            this.particleScale = 0.0f;
        }
        if (this.particleScale > 1.0f) {
            this.particleScale = 1.0f;
        }
        if (this.particleAlpha < 0.0f) {
            this.particleAlpha = 0.0f;
        }
        if (this.particleAlpha > 1.0f) {
            this.particleAlpha = 1.0f;
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readSettingsFromNBT(compound);
    }

    public void readSettingsFromNBT(NBTTagCompound compound) {
        this.particleType = compound.func_74762_e("particleType");
        this.particleQuantity = compound.func_74762_e("particleQuantity");
        this.spawnRate = compound.func_74762_e("spawnRate");
        this.particleBehaviour = compound.func_74762_e("particleBehaviour");
        this.particleColor = compound.func_74762_e("particleColor");
        this.particleScale = compound.func_74760_g("particleScale");
        this.particleAlpha = compound.func_74760_g("particleAlpha");
        this.defaultColor = compound.func_74767_n("defaultColor");
        this.randomColor = compound.func_74767_n("randomColor");
        this.show = compound.func_74767_n("show");
        this.speed = compound.func_74760_g("speed");
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        this.writeSettingsToNBT(compound);
    }

    public void writeSettingsToNBT(NBTTagCompound compound) {
        compound.func_74768_a("particleType", this.particleType);
        compound.func_74768_a("particleQuantity", this.particleQuantity);
        compound.func_74768_a("spawnRate", this.spawnRate);
        compound.func_74768_a("particleBehaviour", this.particleBehaviour);
        compound.func_74768_a("particleColor", this.particleColor);
        compound.func_74776_a("particleScale", this.particleScale);
        compound.func_74776_a("particleAlpha", this.particleAlpha);
        compound.func_74757_a("defaultColor", this.defaultColor);
        compound.func_74757_a("randomColor", this.randomColor);
        compound.func_74757_a("show", this.show);
        compound.func_74776_a("speed", this.speed);
    }

    public void setParticleType(int particleType) {
        this.particleType = particleType;
    }

    public void setParticleBehaviour(int particleBehaviour) {
        this.particleBehaviour = particleBehaviour;
    }

    public void setColorDefault(boolean def) {
        this.defaultColor = def;
    }

    public void setColorRandom(boolean rand) {
        this.randomColor = rand;
    }

    public void setColor(int color) {
        this.particleColor = color;
    }

    public void setScale(float scale) {
        this.particleScale = scale;
    }

    public void setAlpha(float alpha) {
        this.particleAlpha = alpha;
    }

    public void setShow(boolean show) {
        this.show = show;
        if (this.field_145850_b.field_72995_K && show) {
            AMVector3 playerLoc;
            AMVector3 myLoc;
            this.forceShow = false;
            this.showTicks = 0;
            EntityPlayer localPlayer = AMCore.proxy.getLocalPlayer();
            if (localPlayer != null && localPlayer.field_71071_by.func_70448_g() != null && localPlayer.field_71071_by.func_70448_g().func_77973_b() == ItemsCommonProxy.crystalWrench && (myLoc = new AMVector3(this.field_145851_c, this.field_145848_d, this.field_145849_e)).distanceSqTo(playerLoc = new AMVector3((Entity)localPlayer)) < 64.0) {
                this.forceShow = true;
            }
        }
        int oldMeta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, show ? oldMeta & 0xFFFFFFF7 : oldMeta | 8, 2);
    }

    public int getParticleType() {
        return this.particleType;
    }

    public int getParticleBehaviour() {
        return this.particleBehaviour;
    }

    public boolean getColorDefault() {
        return this.defaultColor;
    }

    public boolean getColorRandom() {
        return this.randomColor;
    }

    public int getColor() {
        return this.particleColor;
    }

    public float getScale() {
        return this.particleScale;
    }

    public float getAlpha() {
        return this.particleAlpha;
    }

    public boolean getShow() {
        return this.show;
    }

    public void setQuantity(int quantity) {
        this.particleQuantity = quantity;
    }

    public int getQuantity() {
        return this.particleQuantity;
    }

    public void setDelay(int delay) {
        this.spawnRate = delay;
        this.spawnTicks = 0;
    }

    public int getDelay() {
        return this.spawnRate;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void syncWithServer() {
        if (this.field_145850_b.field_72995_K) {
            AMDataWriter writer = new AMDataWriter();
            writer.add(this.field_145851_c);
            writer.add(this.field_145848_d);
            writer.add(this.field_145849_e);
            NBTTagCompound compound = new NBTTagCompound();
            this.func_145841_b(compound);
            writer.add(compound);
            byte[] data = writer.generate();
            AMNetHandler.INSTANCE.sendPacketToServer((byte)35, data);
        }
    }
}

