/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentities;

import am2.AMCore;
import am2.api.blocks.IKeystoneLockable;
import am2.api.power.PowerTypes;
import am2.blocks.tileentities.TileEntityAMPower;
import am2.items.ItemFocusCharge;
import am2.items.ItemFocusMana;
import am2.items.ItemsCommonProxy;
import am2.network.AMDataReader;
import am2.network.AMDataWriter;
import am2.network.AMNetHandler;
import am2.particles.AMParticle;
import am2.particles.ParticleFloatUpward;
import am2.power.PowerNodeRegistry;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;

public class TileEntityCalefactor
extends TileEntityAMPower
implements IInventory,
ISidedInventory,
IKeystoneLockable {
    private ItemStack[] calefactorItemStacks;
    private float rotationX;
    private float rotationY;
    private float rotationZ;
    private final float rotationStepX;
    private final float rotationStepY;
    private final float rotationStepZ;
    private final short baseCookTime = (short)220;
    private short timeSpentCooking = 0;
    private final float basePowerConsumedPerTickCooking = 0.85f;
    private int particleCount = 0;
    private boolean isCooking;
    private static final byte PKT_PRG_UPDATE = 1;

    public TileEntityCalefactor() {
        super(100);
        Random rand = new Random();
        this.calefactorItemStacks = new ItemStack[this.func_70302_i_()];
        this.rotationStepX = rand.nextFloat() * 0.03f - 0.015f;
        this.rotationStepY = rand.nextFloat() * 0.03f - 0.015f;
        this.rotationStepZ = rand.nextFloat() * 0.03f - 0.015f;
        this.isCooking = false;
    }

    @Override
    public float particleOffset(int axis) {
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (axis == 0) {
            switch (meta) {
                case 6: {
                    return 0.25f;
                }
                case 5: {
                    return 0.75f;
                }
            }
            return 0.5f;
        }
        if (axis == 1) {
            switch (meta) {
                case 1: {
                    return 0.75f;
                }
                case 2: {
                    return 0.25f;
                }
            }
            return 0.5f;
        }
        if (axis == 2) {
            switch (meta) {
                case 4: {
                    return 0.25f;
                }
                case 3: {
                    return 0.75f;
                }
            }
            return 0.5f;
        }
        return 0.5f;
    }

    public void incrementRotations() {
        this.rotationX += this.rotationStepX;
        this.rotationY += this.rotationStepX;
        this.rotationZ += this.rotationStepX;
        if (this.rotationX > 359.0f) {
            this.rotationX -= 360.0f;
        }
        if (this.rotationY > 359.0f) {
            this.rotationY -= 360.0f;
        }
        if (this.rotationZ > 359.0f) {
            this.rotationZ -= 360.0f;
        }
        if (this.rotationX < 0.0f) {
            this.rotationX += 360.0f;
        }
        if (this.rotationY < 0.0f) {
            this.rotationY += 360.0f;
        }
        if (this.rotationZ < 0.0f) {
            this.rotationZ += 360.0f;
        }
    }

    public float getRotationX() {
        return this.rotationX;
    }

    public float getRotationY() {
        return this.rotationX;
    }

    public float getRotationZ() {
        return this.rotationX;
    }

    public ItemStack getItemBeingCooked() {
        if (this.calefactorItemStacks[0] != null) {
            return this.calefactorItemStacks[0];
        }
        return null;
    }

    private boolean canSmelt() {
        if (this.calefactorItemStacks[0] == null) {
            return false;
        }
        ItemStack var1 = FurnaceRecipes.func_77602_a().func_151395_a(this.calefactorItemStacks[0]);
        if (var1 == null) {
            return false;
        }
        if (this.calefactorItemStacks[1] == null) {
            return true;
        }
        if (!this.calefactorItemStacks[1].func_77969_a(var1)) {
            return false;
        }
        int result = this.calefactorItemStacks[1].field_77994_a + var1.field_77994_a;
        return result <= this.func_70297_j_() && result <= var1.func_77976_d();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            boolean doSmelt;
            ItemStack var1 = FurnaceRecipes.func_77602_a().func_151395_a(this.calefactorItemStacks[0]);
            ItemStack smeltStack = var1.func_77946_l();
            if ((this.calefactorItemStacks[0].func_77973_b() instanceof ItemFood || this.calefactorItemStacks[0].func_77973_b() instanceof ItemBlock || this.calefactorItemStacks[0].func_77973_b() == ItemsCommonProxy.itemOre) && PowerNodeRegistry.For(this.field_145850_b).checkPower(this, PowerTypes.DARK, this.getCookTickPowerCost()) && PowerNodeRegistry.For(this.field_145850_b).checkPower(this, PowerTypes.NEUTRAL, this.getCookTickPowerCost()) && PowerNodeRegistry.For(this.field_145850_b).checkPower(this, PowerTypes.LIGHT, this.getCookTickPowerCost())) {
                ++smeltStack.field_77994_a;
            }
            if (this.calefactorItemStacks[0].func_77973_b() instanceof ItemFood && smeltStack.field_77994_a == var1.field_77994_a && this.field_145850_b.field_73012_v.nextDouble() < (double)0.15f) {
                ++smeltStack.field_77994_a;
            }
            if (doSmelt = true) {
                if (this.calefactorItemStacks[1] == null) {
                    this.calefactorItemStacks[1] = smeltStack.func_77946_l();
                } else if (this.calefactorItemStacks[1].func_77969_a(smeltStack)) {
                    this.calefactorItemStacks[1].field_77994_a += smeltStack.field_77994_a;
                    if (this.calefactorItemStacks[1].field_77994_a > this.calefactorItemStacks[1].func_77976_d()) {
                        this.calefactorItemStacks[1].field_77994_a = this.calefactorItemStacks[1].func_77976_d();
                    }
                }
                if (Math.random() <= 0.25) {
                    if (this.calefactorItemStacks[5] == null) {
                        this.calefactorItemStacks[5] = new ItemStack((Item)ItemsCommonProxy.itemOre, 1, 0);
                    } else {
                        ++this.calefactorItemStacks[5].field_77994_a;
                        if (this.calefactorItemStacks[5].field_77994_a > this.calefactorItemStacks[5].func_77976_d()) {
                            this.calefactorItemStacks[5].field_77994_a = this.calefactorItemStacks[5].func_77976_d();
                        }
                    }
                }
            }
            --this.calefactorItemStacks[0].field_77994_a;
            if (this.calefactorItemStacks[0].field_77994_a <= 0) {
                this.calefactorItemStacks[0] = null;
            }
        }
    }

    public void handlePacket(byte[] data) {
        if (this.field_145850_b.field_72995_K) {
            AMDataReader rdr = new AMDataReader(data);
            switch (rdr.ID) {
                case 1: {
                    boolean bl = this.isCooking = rdr.getByte() == 1;
                    if (rdr.getByte() == 1) {
                        this.calefactorItemStacks[0] = rdr.getItemStack();
                        break;
                    }
                    this.calefactorItemStacks[0] = null;
                    break;
                }
            }
        }
    }

    protected void sendCookStatusUpdate(boolean isCooking) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        AMDataWriter writer = new AMDataWriter();
        writer.add((byte)1);
        writer.add(isCooking ? (byte)1 : 0);
        writer.add(this.calefactorItemStacks[0] != null ? (byte)1 : 0);
        if (this.calefactorItemStacks[0] != null) {
            writer.add(this.calefactorItemStacks[0]);
        }
        AMNetHandler.INSTANCE.sendCalefactorCookUpdate(this, writer.generate());
    }

    private short getModifiedCookTime() {
        int foci = this.numFociOfType(ItemFocusCharge.class);
        int base = 220;
        short modified = (short)((double)base * Math.pow(0.5, foci));
        return modified;
    }

    private float getCookTickPowerCost() {
        int fociMana = this.numFociOfType(ItemFocusMana.class);
        int fociCharge = this.numFociOfType(ItemFocusCharge.class);
        float base = 0.85f;
        return (float)((double)base * Math.pow(2.25, fociCharge) * Math.pow(0.5, fociMana));
    }

    private boolean isSmelting() {
        return this.timeSpentCooking != 0;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        boolean didSmeltItem = false;
        if (this.field_145850_b.field_72995_K) {
            this.incrementRotations();
            if (this.isCooking) {
                --this.particleCount;
                if (this.particleCount <= 0) {
                    this.particleCount = (int)(Math.random() * 20.0);
                    double rStartX = Math.random() > 0.5 ? (double)this.field_145851_c + 0.01 : (double)this.field_145851_c + 1.01;
                    double rStartY = (double)this.field_145848_d + 1.1;
                    double rStartZ = Math.random() > 0.5 ? (double)this.field_145849_e + 0.01 : (double)this.field_145849_e + 1.01;
                    double endX = (float)this.field_145851_c + 0.5f;
                    double endY = (double)((float)this.field_145848_d + 0.7f) + this.field_145850_b.field_73012_v.nextDouble() * 0.5;
                    double endZ = (float)this.field_145849_e + 0.5f;
                    AMCore.proxy.particleManager.BeamFromPointToPoint(this.field_145850_b, rStartX, rStartY, rStartZ, endX, endY, endZ, 0xFF8811);
                    if (this.field_145850_b.field_73012_v.nextBoolean()) {
                        AMParticle effect = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(this.field_145850_b, "smoke", endX, endY, endZ));
                        if (effect != null) {
                            effect.setIgnoreMaxAge(false);
                            effect.setMaxAge(60);
                            effect.AddParticleController(new ParticleFloatUpward(effect, 0.02f, 0.01f, 1, false));
                        }
                    } else {
                        AMParticle effect = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(this.field_145850_b, "explosion_2", endX, endY, endZ));
                        if (effect != null) {
                            effect.setIgnoreMaxAge(false);
                            effect.setMaxAge(10);
                            effect.setParticleScale(0.04f);
                            effect.func_70016_h(this.field_145850_b.field_73012_v.nextDouble() * (double)0.2f - (double)0.1f, 0.2f, this.field_145850_b.field_73012_v.nextDouble() * (double)0.2f - (double)0.1f);
                            effect.setAffectedByGravity();
                            effect.setDontRequireControllers();
                        }
                    }
                }
            } else {
                this.particleCount = 0;
            }
        }
        boolean powerCheck = PowerNodeRegistry.For(this.field_145850_b).checkPower(this, this.getCookTickPowerCost());
        if (this.canSmelt() && this.isSmelting() && powerCheck) {
            this.timeSpentCooking = (short)(this.timeSpentCooking + 1);
            if (this.timeSpentCooking >= this.getModifiedCookTime()) {
                if (!this.field_145850_b.field_72995_K) {
                    this.smeltItem();
                    didSmeltItem = true;
                } else {
                    this.field_145850_b.func_72980_b((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "arsmagica2:misc.calefactor.burn", 0.2f, 1.0f, true);
                }
                this.timeSpentCooking = 0;
                if (!this.field_145850_b.field_72995_K) {
                    this.sendCookStatusUpdate(false);
                }
            }
            if (!this.field_145850_b.field_72995_K) {
                if (PowerNodeRegistry.For(this.field_145850_b).checkPower(this, PowerTypes.DARK, this.getCookTickPowerCost()) && PowerNodeRegistry.For(this.field_145850_b).checkPower(this, PowerTypes.NEUTRAL, this.getCookTickPowerCost()) && PowerNodeRegistry.For(this.field_145850_b).checkPower(this, PowerTypes.LIGHT, this.getCookTickPowerCost())) {
                    PowerNodeRegistry.For(this.field_145850_b).consumePower(this, PowerTypes.DARK, this.getCookTickPowerCost());
                    PowerNodeRegistry.For(this.field_145850_b).consumePower(this, PowerTypes.NEUTRAL, this.getCookTickPowerCost());
                    PowerNodeRegistry.For(this.field_145850_b).consumePower(this, PowerTypes.LIGHT, this.getCookTickPowerCost());
                } else {
                    PowerNodeRegistry.For(this.field_145850_b).consumePower(this, PowerNodeRegistry.For(this.field_145850_b).getHighestPowerType(this), this.getCookTickPowerCost());
                }
            }
        } else if (!this.isSmelting() && this.canSmelt() && powerCheck) {
            this.timeSpentCooking = 1;
            if (!this.field_145850_b.field_72995_K) {
                this.sendCookStatusUpdate(true);
            }
        } else if (!this.canSmelt()) {
            this.timeSpentCooking = 0;
        }
    }

    public int getCookProgressScaled(int par1) {
        return this.timeSpentCooking * par1 / this.getModifiedCookTime();
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return entityplayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    @Override
    public boolean canProvidePower(PowerTypes type) {
        return false;
    }

    private int numFociOfType(Class type) {
        int count = 0;
        for (int i = 2; i < this.func_70302_i_(); ++i) {
            if (this.calefactorItemStacks[i] == null || !type.isInstance(this.calefactorItemStacks[i].func_77973_b())) continue;
            ++count;
        }
        return count;
    }

    public int func_70302_i_() {
        return 9;
    }

    public ItemStack func_70301_a(int var1) {
        if (var1 >= this.calefactorItemStacks.length) {
            return null;
        }
        return this.calefactorItemStacks[var1];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.calefactorItemStacks[i] != null) {
            if (this.calefactorItemStacks[i].field_77994_a <= j) {
                ItemStack itemstack = this.calefactorItemStacks[i];
                this.calefactorItemStacks[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.calefactorItemStacks[i].func_77979_a(j);
            if (this.calefactorItemStacks[i].field_77994_a == 0) {
                this.calefactorItemStacks[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        if (this.calefactorItemStacks[i] != null) {
            ItemStack itemstack = this.calefactorItemStacks[i];
            this.calefactorItemStacks[i] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.calefactorItemStacks[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "Calefactor";
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("CasterInventory", 10);
        this.calefactorItemStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            String tag = String.format("ArrayIndex", i);
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte byte0 = nbttagcompound1.func_74771_c(tag);
            if (byte0 < 0 || byte0 >= this.calefactorItemStacks.length) continue;
            this.calefactorItemStacks[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.calefactorItemStacks.length; ++i) {
            if (this.calefactorItemStacks[i] == null) continue;
            String tag = String.format("ArrayIndex", i);
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a(tag, (byte)i);
            this.calefactorItemStacks[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("CasterInventory", (NBTBase)nbttaglist);
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i == 0;
    }

    public int[] func_94128_d(int var1) {
        return new int[]{0, 1, 5};
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return i == 0;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return i == 1 || i == 5;
    }

    @Override
    public int getChargeRate() {
        int numFoci = this.numFociOfType(ItemFocusCharge.class);
        int base = 20;
        if (numFoci > 0) {
            base += 27 * numFoci;
        }
        return base;
    }

    @Override
    public boolean canRelayPower(PowerTypes type) {
        return false;
    }

    @Override
    public ItemStack[] getRunesInKey() {
        ItemStack[] runes = new ItemStack[]{this.calefactorItemStacks[6], this.calefactorItemStacks[7], this.calefactorItemStacks[8]};
        return runes;
    }

    @Override
    public boolean keystoneMustBeHeld() {
        return false;
    }

    @Override
    public boolean keystoneMustBeInActionBar() {
        return false;
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_145841_b(compound);
        S35PacketUpdateTileEntity packet = new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e), compound);
        return packet;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }
}

