/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks;

import am2.blocks.BlocksCommonProxy;
import am2.texture.ResourceManager;
import am2.worldgen.AM2FlowerGen;
import am2.worldgen.WitchwoodTreeHuge;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class WitchwoodSapling
extends BlockFlower {
    protected WitchwoodSapling() {
        super(0);
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (!world.field_72995_K) {
            super.func_149674_a(world, x, y, z, rand);
            int nearbyEssence = this.countNearbyEssencePools(world, x, y, z, rand);
            this.updateOrGrowTree(world, x, y, z, rand, nearbyEssence);
        }
    }

    private void updateOrGrowTree(World world, int x, int y, int z, Random rand, int numNearbyPools) {
        if (rand.nextInt(7) == 0) {
            int meta = world.func_72805_g(x, y, z) + numNearbyPools;
            if (meta > 15) {
                this.growTree(world, x, y, z, rand);
            } else {
                world.func_72921_c(x, y, z, meta, 2);
            }
        }
    }

    private void growTree(World world, int x, int y, int z, Random rand) {
        WitchwoodTreeHuge generator = new WitchwoodTreeHuge(true);
        world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 4);
        if (!generator.func_76484_a(world, rand, x, y, z)) {
            world.func_147465_d(x, y, z, (Block)this, 15, 4);
        } else {
            new AM2FlowerGen((Block)BlocksCommonProxy.aum, 0).func_76484_a(world, rand, x, y, z);
        }
    }

    private int countNearbyEssencePools(World world, int x, int y, int z, Random rand) {
        int essenceNearby = 0;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                Block block = world.func_147439_a(x + i, y - 1, z + j);
                int blockMeta = world.func_72805_g(x + i, y - 1, z + j);
                if (block != BlocksCommonProxy.liquidEssence || blockMeta != 0) continue;
                ++essenceNearby;
            }
        }
        return essenceNearby;
    }

    public IIcon func_149691_a(int par1, int par2) {
        return this.field_149761_L;
    }

    public void func_149651_a(IIconRegister par1IconRegister) {
        this.field_149761_L = ResourceManager.RegisterTexture("witchwoodSapling", par1IconRegister);
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack((Block)this));
    }
}

