/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.transport;

import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import cofh.api.inventory.IInventoryConnection;
import cofh.asm.relauncher.Strippable;
import cofh.core.util.CoreUtils;
import cofh.lib.util.position.IRotateableTile;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.minefactoryreloaded.tile.base.TileEntityBase;

@Strippable(value={"buildcraft.api.transport.IPipeConnection"})
public class TileEntityConveyor
extends TileEntityBase
implements IRotateableTile,
ISidedInventory,
IPipeConnection,
IInventoryConnection {
    private int _dye = -1;
    private boolean _rednetReversed = false;
    private boolean _isReversed = false;
    private boolean _gateReversed = false;
    private boolean _redNetAllowsActive = true;
    private boolean _gateAllowsActive = true;
    private boolean _conveyorActive = true;
    private boolean _isFast = false;

    public int getDyeColor() {
        return this._dye;
    }

    public void setDyeColor(int n) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this._dye != n) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this._dye = n;
    }

    public Packet func_145844_m() {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        nBTTagCompound.func_74768_a("dye", this._dye);
        nBTTagCompound.func_74757_a("conveyorActive", this._conveyorActive);
        nBTTagCompound.func_74757_a("isFast", this._isFast);
        S35PacketUpdateTileEntity s35PacketUpdateTileEntity = new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nBTTagCompound);
        return s35PacketUpdateTileEntity;
    }

    public void onDataPacket(NetworkManager networkManager, S35PacketUpdateTileEntity s35PacketUpdateTileEntity) {
        NBTTagCompound nBTTagCompound = s35PacketUpdateTileEntity.func_148857_g();
        this._dye = nBTTagCompound.func_74762_e("dye");
        this._conveyorActive = nBTTagCompound.func_74767_n("conveyorActive");
        this._isFast = nBTTagCompound.func_74767_n("isFast");
    }

    public boolean shouldRefresh(Block block, Block block2, int n, int n2, World world, int n3, int n4, int n5) {
        return block != block2;
    }

    public void rotate(ForgeDirection forgeDirection) {
        int n = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (n == 0) {
            if (this.isSideSolid(1, 0, ForgeDirection.WEST)) {
                this.rotateTo(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 4);
            } else if (this.isSideSolid(-1, 0, ForgeDirection.EAST)) {
                this.rotateTo(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 8);
            } else {
                this.rotateTo(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 1);
            }
        } else if (n == 4) {
            if (this.isSideSolid(-1, 0, ForgeDirection.EAST)) {
                this.rotateTo(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 8);
            } else {
                this.rotateTo(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 1);
            }
        } else if (n == 8) {
            this.rotateTo(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 1);
        } else if (n == 1) {
            if (this.isSideSolid(0, 1, ForgeDirection.NORTH)) {
                this.rotateTo(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 5);
            } else if (this.isSideSolid(0, -1, ForgeDirection.SOUTH)) {
                this.rotateTo(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 9);
            } else {
                this.rotateTo(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 2);
            }
        } else if (n == 5) {
            if (this.isSideSolid(0, -1, ForgeDirection.SOUTH)) {
                this.rotateTo(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 9);
            } else {
                this.rotateTo(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 2);
            }
        } else if (n == 9) {
            this.rotateTo(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 2);
        } else if (n == 2) {
            if (this.isSideSolid(-1, 0, ForgeDirection.EAST)) {
                this.rotateTo(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 6);
            } else if (this.isSideSolid(1, 0, ForgeDirection.WEST)) {
                this.rotateTo(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 10);
            } else {
                this.rotateTo(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 3);
            }
        } else if (n == 6) {
            if (this.isSideSolid(1, 0, ForgeDirection.WEST)) {
                this.rotateTo(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 10);
            } else {
                this.rotateTo(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 3);
            }
        } else if (n == 10) {
            this.rotateTo(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 3);
        } else if (n == 3) {
            if (this.isSideSolid(0, -1, ForgeDirection.SOUTH)) {
                this.rotateTo(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 7);
            } else if (this.isSideSolid(0, 1, ForgeDirection.NORTH)) {
                this.rotateTo(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 11);
            } else {
                this.rotateTo(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 0);
            }
        } else if (n == 7) {
            if (this.isSideSolid(0, 1, ForgeDirection.NORTH)) {
                this.rotateTo(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 11);
            } else {
                this.rotateTo(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 0);
            }
        } else if (n == 11) {
            this.rotateTo(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 0);
        }
    }

    private boolean isSideSolid(int n, int n2, ForgeDirection forgeDirection) {
        return this.field_145850_b.isSideSolid(this.field_145851_c + n, this.field_145848_d, this.field_145849_e + n2, forgeDirection) && (!this.field_145850_b.isSideSolid(this.field_145851_c + n, this.field_145848_d + 1, this.field_145849_e + n2, forgeDirection) || !this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) || !this.field_145850_b.isSideSolid(this.field_145851_c - n, this.field_145848_d - 1, this.field_145849_e - n2, ForgeDirection.UP));
    }

    private void rotateTo(World world, int n, int n2, int n3, int n4) {
        world.func_72921_c(n, n2, n3, n4, 2);
    }

    public void rotateDirectlyTo(int n) {
        if (n >= 2 && n < 6) {
            this.rotateTo(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, n - 2);
        }
    }

    public boolean canRotate() {
        return true;
    }

    public boolean canRotate(ForgeDirection forgeDirection) {
        return true;
    }

    public ForgeDirection getDirectionFacing() {
        return ForgeDirection.UNKNOWN;
    }

    public boolean canUpdate() {
        return false;
    }

    public boolean isFast() {
        return this._isFast;
    }

    public void setFast(boolean bl) {
        this._isFast = bl;
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("dyeColor", this._dye);
        nBTTagCompound.func_74757_a("isReversed", this._isReversed);
        nBTTagCompound.func_74757_a("redNetActive", this._conveyorActive);
        nBTTagCompound.func_74757_a("gateActive", this._gateAllowsActive);
        nBTTagCompound.func_74757_a("redNetReversed", this._rednetReversed);
        nBTTagCompound.func_74757_a("gateReversed", this._gateReversed);
        nBTTagCompound.func_74757_a("glowstone", this._isFast);
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        if (nBTTagCompound.func_74764_b("dyeColor")) {
            this._dye = nBTTagCompound.func_74762_e("dyeColor");
        }
        if (nBTTagCompound.func_74764_b("redNetActive")) {
            this._conveyorActive = nBTTagCompound.func_74767_n("redNetActive");
        }
        if (nBTTagCompound.func_74764_b("gateActive")) {
            this._gateAllowsActive = nBTTagCompound.func_74767_n("gateActive");
        }
        this._isReversed = nBTTagCompound.func_74767_n("isReversed");
        this._rednetReversed = nBTTagCompound.func_74767_n("redNetReversed");
        this._gateReversed = nBTTagCompound.func_74767_n("gateReversed");
        this._isFast = nBTTagCompound.func_74767_n("glowstone");
    }

    public int func_70302_i_() {
        return 7;
    }

    public ItemStack func_70301_a(int n) {
        return null;
    }

    public ItemStack func_70298_a(int n, int n2) {
        return null;
    }

    public ItemStack func_70304_b(int n) {
        return null;
    }

    public void func_70299_a(int n, ItemStack itemStack) {
        int n2 = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) & 3;
        float f = 0.5f;
        float f2 = 0.4f;
        float f3 = 0.5f;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        switch (n) {
            case 0: {
                f2 = 0.3f;
                d2 = 0.15;
                break;
            }
            case 1: {
                f2 = 0.8f;
                d2 = -0.15;
                break;
            }
            case 2: {
                f3 = 0.2f;
                d3 = 0.15;
                break;
            }
            case 3: {
                f3 = 0.8f;
                d3 = -0.15;
                break;
            }
            case 4: {
                f = 0.2f;
                d = 0.15;
                break;
            }
            case 5: {
                f = 0.8f;
                d = -0.15;
                break;
            }
        }
        if (n2 == 0) {
            d = 0.05;
        } else if (n2 == 1) {
            d3 = 0.05;
        } else if (n2 == 3) {
            d = -0.05;
        } else if (n2 == 3) {
            d3 = -0.05;
        }
        EntityItem entityItem = new EntityItem(this.field_145850_b, (double)((float)this.field_145851_c + f), (double)((float)this.field_145848_d + f2), (double)((float)this.field_145849_e + f3), itemStack.func_77946_l());
        entityItem.field_70159_w = d;
        entityItem.field_70181_x = d2;
        entityItem.field_70179_y = d3;
        entityItem.field_145804_b = 20;
        this.field_145850_b.func_72838_d((Entity)entityItem);
    }

    public String func_145825_b() {
        return "Conveyor Belt";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int n, ItemStack itemStack) {
        return this._conveyorActive;
    }

    public int[] func_94128_d(int n) {
        int[] nArray = new int[]{n};
        return nArray;
    }

    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        if (!this._conveyorActive) {
            return false;
        }
        switch (ForgeDirection.getOrientation((int)n2)) {
            case UP: {
                return (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) & 4) == 0;
            }
            case EAST: {
                int n3 = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return (n3 & 4) != 0 | (n3 & 3) != 0;
            }
            case SOUTH: {
                int n4 = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return (n4 & 4) != 0 | (n4 & 3) != 1;
            }
            case WEST: {
                int n5 = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return (n5 & 4) != 0 | (n5 & 3) != 2;
            }
            case NORTH: {
                int n6 = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return (n6 & 4) != 0 | (n6 & 3) != 3;
            }
        }
        return true;
    }

    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return false;
    }

    public void onRedNetChanged(int n) {
        if (this._redNetAllowsActive ^ n <= 0) {
            this._redNetAllowsActive = n <= 0;
            this.updateConveyorActive();
        }
        this._rednetReversed = n < 0;
        this.setReversed(this._gateReversed | this._rednetReversed);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void updateConveyorActive() {
        this.setConveyorActive(this._gateAllowsActive & this._redNetAllowsActive && !CoreUtils.isRedstonePowered((TileEntity)this));
    }

    public boolean getConveyorActive() {
        return this._conveyorActive;
    }

    public void setConveyorActive(boolean bl) {
        boolean bl2 = this._conveyorActive;
        this._conveyorActive = bl;
        if (bl2 ^ this._conveyorActive) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void setConveyerActiveFromGate(boolean bl) {
        boolean bl2 = this._gateAllowsActive;
        this._gateAllowsActive = bl;
        if (bl2 ^ this._gateAllowsActive) {
            this.updateConveyorActive();
        }
    }

    public boolean getConveyorReversed() {
        return this._isReversed;
    }

    private void setReversed(boolean bl) {
        boolean bl2 = this._isReversed;
        this._isReversed = bl;
        if (bl2 ^ this._isReversed) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getReversedMeta(this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e)), 3);
        }
    }

    private void reverseConveyor() {
        this._gateReversed = !this._isReversed;
        this.setReversed(this._rednetReversed | this._gateReversed);
    }

    private int getReversedMeta(int n) {
        int n2 = (n + 2) % 4;
        int n3 = n / 4 == 1 ? 2 : (n / 4 == 2 ? 1 : 0);
        return n3 * 4 + n2;
    }

    public IInventoryConnection.ConnectionType canConnectInventory(ForgeDirection forgeDirection) {
        return IInventoryConnection.ConnectionType.FORCE;
    }

    @Strippable(value={"buildcraft.api.transport.IPipeConnection"})
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType pipeType, ForgeDirection forgeDirection) {
        if (pipeType == IPipeTile.PipeType.ITEM) {
            return IPipeConnection.ConnectOverride.CONNECT;
        }
        if (forgeDirection == ForgeDirection.DOWN & pipeType == IPipeTile.PipeType.STRUCTURE) {
            return IPipeConnection.ConnectOverride.CONNECT;
        }
        return IPipeConnection.ConnectOverride.DISCONNECT;
    }
}

