/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.rednet;

import cofh.api.energy.EnergyStorage;
import cofh.lib.util.LinkedHashList;
import cofh.lib.util.position.BlockPosition;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.minefactoryreloaded.core.ArrayHashList;
import powercrystals.minefactoryreloaded.core.IGrid;
import powercrystals.minefactoryreloaded.net.GridTickHandler;
import powercrystals.minefactoryreloaded.tile.rednet.TileEntityRedNetEnergy;

public class RedstoneEnergyNetwork
implements IGrid {
    public static final int TRANSFER_RATE = 1000;
    public static final int STORAGE = 6000;
    static final GridTickHandler<RedstoneEnergyNetwork, TileEntityRedNetEnergy> HANDLER = GridTickHandler.energy;
    private ArrayHashList<TileEntityRedNetEnergy> nodeSet = new ArrayHashList();
    private LinkedHashList<TileEntityRedNetEnergy> conduitSet;
    private TileEntityRedNetEnergy master;
    private int overflowSelector;
    private boolean regenerating = false;
    EnergyStorage storage = new EnergyStorage(480, 80);
    public int distribution;
    public int distributionSide;

    protected RedstoneEnergyNetwork() {
        this.storage.setCapacity(6000);
        this.storage.setMaxTransfer(1000);
    }

    public RedstoneEnergyNetwork(TileEntityRedNetEnergy tileEntityRedNetEnergy) {
        this();
        this.conduitSet = new LinkedHashList();
        this.regenerating = true;
        this.addConduit(tileEntityRedNetEnergy);
        this.regenerating = false;
    }

    public int getNodeShare(TileEntityRedNetEnergy tileEntityRedNetEnergy) {
        int n = this.nodeSet.size();
        if (n <= 1) {
            return this.storage.getEnergyStored();
        }
        int n2 = 0;
        if (this.master == tileEntityRedNetEnergy) {
            n2 = this.storage.getEnergyStored() % n;
        }
        return n2 + this.storage.getEnergyStored() / n;
    }

    public void addConduit(TileEntityRedNetEnergy tileEntityRedNetEnergy) {
        if (this.conduitSet.add((Object)tileEntityRedNetEnergy) && !this.conduitAdded(tileEntityRedNetEnergy)) {
            return;
        }
        if (tileEntityRedNetEnergy.isNode) {
            if (this.nodeSet.add(tileEntityRedNetEnergy)) {
                this.nodeAdded(tileEntityRedNetEnergy);
            }
        } else if (!this.nodeSet.isEmpty()) {
            int n = this.getNodeShare(tileEntityRedNetEnergy);
            if (this.nodeSet.remove(tileEntityRedNetEnergy)) {
                tileEntityRedNetEnergy.energyForGrid = this.storage.extractEnergy(n, false);
                this.nodeRemoved(tileEntityRedNetEnergy);
            }
        }
    }

    public void removeConduit(TileEntityRedNetEnergy tileEntityRedNetEnergy) {
        this.conduitSet.remove((Object)tileEntityRedNetEnergy);
        if (!this.nodeSet.isEmpty()) {
            int n = this.getNodeShare(tileEntityRedNetEnergy);
            if (this.nodeSet.remove(tileEntityRedNetEnergy)) {
                tileEntityRedNetEnergy.energyForGrid = this.storage.extractEnergy(n, false);
                this.nodeRemoved(tileEntityRedNetEnergy);
            }
        }
    }

    public void regenerate() {
        this.regenerating = true;
        HANDLER.regenerateGrid(this);
    }

    public boolean isRegenerating() {
        return this.regenerating;
    }

    @Override
    public void markSweep() {
        RedstoneEnergyNetwork redstoneEnergyNetwork;
        this.destroyGrid();
        if (this.conduitSet.isEmpty()) {
            return;
        }
        TileEntityRedNetEnergy tileEntityRedNetEnergy = (TileEntityRedNetEnergy)this.conduitSet.poke();
        LinkedHashList<TileEntityRedNetEnergy> linkedHashList = this.conduitSet;
        this.nodeSet.clear();
        this.conduitSet = new LinkedHashList(Math.min(linkedHashList.size() / 6, 5));
        LinkedHashList linkedHashList2 = new LinkedHashList();
        LinkedHashList linkedHashList3 = new LinkedHashList();
        BlockPosition blockPosition = new BlockPosition(0, 0, 0);
        ForgeDirection[] forgeDirectionArray = ForgeDirection.VALID_DIRECTIONS;
        linkedHashList2.add((Object)tileEntityRedNetEnergy);
        linkedHashList3.add((Object)tileEntityRedNetEnergy);
        while (!linkedHashList2.isEmpty()) {
            tileEntityRedNetEnergy = (TileEntityRedNetEnergy)linkedHashList2.shift();
            this.addConduit(tileEntityRedNetEnergy);
            redstoneEnergyNetwork = tileEntityRedNetEnergy.func_145831_w();
            int n = 6;
            while (n-- > 0) {
                TileEntityRedNetEnergy tileEntityRedNetEnergy2;
                TileEntity tileEntity;
                blockPosition.x = tileEntityRedNetEnergy.field_145851_c;
                blockPosition.y = tileEntityRedNetEnergy.field_145848_d;
                blockPosition.z = tileEntityRedNetEnergy.field_145849_e;
                blockPosition.step(forgeDirectionArray[n]);
                if (!redstoneEnergyNetwork.func_72899_e(blockPosition.x, blockPosition.y, blockPosition.z) || !((tileEntity = blockPosition.getTileEntity((World)redstoneEnergyNetwork)) instanceof TileEntityRedNetEnergy) || !tileEntityRedNetEnergy.canInterface(tileEntityRedNetEnergy2 = (TileEntityRedNetEnergy)tileEntity, forgeDirectionArray[n ^ 1]) || !linkedHashList3.add((Object)tileEntityRedNetEnergy2)) continue;
                linkedHashList2.add((Object)tileEntityRedNetEnergy2);
            }
            linkedHashList.remove((Object)tileEntityRedNetEnergy);
        }
        if (!linkedHashList.isEmpty()) {
            redstoneEnergyNetwork = new RedstoneEnergyNetwork();
            redstoneEnergyNetwork.conduitSet = linkedHashList;
            redstoneEnergyNetwork.regenerating = true;
            redstoneEnergyNetwork.markSweep();
        }
        if (this.nodeSet.isEmpty()) {
            HANDLER.removeGrid(this);
        } else {
            HANDLER.addGrid(this);
        }
        this.rebalanceGrid();
        this.regenerating = false;
    }

    public void destroyGrid() {
        this.master = null;
        this.regenerating = true;
        for (TileEntityRedNetEnergy tileEntityRedNetEnergy : this.nodeSet) {
            this.destroyNode(tileEntityRedNetEnergy);
        }
        for (TileEntityRedNetEnergy tileEntityRedNetEnergy : this.conduitSet) {
            this.destroyConduit(tileEntityRedNetEnergy);
        }
        HANDLER.removeGrid(this);
    }

    public void destroyNode(TileEntityRedNetEnergy tileEntityRedNetEnergy) {
        tileEntityRedNetEnergy.energyForGrid = this.getNodeShare(tileEntityRedNetEnergy);
        tileEntityRedNetEnergy._grid = null;
    }

    public void destroyConduit(TileEntityRedNetEnergy tileEntityRedNetEnergy) {
        tileEntityRedNetEnergy._grid = null;
    }

    @Override
    public void doGridPreUpdate() {
        if (this.regenerating) {
            return;
        }
        if (this.nodeSet.isEmpty()) {
            HANDLER.removeGrid(this);
            return;
        }
        EnergyStorage energyStorage = this.storage;
        if (energyStorage.getEnergyStored() >= energyStorage.getMaxEnergyStored()) {
            return;
        }
        ForgeDirection[] forgeDirectionArray = ForgeDirection.VALID_DIRECTIONS;
        for (TileEntityRedNetEnergy tileEntityRedNetEnergy : this.nodeSet) {
            int n = 6;
            while (n-- > 0) {
                tileEntityRedNetEnergy.extract(forgeDirectionArray[n], energyStorage);
            }
        }
    }

    @Override
    public void doGridUpdate() {
        if (this.regenerating) {
            return;
        }
        if (this.nodeSet.isEmpty()) {
            HANDLER.removeGrid(this);
            return;
        }
        EnergyStorage energyStorage = this.storage;
        if (energyStorage.getEnergyStored() <= 0) {
            return;
        }
        ForgeDirection[] forgeDirectionArray = ForgeDirection.VALID_DIRECTIONS;
        int n = this.nodeSet.size();
        int n2 = energyStorage.getEnergyStored() / n;
        int n3 = n2 / 6;
        this.distribution = n2;
        this.distributionSide = n3;
        int n4 = this.overflowSelector = (this.overflowSelector + 1) % n;
        TileEntityRedNetEnergy tileEntityRedNetEnergy = this.nodeSet.get(n4);
        if (n3 > 0) {
            for (TileEntityRedNetEnergy tileEntityRedNetEnergy2 : this.nodeSet) {
                if (tileEntityRedNetEnergy2 == tileEntityRedNetEnergy) continue;
                int n5 = 0;
                int n6 = 6;
                while (n6-- > 0) {
                    n5 += tileEntityRedNetEnergy2.transfer(forgeDirectionArray[n6], n3);
                }
                if (n5 <= 0) continue;
                energyStorage.modifyEnergyStored(-n5);
            }
        }
        if ((n3 = (n2 += energyStorage.getEnergyStored() % n) / 6) > 0) {
            int n7 = 0;
            int n8 = 6;
            while (n8-- > 0) {
                n7 += tileEntityRedNetEnergy.transfer(forgeDirectionArray[n8], n3);
            }
            if (n7 > 0) {
                energyStorage.modifyEnergyStored(-n7);
            }
        } else if (n2 > 0) {
            int n9;
            int n10 = 6;
            for (n9 = 0; n10-- > 0 && n9 < n2; n9 += tileEntityRedNetEnergy.transfer(forgeDirectionArray[n10], n2 - n9)) {
            }
            if (n9 > 0) {
                energyStorage.modifyEnergyStored(-n9);
            }
        }
    }

    public boolean canMergeGrid(RedstoneEnergyNetwork redstoneEnergyNetwork) {
        return redstoneEnergyNetwork != null;
    }

    public void mergeGrid(RedstoneEnergyNetwork redstoneEnergyNetwork) {
        if (redstoneEnergyNetwork == this) {
            return;
        }
        boolean bl = this.regenerating || redstoneEnergyNetwork.regenerating;
        redstoneEnergyNetwork.destroyGrid();
        if (!this.regenerating & bl) {
            this.regenerate();
        }
        this.regenerating = true;
        for (TileEntityRedNetEnergy tileEntityRedNetEnergy : redstoneEnergyNetwork.conduitSet) {
            this.addConduit(tileEntityRedNetEnergy);
        }
        this.regenerating = bl;
        redstoneEnergyNetwork.conduitSet.clear();
        redstoneEnergyNetwork.nodeSet.clear();
    }

    public void nodeAdded(TileEntityRedNetEnergy tileEntityRedNetEnergy) {
        if (this.master == null) {
            this.master = tileEntityRedNetEnergy;
            HANDLER.addGrid(this);
        }
        this.rebalanceGrid();
        this.storage.modifyEnergyStored(tileEntityRedNetEnergy.energyForGrid);
    }

    public void nodeRemoved(TileEntityRedNetEnergy tileEntityRedNetEnergy) {
        this.rebalanceGrid();
        if (tileEntityRedNetEnergy == this.master) {
            if (this.nodeSet.isEmpty()) {
                this.master = null;
                HANDLER.removeGrid(this);
            } else {
                this.master = this.nodeSet.get(0);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean conduitAdded(TileEntityRedNetEnergy tileEntityRedNetEnergy) {
        if (tileEntityRedNetEnergy._grid != null) {
            if (tileEntityRedNetEnergy._grid == this) return false;
            this.conduitSet.remove((Object)tileEntityRedNetEnergy);
            if (!this.canMergeGrid(tileEntityRedNetEnergy._grid)) return false;
            this.mergeGrid(tileEntityRedNetEnergy._grid);
            return true;
        } else {
            tileEntityRedNetEnergy.setGrid(this);
        }
        return true;
    }

    public void rebalanceGrid() {
        this.storage.setCapacity(this.nodeSet.size() * 6000);
    }

    public int getConduitCount() {
        return this.conduitSet.size();
    }

    public int getNodeCount() {
        return this.nodeSet.size();
    }

    public String toString() {
        return "RedstoneEnergyNetwork@" + Integer.toString(this.hashCode()) + "; master:" + this.master + "; regenerating:" + this.regenerating + "; isTicking:" + HANDLER.isGridTicking(this);
    }
}

