/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cofh.lib.util.position.BlockPosition;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiMobRouter;
import powercrystals.minefactoryreloaded.gui.container.ContainerMobRouter;
import powercrystals.minefactoryreloaded.item.ItemSafariNet;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public class TileEntityMobRouter
extends TileEntityFactoryPowered {
    protected int _matchMode;
    protected boolean _blacklist;

    public TileEntityMobRouter() {
        super(Machine.MobRouter);
        TileEntityMobRouter.createEntityHAM(this);
        this.setCanRotate(true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiMobRouter(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerMobRouter getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerMobRouter(this, inventoryPlayer);
    }

    @Override
    protected boolean activateMachine() {
        Class clazz;
        if (this._inventory[0] != null) {
            if (!ItemSafariNet.isSafariNet(this._inventory[0]) || ItemSafariNet.isSingleUse(this._inventory[0])) {
                return false;
            }
            clazz = ItemSafariNet.getEntityClass(this._inventory[0]);
        } else {
            clazz = EntityLivingBase.class;
        }
        List list = this.field_145850_b.func_72872_a(EntityLivingBase.class, this._areaManager.getHarvestArea().toAxisAlignedBB());
        List<Class<?>> list2 = MFRRegistry.getSafariNetBlacklist();
        switch (this._matchMode) {
            case 3: {
                if (clazz != EntityLivingBase.class) {
                    clazz = clazz.getSuperclass();
                }
            }
            case 2: {
                if (clazz == EntityLivingBase.class) break;
                clazz = clazz.getSuperclass();
            }
        }
        for (EntityLivingBase entityLivingBase : list) {
            boolean bl;
            Class<?> clazz2 = entityLivingBase.getClass();
            if (list2.contains(clazz2) || EntityPlayer.class.isAssignableFrom(clazz2)) continue;
            switch (this._matchMode) {
                case 0: {
                    bl = clazz == clazz2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    bl = clazz.isAssignableFrom(clazz2);
                    break;
                }
                default: {
                    bl = false;
                }
            }
            if (!(bl ^ this._blacklist)) continue;
            BlockPosition blockPosition = BlockPosition.fromRotateableTile((TileEntity)this);
            blockPosition.moveBackwards(1);
            entityLivingBase.func_70107_b((double)blockPosition.x + 0.5, (double)blockPosition.y + 0.5, (double)blockPosition.z + 0.5);
            return true;
        }
        this.setIdleTicks(this.getIdleTicksMax());
        return false;
    }

    public boolean getWhiteList() {
        return !this._blacklist;
    }

    public void setWhiteList(boolean bl) {
        this._blacklist = !bl;
    }

    public int getMatchMode() {
        return this._matchMode;
    }

    public void setMatchMode(int n) {
        this._matchMode = n < 0 ? 3 : n % 4;
    }

    public int func_70302_i_() {
        return 1;
    }

    @Override
    public int getWorkMax() {
        return 1;
    }

    @Override
    public int getIdleTicksMax() {
        return 200;
    }

    @Override
    public void writePortableData(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        nBTTagCompound.func_74768_a("mode", this._matchMode);
        nBTTagCompound.func_74757_a("blacklist", this._blacklist);
    }

    @Override
    public void readPortableData(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        this.setMatchMode(nBTTagCompound.func_74762_e("mode"));
        this._blacklist = nBTTagCompound.func_74767_n("blacklist");
    }

    @Override
    public void writeItemNBT(NBTTagCompound nBTTagCompound) {
        super.writeItemNBT(nBTTagCompound);
        nBTTagCompound.func_74768_a("mode", this._matchMode);
        nBTTagCompound.func_74757_a("blacklist", this._blacklist);
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.setMatchMode(nBTTagCompound.func_74762_e("mode"));
        this._blacklist = nBTTagCompound.func_74767_n("blacklist");
    }
}

