/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.block.fluid;

import cofh.core.fluid.BlockFluidCoFHBase;
import cofh.lib.util.RegistryUtils;
import cofh.lib.util.WeightedRandomItemStack;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.api.rednet.connectivity.IRedNetDecorative;
import powercrystals.minefactoryreloaded.setup.MFRThings;

public class BlockFactoryFluid
extends BlockFluidCoFHBase
implements IRedNetDecorative {
    private static DamageSource steam = new DamageSource("steam");
    public static final Material material = new MaterialLiquid(MapColor.field_151662_n);
    @SideOnly(value=Side.CLIENT)
    protected IIcon _iconFlowing;
    @SideOnly(value=Side.CLIENT)
    protected IIcon _iconStill;
    @SideOnly(value=Side.CLIENT)
    public int color;
    protected String fluidName;

    private static Fluid ensureFluid(String string) {
        Fluid fluid = FluidRegistry.getFluid((String)string);
        if (fluid.canBePlacedInWorld()) {
            ReflectionHelper.setPrivateValue(Fluid.class, (Object)fluid, null, (String[])new String[]{"block"});
        }
        return fluid;
    }

    public BlockFactoryFluid(String string) {
        this(string, Material.field_151586_h);
    }

    public BlockFactoryFluid(String string, Material material) {
        super(BlockFactoryFluid.ensureFluid(string), material, string);
        steam.func_76348_h().func_76361_j().func_76351_m();
        steam.func_151518_m();
        this.func_149663_c("mfr." + string + ".still");
        this.func_149711_c(100.0f);
        this.func_149713_g(3);
        this.setDisplaceFluids(true);
        this.fluidName = string;
    }

    public void func_149670_a(World world, int n, int n2, int n3, Entity entity) {
        super.func_149670_a(world, n, n2, n3, entity);
        if (entity instanceof EntityLivingBase) {
            NBTTagCompound nBTTagCompound = entity.getEntityData();
            if (world.field_72995_K || nBTTagCompound.func_74763_f("mfr:fluidTimer" + this.fluidName) > world.func_82737_E()) {
                return;
            }
            nBTTagCompound.func_74772_a("mfr:fluidTimer" + this.fluidName, world.func_82737_E() + 40L);
            EntityLivingBase entityLivingBase = (EntityLivingBase)entity;
            if (this == MFRThings.milkLiquid) {
                entityLivingBase.func_70690_d(new PotionEffect(Potion.field_76422_e.field_76415_H, 120, 0, true));
            } else if (this == MFRThings.sludgeLiquid) {
                entityLivingBase.func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 240, 0));
                entityLivingBase.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 240, 0, true));
                entityLivingBase.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 320, 0, true));
            } else if (this == MFRThings.sewageLiquid) {
                entityLivingBase.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, 240, 0, true));
                entityLivingBase.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 240, 0));
                entityLivingBase.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 240, 0, true));
            } else if (this == MFRThings.essenceLiquid) {
                entityLivingBase.func_70690_d(new PotionEffect(Potion.field_76439_r.field_76415_H, 1200, 0, true));
            } else if (this == MFRThings.biofuelLiquid) {
                entityLivingBase.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 240, 0, true));
            } else if (this == MFRThings.steamFluid) {
                entityLivingBase.func_70097_a(steam, 6.0f);
            }
        }
    }

    public int getLightValue(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        int n4 = super.getLightValue(iBlockAccess, n, n2, n3);
        if (((BlockFluidBase)this).maxScaledLight != 0) {
            n4 = Math.max(n4, 2);
        }
        return n4;
    }

    public void func_149726_b(World world, int n, int n2, int n3) {
        super.func_149726_b(world, n, n2, n3);
        this.checkCanStay(world, n, n2, n3, world.field_73012_v);
    }

    public void func_149674_a(World world, int n, int n2, int n3, Random random) {
        this.checkCanStay(world, n, n2, n3, random);
        super.func_149674_a(world, n, n2, n3, random);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void checkCanStay(World world, int n, int n2, int n3, Random random) {
        if (!world.field_73011_w.field_76575_d) return;
        if (!this.isSourceBlock((IBlockAccess)world, n, n2, n3)) {
            if (!world.func_147468_f(n, n2, n3)) return;
            return;
        }
        ItemStack itemStack = null;
        Block block = Blocks.field_150350_a;
        if (this == MFRThings.milkLiquid) {
            if (random.nextInt(50) == 0) {
                itemStack = new ItemStack(Items.field_151100_aR, random.nextInt(2), 15);
            }
        } else if (this == MFRThings.sludgeLiquid) {
            itemStack = ((WeightedRandomItemStack)WeightedRandom.func_76271_a((Random)random, MFRRegistry.getSludgeDrops())).getStack();
        } else if (this == MFRThings.sewageLiquid) {
            itemStack = new ItemStack(MFRThings.fertilizerItem, 1 + random.nextInt(2));
        } else {
            if (this == MFRThings.essenceLiquid) {
                int n4;
                if (!world.func_147468_f(n, n2, n3)) return;
                for (int i = random.nextInt(5) + 10; i > 0; i -= n4) {
                    n4 = EntityXPOrb.func_70527_a((int)i);
                    world.func_72838_d((Entity)new EntityXPOrb(world, (double)n + random.nextDouble(), (double)n2 + random.nextDouble(), (double)n3 + random.nextDouble(), n4));
                }
                this.fizz(world, n, n2, n3, random);
                return;
            }
            if (this == MFRThings.meatLiquid) {
                itemStack = random.nextInt(5) != 0 ? new ItemStack(MFRThings.meatIngotRawItem, random.nextInt(2)) : new ItemStack(MFRThings.meatIngotCookedItem, random.nextInt(2));
            } else if (this == MFRThings.pinkSlimeLiquid) {
                itemStack = random.nextBoolean() ? new ItemStack(MFRThings.pinkSlimeItem, random.nextInt(3)) : (random.nextInt(5) != 0 ? new ItemStack(MFRThings.meatNuggetRawItem, random.nextInt(2)) : new ItemStack(MFRThings.meatNuggetCookedItem, random.nextInt(2)));
            } else if (this == MFRThings.chocolateMilkLiquid) {
                if (random.nextBoolean()) {
                    itemStack = new ItemStack(Items.field_151100_aR, random.nextInt(2), 3);
                }
            } else if (this == MFRThings.mushroomSoupLiquid) {
                if (random.nextInt(5) == 0) {
                    block = random.nextBoolean() ? Blocks.field_150338_P : Blocks.field_150337_Q;
                } else {
                    itemStack = random.nextBoolean() ? new ItemStack((Block)Blocks.field_150338_P, random.nextInt(2)) : new ItemStack((Block)Blocks.field_150337_Q, random.nextInt(2));
                }
            }
        }
        if (!world.func_147465_d(n, n2, n3, block, 0, 3)) return;
        if (itemStack != null && itemStack.field_77994_a > 0) {
            this.func_149642_a(world, n, n2, n3, itemStack);
        }
        this.fizz(world, n, n2, n3, random);
    }

    protected void fizz(World world, int n, int n2, int n3, Random random) {
        world.func_72908_a((double)n + 0.5, (double)n2 + 0.5, (double)n3 + 0.5, "random.fizz", 0.5f, 2.6f + (random.nextFloat() - random.nextFloat()) * 0.8f);
        for (int i = 0; i < 8; ++i) {
            world.func_72869_a("largesmoke", (double)n + random.nextDouble(), (double)n2 + random.nextDouble(), (double)n3 + random.nextDouble(), 0.0, 0.0, 0.0);
        }
    }

    public String func_149739_a() {
        return "fluid." + ((Block)this).field_149770_b;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iIconRegister) {
        this.setIcons(iIconRegister.func_94245_a("minefactoryreloaded:" + this.func_149739_a()), iIconRegister.func_94245_a("minefactoryreloaded:" + this.func_149739_a().replace(".still", ".flowing")));
    }

    @SideOnly(value=Side.CLIENT)
    public void setIcons(IIcon iIcon, IIcon iIcon2) {
        this._iconStill = iIcon;
        this._iconFlowing = iIcon2;
        this.color = RegistryUtils.getBlockTextureColor((String)iIcon.func_94215_i());
        this.setParticleColor(this.color);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int n, int n2) {
        return n <= 1 ? this._iconStill : this._iconFlowing;
    }
}

